/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.AllocationType;
import com.google.code.facebookapi.ApplicationProperty;
import com.google.code.facebookapi.ApplicationPropertySet;
import com.google.code.facebookapi.BatchQuery;
import com.google.code.facebookapi.BundleStoryTemplate;
import com.google.code.facebookapi.ErrorCode;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookJaxbRestClient;
import com.google.code.facebookapi.FacebookMethod;
import com.google.code.facebookapi.FacebookSignatureUtil;
import com.google.code.facebookapi.IFacebookMethod;
import com.google.code.facebookapi.IFacebookRestClient;
import com.google.code.facebookapi.IFeedImage;
import com.google.code.facebookapi.IPair;
import com.google.code.facebookapi.MarketListing;
import com.google.code.facebookapi.MarketListingStatus;
import com.google.code.facebookapi.MarketplaceListing;
import com.google.code.facebookapi.Metric;
import com.google.code.facebookapi.PageProfileField;
import com.google.code.facebookapi.Pair;
import com.google.code.facebookapi.Permission;
import com.google.code.facebookapi.PhotoTag;
import com.google.code.facebookapi.ProfileField;
import com.google.code.facebookapi.ProfileFieldItem;
import com.google.code.facebookapi.ProfileInfoField;
import com.google.code.facebookapi.TemplatizedAction;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensibleClient<T>
implements IFacebookRestClient<T> {
    protected static Log log = LogFactory.getLog(ExtensibleClient.class);
    public static URL SERVER_URL = null;
    public static URL HTTPS_SERVER_URL = null;
    protected static JAXBContext JAXB_CONTEXT;
    protected URL _serverUrl;
    protected int _timeout;
    protected int _readTimeout;
    protected final String _apiKey;
    protected final String _secret;
    protected boolean _isDesktop;
    protected String cacheSessionKey;
    protected Long cacheUserId;
    protected Long cacheSessionExpires;
    protected String cacheSessionSecret;
    protected String rawResponse;
    protected boolean batchMode;
    protected List<BatchQuery> queries;
    protected String permissionsApiKey = null;
    public static final int NUM_AUTOAPPENDED_PARAMS = 6;
    protected File _uploadFile = null;
    protected static final String CRLF = "\r\n";
    protected static final String PREF = "--";
    protected static final int UPLOAD_BUFFER_SIZE = 512;
    public static final String MARKETPLACE_STATUS_DEFAULT = "DEFAULT";
    public static final String MARKETPLACE_STATUS_NOT_SUCCESS = "NOT_SUCCESS";
    public static final String MARKETPLACE_STATUS_SUCCESS = "SUCCESS";
    protected Boolean cacheAppAdded;

    public static void initJaxbSupport() {
        if (JAXB_CONTEXT == null) {
            try {
                JAXB_CONTEXT = JAXBContext.newInstance((String)"com.google.code.facebookapi.schema");
            }
            catch (JAXBException ex) {
                log.error((Object)("MalformedURLException: " + ex.getMessage()), (Throwable)ex);
                JAXB_CONTEXT = null;
            }
        }
    }

    protected ExtensibleClient(String apiKey, String secret) {
        this(SERVER_URL, apiKey, secret, null);
    }

    protected ExtensibleClient(String apiKey, String secret, int timeout) {
        this(SERVER_URL, apiKey, secret, null, timeout);
    }

    protected ExtensibleClient(String apiKey, String secret, String sessionKey) {
        this(SERVER_URL, apiKey, secret, sessionKey);
    }

    protected ExtensibleClient(String apiKey, String secret, String sessionKey, int connectionTimeout) {
        this(SERVER_URL, apiKey, secret, sessionKey, connectionTimeout);
    }

    protected ExtensibleClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey);
    }

    protected ExtensibleClient(String serverAddr, String apiKey, String secret, String sessionKey, int connectionTimeout) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey, connectionTimeout);
    }

    protected ExtensibleClient(URL serverUrl, String apiKey, String secret, String sessionKey, int timeout) {
        this(serverUrl, apiKey, secret, sessionKey);
        this._timeout = timeout;
    }

    protected ExtensibleClient(URL serverUrl, String apiKey, String secret, String sessionKey, int timeout, int readTimeout) {
        this(serverUrl, apiKey, secret, sessionKey);
        this._timeout = timeout;
        this._readTimeout = readTimeout;
    }

    protected ExtensibleClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        this.cacheSessionKey = sessionKey;
        this._apiKey = apiKey;
        this._secret = secret;
        this._serverUrl = null != serverUrl ? serverUrl : SERVER_URL;
        this._timeout = -1;
        this._readTimeout = -1;
        this.batchMode = false;
        this.queries = new ArrayList<BatchQuery>();
        if (this instanceof FacebookJaxbRestClient) {
            ExtensibleClient.initJaxbSupport();
        }
    }

    @Override
    public void beginPermissionsMode(String apiKey) {
        this.permissionsApiKey = apiKey;
    }

    @Override
    public void endPermissionsMode() {
        this.permissionsApiKey = null;
    }

    @Override
    public JAXBContext getJaxbContext() {
        return JAXB_CONTEXT;
    }

    @Override
    public void setJaxbContext(JAXBContext context) {
        JAXB_CONTEXT = context;
    }

    public abstract String getResponseFormat();

    public String getSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setSessionSecret(String key) {
        this.cacheSessionSecret = key;
    }

    private static CharSequence delimit(Iterable iterable) {
        if (iterable == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Object item : iterable) {
            if (notFirst) {
                buffer.append(",");
            } else {
                notFirst = true;
            }
            buffer.append(item.toString());
        }
        return buffer;
    }

    @Override
    public Boolean getCacheAppAdded() {
        return this.cacheAppAdded;
    }

    @Override
    public void setCacheAppAdded(Boolean cacheAppAdded) {
        this.cacheAppAdded = cacheAppAdded;
    }

    @Override
    public String getCacheSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setCacheSessionSecret(String cacheSessionSecret) {
        this.cacheSessionSecret = cacheSessionSecret;
    }

    @Override
    public void setCacheSession(String cacheSessionKey, Long cacheUserId, Long cacheSessionExpires) {
        this.setCacheSessionKey(cacheSessionKey);
        this.setCacheUserId(cacheUserId);
        this.setCacheSessionExpires(cacheSessionExpires);
    }

    @Override
    public Long getCacheSessionExpires() {
        return this.cacheSessionExpires;
    }

    public void setCacheSessionExpires(Long cacheSessionExpires) {
        this.cacheSessionExpires = cacheSessionExpires;
    }

    @Override
    public String getCacheSessionKey() {
        return this.cacheSessionKey;
    }

    public void setCacheSessionKey(String cacheSessionKey) {
        this.cacheSessionKey = cacheSessionKey;
    }

    @Override
    public Long getCacheUserId() {
        return this.cacheUserId;
    }

    public void setCacheUserId(Long cacheUserId) {
        this.cacheUserId = cacheUserId;
    }

    @Override
    public T friends_areFriends(long userId1, long userId2) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, ExtensibleClient.newPair("uids1", userId1), ExtensibleClient.newPair("uids2", userId2));
    }

    @Override
    public T friends_areFriends(Collection<Long> userIds1, Collection<Long> userIds2) throws FacebookException, IOException {
        if (userIds1 == null || userIds2 == null || userIds1.isEmpty() || userIds2.isEmpty()) {
            throw new IllegalArgumentException("Collections passed to friends_areFriends should not be null or empty");
        }
        if (userIds1.size() != userIds2.size()) {
            throw new IllegalArgumentException(String.format("Collections should be same size: got userIds1: %d elts; userIds2: %d elts", userIds1.size(), userIds2.size()));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, ExtensibleClient.newPair("uids1", ExtensibleClient.delimit(userIds1)), ExtensibleClient.newPair("uids2", ExtensibleClient.delimit(userIds2)));
    }

    @Override
    public boolean fbml_refreshRefUrl(String url) throws FacebookException, IOException {
        return this.fbml_refreshRefUrl(new URL(url));
    }

    protected void handleFeedImages(List<Pair<String, CharSequence>> params, Collection<? extends IPair<? extends Object, URL>> images) {
        if (images != null && images.size() > 4) {
            throw new IllegalArgumentException("At most four images are allowed, got " + Integer.toString(images.size()));
        }
        if (null != images && !images.isEmpty()) {
            int image_count = 0;
            for (IPair<? extends Object, URL> iPair : images) {
                ++image_count;
                assert (null != iPair.getFirst()) : "Image URL must be provided";
                String name = "image_" + image_count;
                params.add(ExtensibleClient.newPair(name, iPair.getFirst().toString()));
                if (null == iPair.getSecond()) continue;
                params.add(ExtensibleClient.newPair(name + "_link", iPair.getSecond().toString()));
            }
        }
    }

    @Override
    public abstract String auth_getSession(String var1) throws FacebookException, IOException;

    @Override
    public boolean feed_publishTemplatizedAction(Long actorId, CharSequence titleTemplate) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(actorId, titleTemplate, null, null, null, null, null, null);
    }

    @Override
    public boolean feed_publishTemplatizedAction(Long actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, targetIds, images, null);
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(Integer actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction((long)actorId, titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, targetIds, images);
    }

    @Override
    public T groups_getMembers(Number groupId) throws FacebookException, IOException {
        assert (null != groupId);
        return this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET_MEMBERS, ExtensibleClient.newPair("gid", groupId.toString()));
    }

    private static String encode(CharSequence target) {
        if (target == null) {
            return "";
        }
        String result = ((Object)target).toString();
        try {
            result = URLEncoder.encode(result, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            log.warn((Object)("Unsuccessful attempt to encode '" + result + "' into UTF8"), (Throwable)ex);
        }
        return result;
    }

    @Override
    public T events_getMembers(Number eventId) throws FacebookException, IOException {
        assert (null != eventId);
        return this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_MEMBERS, ExtensibleClient.newPair("eid", eventId.toString()));
    }

    @Override
    public T friends_getAppUsers() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_APP_USERS, new Pair[0]);
    }

    @Override
    public T fql_query(CharSequence query) throws FacebookException, IOException {
        assert (null != query);
        return this.callMethod((IFacebookMethod)FacebookMethod.FQL_QUERY, ExtensibleClient.newPair("query", query));
    }

    private String generateSignature(List<String> params, boolean requiresSession) {
        String secret = this.isDesktop() && requiresSession ? this.cacheSessionSecret : this._secret;
        return FacebookSignatureUtil.generateSignature(params, secret);
    }

    @Override
    public T photos_get(Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get(null, null, photoIds);
    }

    @Override
    public T photos_get(Long subjId, Long albumId) throws FacebookException, IOException {
        return this.photos_get(subjId, albumId, null);
    }

    @Override
    public T photos_get(Long subjId, Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get(subjId, null, photoIds);
    }

    @Override
    public T photos_get(Long subjId) throws FacebookException, IOException {
        return this.photos_get(subjId, null, null);
    }

    @Override
    public T photos_get(Long subjId, Long albumId, Collection<Long> photoIds) throws FacebookException, IOException {
        boolean hasPhotoIds;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_GET.numParams());
        boolean hasUserId = null != subjId && 0L != subjId;
        boolean hasAlbumId = null != albumId && 0L != albumId;
        boolean bl = hasPhotoIds = null != photoIds && !photoIds.isEmpty();
        if (!(hasUserId || hasAlbumId || hasPhotoIds)) {
            throw new IllegalArgumentException("At least one of photoIds, albumId, or subjId must be provided");
        }
        if (hasUserId) {
            params.add(ExtensibleClient.newPair("subj_id", subjId));
        }
        if (hasAlbumId) {
            params.add(ExtensibleClient.newPair("aid", albumId));
        }
        if (hasPhotoIds) {
            params.add(ExtensibleClient.newPair("pids", ExtensibleClient.delimit(photoIds)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET, params);
    }

    @Override
    public T photos_getTags(Collection<Long> photoIds) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_TAGS, ExtensibleClient.newPair("pids", ExtensibleClient.delimit(photoIds)));
    }

    @Override
    public T groups_get(Long userId, Collection<Long> groupIds) throws FacebookException, IOException {
        boolean hasGroups;
        boolean bl = hasGroups = null != groupIds && !groupIds.isEmpty();
        if (null != userId) {
            return hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, ExtensibleClient.newPair("uid", userId.toString()), ExtensibleClient.newPair("gids", ExtensibleClient.delimit(groupIds))) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, ExtensibleClient.newPair("uid", userId.toString()));
        }
        return hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, ExtensibleClient.newPair("gids", ExtensibleClient.delimit(groupIds))) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair[0]);
    }

    protected T callMethod(IFacebookMethod method, Pair<String, CharSequence> ... paramPairs) throws FacebookException, IOException {
        return this.callMethod(method, Arrays.asList(paramPairs));
    }

    protected T callMethod(IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException, IOException {
        String xmlResp;
        String line;
        boolean includeSession;
        this.rawResponse = null;
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (this.permissionsApiKey != null) {
            params.put("call_as_apikey", this.permissionsApiKey);
        }
        params.put("method", method.methodName());
        params.put("api_key", this._apiKey);
        params.put("v", "1.0");
        String format = this.getResponseFormat();
        if (null != format) {
            params.put("format", format);
        }
        params.put("call_id", Long.toString(System.currentTimeMillis()));
        boolean bl = includeSession = method.requiresSession() && this.cacheSessionKey != null;
        if (includeSession) {
            params.put("session_key", this.cacheSessionKey);
        }
        for (Pair<String, CharSequence> p : paramPairs) {
            CharSequence oldVal = params.put((String)p.first, FacebookSignatureUtil.toString((CharSequence)p.second));
            if (oldVal == null) continue;
            log.warn((Object)String.format("For parameter %s, overwrote old value %s with new value %s.", p.first, oldVal, p.second));
        }
        assert (!params.containsKey("sig"));
        String signature = this.generateSignature(FacebookSignatureUtil.convert(params.entrySet()), includeSession);
        params.put("sig", signature);
        if (this.batchMode) {
            boolean addToBatch = true;
            if (method.methodName().equals(FacebookMethod.USERS_GET_LOGGED_IN_USER.methodName())) {
                Exception trace = new Exception();
                StackTraceElement[] traceElems = trace.getStackTrace();
                int index = 0;
                for (StackTraceElement elem : traceElems) {
                    if (elem.getMethodName().indexOf("_") != -1) {
                        StackTraceElement caller = traceElems[index + 1];
                        if (!caller.getClassName().equals(ExtensibleClient.class.getName()) || caller.getMethodName().startsWith("auth_")) break;
                        addToBatch = false;
                        break;
                    }
                    ++index;
                }
            }
            if (addToBatch) {
                this.queries.add(new BatchQuery(method, params));
            }
            return null;
        }
        boolean doHttps = this.isDesktop() && FacebookMethod.AUTH_GET_SESSION.equals(method);
        boolean doEncode = true;
        InputStream data = method.takesFile() ? this.postFileRequest(method.methodName(), params, doEncode) : this.postRequest(method.methodName(), params, doHttps, doEncode);
        BufferedReader in = new BufferedReader(new InputStreamReader(data, "UTF-8"));
        StringBuilder buffer = new StringBuilder();
        boolean insideTagBody = false;
        while ((line = in.readLine()) != null) {
            if ("xml".equalsIgnoreCase(this.getResponseFormat()) && method != FacebookMethod.BATCH_RUN) {
                if (line.trim().startsWith("<") && line.contains(">")) {
                    insideTagBody = true;
                }
                if (line.trim().endsWith(">")) {
                    insideTagBody = false;
                }
                if (insideTagBody) {
                    line = line + ",";
                }
            }
            buffer.append(line);
        }
        this.rawResponse = xmlResp = buffer.toString();
        return this.parseCallResult(new ByteArrayInputStream(xmlResp.getBytes("UTF-8")), method);
    }

    protected abstract T parseCallResult(InputStream var1, IFacebookMethod var2) throws FacebookException, IOException;

    @Override
    public boolean fbml_refreshRefUrl(URL url) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_REF_URL, ExtensibleClient.newPair("url", url.toString())));
    }

    @Override
    public T notifications_get() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_GET, new Pair[0]);
    }

    @Override
    public T users_getStandardInfo(Collection<Long> userIds, Collection<ProfileField> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_STANDARD_INFO, ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T users_getStandardInfo(Collection<Long> userIds, Set<CharSequence> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_STANDARD_INFO, ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T users_getInfo(Collection<Long> userIds, Collection<ProfileField> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T users_getInfo(Collection<Long> userIds, Set<CharSequence> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public long users_getLoggedInUser() throws FacebookException, IOException {
        if (this.cacheUserId == null || this.cacheUserId == -1L || this.batchMode) {
            this.cacheUserId = this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_LOGGED_IN_USER, new Pair[0]));
        }
        return this.cacheUserId;
    }

    @Override
    @Deprecated
    public long auth_getUserId(String authToken) throws FacebookException, IOException {
        if (null == this.cacheSessionKey) {
            this.auth_getSession(authToken);
        }
        return this.users_getLoggedInUser();
    }

    @Override
    public boolean isDesktop() {
        return this._isDesktop;
    }

    private boolean photos_addTag(Long photoId, Double xPct, Double yPct, Long taggedUserId, CharSequence tagText) throws FacebookException, IOException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        Pair<String, CharSequence> tagData = taggedUserId != null ? ExtensibleClient.newPair("tag_uid", taggedUserId.toString()) : ExtensibleClient.newPair("tag_text", ((Object)tagText).toString());
        T d = this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, ExtensibleClient.newPair("pid", photoId.toString()), tagData, ExtensibleClient.newPair("x", xPct.toString()), ExtensibleClient.newPair("y", yPct.toString()));
        return this.extractBoolean(d);
    }

    @Override
    @Deprecated
    public boolean users_isAppAdded() throws FacebookException, IOException {
        if (this.cacheAppAdded != null) {
            this.cacheAppAdded = this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED, new Pair[0]));
        }
        return this.cacheAppAdded;
    }

    @Override
    public boolean users_isAppUser() throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER, new Pair[0]));
    }

    @Override
    public boolean users_isAppUser(Long userId) throws FacebookException, IOException {
        if (userId != null) {
            return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER_NOSESSION, ExtensibleClient.newPair("uid", userId)));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER, new Pair[0]));
    }

    @Override
    public boolean users_setStatus(String status) throws FacebookException, IOException {
        return this.users_setStatus(status, false, false);
    }

    @Override
    public boolean users_clearStatus() throws FacebookException, IOException {
        return this.users_setStatus(null, true);
    }

    @Override
    public boolean photos_addTag(Long photoId, CharSequence tagText, Double xPct, Double yPct) throws FacebookException, IOException {
        return this.photos_addTag(photoId, xPct, yPct, null, tagText);
    }

    protected InputStream postFileRequest(String methodName, Map<String, String> params, boolean doEncode) throws IOException {
        assert (null != this._uploadFile);
        try {
            int i;
            BufferedInputStream bufin = new BufferedInputStream(new FileInputStream(this._uploadFile));
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            URLConnection con = this._serverUrl.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setRequestProperty("MIME-version", "1.0");
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            for (Map.Entry<String, String> entry : params.entrySet()) {
                out.writeBytes(PREF + boundary + CRLF);
                out.writeBytes("Content-disposition: form-data; name=\"" + entry.getKey() + "\"");
                out.writeBytes("\r\n\r\n");
                out.writeBytes(doEncode ? ExtensibleClient.encode(entry.getValue()) : entry.getValue().toString());
                out.writeBytes(CRLF);
            }
            out.writeBytes(PREF + boundary + CRLF);
            out.writeBytes("Content-disposition: form-data; filename=\"" + this._uploadFile.getName() + "\"" + CRLF);
            out.writeBytes("Content-Type: image/jpeg\r\n");
            out.writeBytes(CRLF);
            byte[] b = new byte[512];
            int byteCounter = 0;
            while (-1 != (i = bufin.read(b))) {
                byteCounter += i;
                out.write(b, 0, i);
            }
            out.writeBytes("\r\n--" + boundary + PREF + CRLF);
            out.flush();
            out.close();
            bufin.close();
            return con.getInputStream();
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    @Deprecated
    public URL notifications_send(Collection<Long> recipientIds, CharSequence notification, CharSequence email) throws FacebookException, IOException {
        this.notifications_send(recipientIds, notification);
        return null;
    }

    @Override
    public boolean fbml_refreshImgSrc(String imageUrl) throws FacebookException, IOException {
        return this.fbml_refreshImgSrc(new URL(imageUrl));
    }

    @Override
    public T photos_upload(File photo) throws FacebookException, IOException {
        return this.photos_upload(photo, null, null);
    }

    @Override
    public T photos_upload(File photo, String caption) throws FacebookException, IOException {
        return this.photos_upload(photo, caption, null);
    }

    @Override
    public T photos_upload(File photo, Long albumId) throws FacebookException, IOException {
        return this.photos_upload(photo, null, albumId);
    }

    @Override
    public T photos_upload(File photo, String caption, Long albumId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_UPLOAD.numParams());
        assert (photo.exists() && photo.canRead());
        this._uploadFile = photo;
        if (null != albumId) {
            params.add(ExtensibleClient.newPair("aid", albumId));
        }
        if (null != caption) {
            params.add(ExtensibleClient.newPair("caption", caption));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_UPLOAD, params);
    }

    @Override
    public T photos_createAlbum(String albumName) throws FacebookException, IOException {
        return this.photos_createAlbum(albumName, null, null);
    }

    @Override
    public boolean photos_addTag(Long photoId, Long taggedUserId, Double xPct, Double yPct) throws FacebookException, IOException {
        return this.photos_addTag(photoId, xPct, yPct, taggedUserId, null);
    }

    @Override
    public T photos_addTags(Long photoId, Collection<PhotoTag> tags) throws FacebookException, IOException {
        assert (photoId > 0L);
        assert (null != tags && !tags.isEmpty());
        JSONArray jsonTags = new JSONArray();
        for (PhotoTag tag : tags) {
            jsonTags.put((Object)tag.jsonify());
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, ExtensibleClient.newPair("pid", photoId.toString()), ExtensibleClient.newPair("tags", jsonTags.toString()));
    }

    @Override
    public void setIsDesktop(boolean isDesktop) {
        this._isDesktop = isDesktop;
    }

    @Override
    public T events_get(Long userId, Collection<Long> eventIds, Long startTime, Long endTime) throws FacebookException, IOException {
        boolean hasEnd;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.EVENTS_GET.numParams());
        boolean hasUserId = null != userId && 0L != userId;
        boolean hasEventIds = null != eventIds && !eventIds.isEmpty();
        boolean hasStart = null != startTime && 0L != startTime;
        boolean bl = hasEnd = null != endTime && 0L != endTime;
        if (hasUserId) {
            params.add(ExtensibleClient.newPair("uid", userId));
        }
        if (hasEventIds) {
            params.add(ExtensibleClient.newPair("eids", ExtensibleClient.delimit(eventIds)));
        }
        if (hasStart) {
            params.add(ExtensibleClient.newPair("start_time", startTime));
        }
        if (hasEnd) {
            params.add(ExtensibleClient.newPair("end_time", endTime));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET, params);
    }

    protected static CharSequence delimit(Collection<Map.Entry<String, String>> entries, String delimiter, String equals, boolean doEncode) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, String> entry : entries) {
            if (notFirst) {
                buffer.append(delimiter);
            } else {
                notFirst = true;
            }
            CharSequence value = entry.getValue();
            buffer.append(entry.getKey()).append(equals).append(doEncode ? ExtensibleClient.encode(value) : value);
        }
        return buffer;
    }

    @Override
    public T photos_createAlbum(String name, String description, String location) throws FacebookException, IOException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_CREATE_ALBUM.numParams());
        params.add(ExtensibleClient.newPair("name", name));
        if (null != description) {
            params.add(ExtensibleClient.newPair("description", description));
        }
        if (null != location) {
            params.add(ExtensibleClient.newPair("location", location));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_CREATE_ALBUM, params);
    }

    @Override
    public T photos_getAlbums(Collection<Long> albumIds) throws FacebookException, IOException {
        return this.photos_getAlbums(null, albumIds);
    }

    @Override
    public T photos_getAlbums(Long userId) throws FacebookException, IOException {
        return this.photos_getAlbums(userId, null);
    }

    @Override
    public T photos_getAlbums(Long userId, Collection<Long> albumIds) throws FacebookException, IOException {
        boolean hasAlbumIds;
        boolean hasUserId = null != userId && userId != 0L;
        boolean bl = hasAlbumIds = null != albumIds && !albumIds.isEmpty();
        assert (hasUserId || hasAlbumIds);
        if (hasUserId) {
            return hasAlbumIds ? this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, ExtensibleClient.newPair("uid", userId), ExtensibleClient.newPair("aids", ExtensibleClient.delimit(albumIds))) : this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, ExtensibleClient.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, ExtensibleClient.newPair("aids", ExtensibleClient.delimit(albumIds)));
    }

    @Override
    public boolean fbml_refreshImgSrc(URL imageUrl) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_IMG_SRC, ExtensibleClient.newPair("url", imageUrl.toString())));
    }

    @Override
    public T friends_get() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET, new Pair[0]);
    }

    private InputStream postRequest(CharSequence method, Map<String, String> params, boolean doHttps, boolean doEncode) throws IOException {
        URL serverUrl;
        String buffer = null == params ? "" : ExtensibleClient.delimit(params.entrySet(), "&", "=", doEncode);
        URL uRL = serverUrl = doHttps ? HTTPS_SERVER_URL : this._serverUrl;
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(method);
            sb.append(" POST: ");
            sb.append(serverUrl.toString());
            sb.append("?");
            sb.append((CharSequence)buffer);
            log.debug((Object)sb.toString());
        }
        HttpURLConnection conn = (HttpURLConnection)serverUrl.openConnection();
        if (this._timeout != -1) {
            conn.setConnectTimeout(this._timeout);
        }
        if (this._readTimeout != -1) {
            conn.setReadTimeout(this._readTimeout);
        }
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException ex) {
            log.error((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
        }
        conn.setDoOutput(true);
        conn.connect();
        conn.getOutputStream().write(buffer.toString().getBytes());
        return conn.getInputStream();
    }

    @Override
    public String auth_createToken() throws FacebookException, IOException {
        T d = this.callMethod((IFacebookMethod)FacebookMethod.AUTH_CREATE_TOKEN, new Pair[0]);
        return this.extractString(d);
    }

    @Override
    @Deprecated
    public Long marketplace_createListing(Boolean showOnProfile, MarketplaceListing attrs) throws FacebookException, IOException {
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, ExtensibleClient.newPair("show_on_profile", showOnProfile != false ? "1" : "0"), ExtensibleClient.newPair("listing_id", "0"), ExtensibleClient.newPair("listing_attrs", attrs.jsonify().toString()));
        return this.extractLong(result);
    }

    @Override
    @Deprecated
    public Long marketplace_editListing(Long listingId, Boolean showOnProfile, MarketplaceListing attrs) throws FacebookException, IOException {
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, ExtensibleClient.newPair("show_on_profile", showOnProfile != false ? "1" : "0"), ExtensibleClient.newPair("listing_id", listingId.toString()), ExtensibleClient.newPair("listing_attrs", attrs.jsonify().toString()));
        return this.extractLong(result);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId) throws FacebookException, IOException {
        return this.marketplace_removeListing(listingId, MARKETPLACE_STATUS_DEFAULT);
    }

    @Override
    @Deprecated
    public boolean marketplace_removeListing(Long listingId, CharSequence status) throws FacebookException, IOException {
        assert (MARKETPLACE_STATUS_DEFAULT.equals(status) || MARKETPLACE_STATUS_SUCCESS.equals(status) || MARKETPLACE_STATUS_NOT_SUCCESS.equals(status)) : "Invalid status: " + status;
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_REMOVE_LISTING, ExtensibleClient.newPair("listing_id", listingId.toString()), ExtensibleClient.newPair("status", status));
        return this.extractBoolean(result);
    }

    @Override
    @Deprecated
    public List<String> marketplace_getCategories() throws FacebookException, IOException {
        T temp = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_CATEGORIES, new Pair[0]);
        if (temp == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        if (temp instanceof Document) {
            Document d = (Document)temp;
            NodeList cats = d.getElementsByTagName("marketplace_category");
            for (int count = 0; count < cats.getLength(); ++count) {
                results.add(cats.item(count).getFirstChild().getTextContent());
            }
        } else {
            JSONObject j = (JSONObject)temp;
            Iterator it = j.keys();
            while (it.hasNext()) {
                try {
                    results.add(j.get((String)it.next()).toString());
                }
                catch (Exception ignored) {}
            }
        }
        return results;
    }

    @Override
    public T marketplace_getSubCategories(CharSequence category) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_SUBCATEGORIES, ExtensibleClient.newPair("category", category));
    }

    @Override
    public T marketplace_getListings(Collection<Long> listingIds, Collection<Long> userIds) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.MARKETPLACE_GET_LISTINGS.numParams());
        if (null != listingIds && !listingIds.isEmpty()) {
            params.add(ExtensibleClient.newPair("listing_ids", ExtensibleClient.delimit(listingIds)));
        }
        if (null != userIds && !userIds.isEmpty()) {
            params.add(ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)));
        }
        assert (!params.isEmpty()) : "Either listingIds or userIds should be provided";
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_LISTINGS, params);
    }

    @Override
    @Deprecated
    public T marketplace_search(CharSequence category, CharSequence subCategory, CharSequence query) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.MARKETPLACE_SEARCH.numParams());
        boolean hasCategory = ExtensibleClient.addParamIfNotBlank("category", category, params);
        if (hasCategory) {
            ExtensibleClient.addParamIfNotBlank("subcategory", subCategory, params);
        }
        ExtensibleClient.addParamIfNotBlank("query", query, params);
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_SEARCH, params);
    }

    @Override
    public T photos_getByAlbum(Long albumId, Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get(null, albumId, photoIds);
    }

    @Override
    public T photos_getByAlbum(Long albumId) throws FacebookException, IOException {
        return this.photos_get(null, albumId, null);
    }

    @Override
    public T marketplace_getCategoriesObject() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_CATEGORIES, new Pair[0]);
    }

    @Override
    public String getRawResponse() {
        return this.rawResponse;
    }

    @Override
    public Object getResponsePOJO() {
        if (this.rawResponse == null) {
            return null;
        }
        if (JAXB_CONTEXT == null) {
            return null;
        }
        if (this.getResponseFormat() != null && !"xml".equalsIgnoreCase(this.getResponseFormat())) {
            throw new RuntimeException("You can only generate a response POJO when using XML formatted API responses!  JSON users go elsewhere!");
        }
        Object pojo = null;
        try {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            pojo = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(this.rawResponse.getBytes("UTF-8")));
        }
        catch (JAXBException ex) {
            log.error((Object)("getResponsePOJO() - Could not unmarshall XML stream into POJO:" + ex.getMessage()), (Throwable)ex);
        }
        catch (NullPointerException ex) {
            log.error((Object)("getResponsePOJO() - Could not unmarshall XML stream into POJO:" + ex.getMessage()), (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)("getResponsePOJO() - Could not unmarshall XML stream into POJO:" + ex.getMessage()), (Throwable)ex);
        }
        return pojo;
    }

    @Override
    public boolean feed_PublishTemplatizedAction(TemplatizedAction action) throws FacebookException, IOException {
        return this.templatizedFeedHandler(FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, action.getTitleTemplate(), action.getTitleParams(), action.getBodyTemplate(), action.getBodyParams(), action.getBodyGeneral(), action.getPictures(), action.getTargetIds(), action.getPageActorId());
    }

    @Override
    public boolean feed_publishTemplatizedAction(String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> pictures, String targetIds) throws FacebookException, IOException {
        return this.templatizedFeedHandler(FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, pictures, targetIds, null);
    }

    protected boolean templatizedFeedHandler(FacebookMethod method, String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> pictures, String targetIds, Long pageId) throws FacebookException, IOException {
        assert (pictures == null || pictures.size() <= 4);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(method.numParams());
        ExtensibleClient.addParam("title_template", titleTemplate, params);
        ExtensibleClient.addParamIfNotBlank("title_data", titleData, params);
        boolean hasBody = ExtensibleClient.addParamIfNotBlank("body_template", bodyTemplate, params);
        if (hasBody) {
            ExtensibleClient.addParamIfNotBlank("body_data", bodyData, params);
        }
        ExtensibleClient.addParamIfNotBlank("body_general", bodyGeneral, params);
        if (pictures != null) {
            int count = 1;
            for (IPair<? extends Object, URL> iPair : pictures) {
                String url = iPair.getFirst().toString();
                if (url.startsWith("http://UID/")) {
                    url = url.substring("http://UID/".length());
                }
                ExtensibleClient.addParam("image_" + count, url, params);
                if (iPair.getSecond() != null) {
                    ExtensibleClient.addParam("image_" + count + "_link", ((Object)iPair.getSecond()).toString(), params);
                }
                ++count;
            }
        }
        ExtensibleClient.addParamIfNotBlank("target_ids", targetIds, params);
        ExtensibleClient.addParamIfNotBlank("page_actor_id", pageId, params);
        return this.extractBoolean(this.callMethod((IFacebookMethod)method, params));
    }

    @Override
    public boolean users_hasAppPermission(Permission perm) throws FacebookException, IOException {
        return this.users_hasAppPermission(perm, null);
    }

    @Override
    public boolean users_hasAppPermission(Permission perm, Long userId) throws FacebookException, IOException {
        if (userId != null) {
            return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION_NOSESSION, ExtensibleClient.newPair("ext_perm", perm.getName()), ExtensibleClient.newPair("uid", userId)));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION, ExtensibleClient.newPair("ext_perm", perm.getName())));
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, String attributes) throws FacebookException, IOException {
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, ExtensibleClient.newPair("show_on_profile", showOnProfile ? "1" : "0"), ExtensibleClient.newPair("listing_id", "0"), ExtensibleClient.newPair("listing_attrs", attributes));
        return this.extractLong(result);
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, MarketListing listing) throws FacebookException, IOException {
        return this.marketplace_createListing(listingId, showOnProfile, listing.getAttribs());
    }

    @Override
    public Long marketplace_createListing(boolean showOnProfile, MarketListing listing) throws FacebookException, IOException {
        return this.marketplace_createListing(null, showOnProfile, listing.getAttribs());
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, MarketListingStatus status) throws FacebookException, IOException {
        return this.marketplace_removeListing(listingId, status.getName());
    }

    @Override
    public Long marketplace_editListing(Long listingId, Boolean showOnProfile, MarketListing attrs) throws FacebookException, IOException {
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, ExtensibleClient.newPair("show_on_profile", showOnProfile != false ? "1" : "0"), ExtensibleClient.newPair("listing_id", listingId.toString()), ExtensibleClient.newPair("listing_attrs", attrs.getAttribs()));
        return this.extractLong(result);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear) throws FacebookException, IOException {
        return this.users_setStatus(newStatus, clear, false);
    }

    @Override
    public T pages_getInfo(Collection<Long> pageIds, EnumSet<PageProfileField> fields) throws FacebookException, IOException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        FacebookMethod method = null == this.cacheSessionKey ? FacebookMethod.PAGES_GET_INFO_NO_SESSION : FacebookMethod.PAGES_GET_INFO;
        return this.callMethod((IFacebookMethod)method, ExtensibleClient.newPair("page_ids", ExtensibleClient.delimit(pageIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T pages_getInfo(Collection<Long> pageIds, Set<CharSequence> fields) throws FacebookException, IOException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        FacebookMethod method = null == this.cacheSessionKey ? FacebookMethod.PAGES_GET_INFO_NO_SESSION : FacebookMethod.PAGES_GET_INFO;
        return this.callMethod((IFacebookMethod)method, ExtensibleClient.newPair("page_ids", ExtensibleClient.delimit(pageIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T pages_getInfo(Long userId, EnumSet<PageProfileField> fields) throws FacebookException, IOException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this.cacheUserId;
        }
        if (userId == null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, ExtensibleClient.newPair("uid", userId.toString()), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T pages_getInfo(Long userId, Set<CharSequence> fields) throws FacebookException, IOException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this.cacheUserId;
        }
        if (userId == null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, ExtensibleClient.newPair("uid", userId.toString()), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public boolean pages_isAppAdded(Long pageId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_APP_ADDED, ExtensibleClient.newPair("page_id", pageId.toString())));
    }

    @Override
    public boolean pages_isFan(Long pageId, Long userId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, ExtensibleClient.newPair("page_id", pageId.toString()), ExtensibleClient.newPair("uid", userId.toString())));
    }

    @Override
    public boolean pages_isFan(Long pageId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, ExtensibleClient.newPair("page_id", pageId.toString())));
    }

    @Override
    public boolean pages_isAdmin(Long pageId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_ADMIN, ExtensibleClient.newPair("page_id", pageId.toString())));
    }

    @Override
    public boolean fbml_setRefHandle(String handle, String fbmlMarkup) throws FacebookException, IOException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'fbml_setReftHandle'");
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_SET_REF_HANDLE, ExtensibleClient.newPair("handle", handle), ExtensibleClient.newPair("fbml", fbmlMarkup)));
    }

    @Override
    public boolean sms_canSend() throws FacebookException, IOException {
        return this.sms_canSend(this.users_getLoggedInUser());
    }

    @Override
    public boolean sms_canSend(Long userId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.SMS_CAN_SEND, ExtensibleClient.newPair("uid", userId.toString())));
    }

    public void sms_sendResponse(Integer userId, CharSequence response, Integer mobileSessionId) throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, ExtensibleClient.newPair("uid", userId.toString()), ExtensibleClient.newPair("message", response), ExtensibleClient.newPair("session_id", mobileSessionId.toString()));
    }

    @Override
    public void sms_sendMessage(Long userId, CharSequence message) throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, ExtensibleClient.newPair("uid", userId.toString()), ExtensibleClient.newPair("message", message), ExtensibleClient.newPair("req_session", "0"));
    }

    @Override
    public int sms_sendMessageWithSession(Long userId, CharSequence message) throws FacebookException, IOException {
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, ExtensibleClient.newPair("uid", userId.toString()), ExtensibleClient.newPair("message", message), ExtensibleClient.newPair("req_session", "1")));
    }

    @Override
    public void notifications_send(Collection<Long> recipientIds, CharSequence notification) throws FacebookException, IOException {
        this.notifications_send(recipientIds, ((Object)notification).toString(), false);
    }

    private T notifications_sendEmail(CharSequence recipients, CharSequence subject, CharSequence email, CharSequence fbml) throws FacebookException, IOException {
        String paramValue;
        if (null == recipients || "".equals(recipients)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You must specify at least one recipient when sending an email!");
        }
        if ((null == email || "".equals(email)) && (null == fbml || "".equals(fbml))) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You cannot send an empty email!");
        }
        String paramName = "text";
        if (email == null || "".equals(((Object)email).toString())) {
            paramValue = ((Object)fbml).toString();
            paramName = "fbml";
        } else {
            paramValue = ((Object)email).toString();
        }
        FacebookMethod method = this.isDesktop() ? FacebookMethod.NOTIFICATIONS_SEND_EMAIL_SESSION : FacebookMethod.NOTIFICATIONS_SEND_EMAIL;
        T d = subject != null && !"".equals(subject) ? this.callMethod((IFacebookMethod)method, ExtensibleClient.newPair("recipients", recipients), ExtensibleClient.newPair("subject", subject), ExtensibleClient.newPair(paramName, paramValue)) : this.callMethod((IFacebookMethod)method, ExtensibleClient.newPair("recipients", recipients), ExtensibleClient.newPair(paramName, paramValue));
        return d;
    }

    @Override
    public T notifications_sendEmail(Collection<Long> recipients, CharSequence subject, CharSequence email, CharSequence fbml) throws FacebookException, IOException {
        return this.notifications_sendEmail(ExtensibleClient.delimit(recipients), subject, email, fbml);
    }

    @Override
    public T notifications_sendEmailToCurrentUser(String subject, String email, String fbml) throws FacebookException, IOException {
        Long currentUser = this.users_getLoggedInUser();
        return this.notifications_sendEmail(currentUser.toString(), (CharSequence)subject, (CharSequence)email, (CharSequence)fbml);
    }

    @Override
    public T notifications_sendFbmlEmail(Collection<Long> recipients, String subject, String fbml) throws FacebookException, IOException {
        return this.notifications_sendEmail(ExtensibleClient.delimit(recipients), (CharSequence)subject, null, (CharSequence)fbml);
    }

    @Override
    public T notifications_sendFbmlEmailToCurrentUser(String subject, String fbml) throws FacebookException, IOException {
        Long currentUser = this.users_getLoggedInUser();
        return this.notifications_sendEmail(currentUser.toString(), (CharSequence)subject, null, (CharSequence)fbml);
    }

    @Override
    public T notifications_sendTextEmail(Collection<Long> recipients, String subject, String email) throws FacebookException, IOException {
        return this.notifications_sendEmail(ExtensibleClient.delimit(recipients), (CharSequence)subject, (CharSequence)email, null);
    }

    @Override
    public T notifications_sendTextEmailToCurrentUser(String subject, String email) throws FacebookException, IOException {
        Long currentUser = this.users_getLoggedInUser();
        return this.notifications_sendEmail(currentUser.toString(), (CharSequence)subject, (CharSequence)email, null);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, boolean statusIncludesVerb) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (newStatus != null) {
            params.add(ExtensibleClient.newPair("status", newStatus));
        }
        if (clear) {
            params.add(ExtensibleClient.newPair("clear", "true"));
        }
        if (statusIncludesVerb) {
            params.add(ExtensibleClient.newPair("status_includes_verb", "true"));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS, params));
    }

    @Override
    public void notifications_send(CharSequence notification) throws FacebookException, IOException {
        Long currentUser = this.users_getLoggedInUser();
        ArrayList<Long> coll = new ArrayList<Long>();
        coll.add(currentUser);
        this.notifications_send(coll, notification);
    }

    @Override
    @Deprecated
    public String notifications_sendEmailStr(Collection<Long> recipientIds, CharSequence subject, CharSequence fbml, CharSequence text) throws FacebookException, IOException {
        boolean hasFbml;
        if (null == recipientIds || recipientIds.isEmpty()) {
            throw new IllegalArgumentException("List of email recipients cannot be empty");
        }
        boolean hasText = null != text && 0 != text.length();
        boolean bl = hasFbml = null != fbml && 0 != fbml.length();
        if (!hasText && !hasFbml) {
            throw new IllegalArgumentException("Text and/or fbml must not be empty");
        }
        ArrayList<Pair<String, CharSequence>> args = new ArrayList<Pair<String, CharSequence>>(4);
        args.add(ExtensibleClient.newPair("recipients", ExtensibleClient.delimit(recipientIds)));
        args.add(ExtensibleClient.newPair("subject", subject));
        if (hasText) {
            args.add(ExtensibleClient.newPair("text", text));
        }
        if (hasFbml) {
            args.add(ExtensibleClient.newPair("fbml", fbml));
        }
        T result = this.callMethod((IFacebookMethod)(this.isDesktop() ? FacebookMethod.NOTIFICATIONS_SEND_EMAIL_SESSION : FacebookMethod.NOTIFICATIONS_SEND_EMAIL), args);
        return this.extractString(result);
    }

    @Override
    @Deprecated
    public String notifications_sendEmail(Collection<Long> recipientIds, CharSequence subject, CharSequence fbml) throws FacebookException, IOException {
        return this.notifications_sendEmailStr(recipientIds, subject, fbml, null);
    }

    @Override
    @Deprecated
    public String notifications_sendEmailPlain(Collection<Long> recipientIds, CharSequence subject, CharSequence text) throws FacebookException, IOException {
        return this.notifications_sendEmailStr(recipientIds, subject, null, text);
    }

    @Override
    public Integer sms_send(String message, Integer smsSessionId, boolean makeNewSession) throws FacebookException, IOException {
        if (smsSessionId == null || smsSessionId <= 0) {
            return this.sms_sendMessageWithSession(this.users_getLoggedInUser(), message);
        }
        this.sms_sendResponse((int)this.users_getLoggedInUser(), message, smsSessionId);
        return smsSessionId;
    }

    @Override
    public Integer sms_send(Long userId, String message, Integer smsSessionId, boolean makeNewSession) throws FacebookException, IOException {
        if (smsSessionId == null || smsSessionId <= 0) {
            return this.sms_sendMessageWithSession(userId, message);
        }
        this.sms_sendResponse(userId.intValue(), message, smsSessionId);
        return smsSessionId;
    }

    @Override
    public T data_getCookies() throws FacebookException, IOException {
        return this.data_getCookies(this.users_getLoggedInUser(), null);
    }

    @Override
    public T data_getCookies(Long userId) throws FacebookException, IOException {
        return this.data_getCookies(userId, null);
    }

    @Override
    public T data_getCookies(String name) throws FacebookException, IOException {
        return this.data_getCookies(this.users_getLoggedInUser(), name);
    }

    @Override
    public T data_getCookies(Long userId, CharSequence name) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> args = new ArrayList<Pair<String, CharSequence>>();
        args.add(ExtensibleClient.newPair("uid", userId));
        if (name != null && !"".equals(name)) {
            args.add(ExtensibleClient.newPair("name", name));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_COOKIES, args);
    }

    @Override
    public boolean data_setCookie(String name, String value) throws FacebookException, IOException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, null, null);
    }

    @Override
    public boolean data_setCookie(String name, String value, String path) throws FacebookException, IOException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, null, path);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value) throws FacebookException, IOException {
        return this.data_setCookie(userId, name, value, null, null);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, CharSequence path) throws FacebookException, IOException {
        return this.data_setCookie(userId, name, value, null, path);
    }

    @Override
    public boolean data_setCookie(String name, String value, Long expires) throws FacebookException, IOException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, expires, null);
    }

    @Override
    public boolean data_setCookie(String name, String value, Long expires, String path) throws FacebookException, IOException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, expires, path);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, Long expires) throws FacebookException, IOException {
        return this.data_setCookie(userId, name, value, expires, null);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, Long expires, CharSequence path) throws FacebookException, IOException {
        if (name == null || "".equals(name)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The cookie name cannot be null or empty!");
        }
        if (value == null) {
            value = "";
        }
        ArrayList<Pair<String, CharSequence>> args = new ArrayList<Pair<String, CharSequence>>();
        args.add(ExtensibleClient.newPair("uid", userId));
        args.add(ExtensibleClient.newPair("name", name));
        args.add(ExtensibleClient.newPair("value", value));
        if (expires != null && expires > 0L) {
            args.add(ExtensibleClient.newPair("expires", expires.toString()));
        }
        if (path != null && !"".equals(path)) {
            args.add(ExtensibleClient.newPair("path", path));
        }
        T doc = this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_COOKIE, args);
        return this.extractBoolean(doc);
    }

    @Override
    public boolean admin_setAppProperties(Map<ApplicationProperty, String> properties) throws FacebookException, IOException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'admin_setAppProperties'");
        }
        if (properties == null || properties.isEmpty()) {
            return true;
        }
        JSONObject encoding1 = new JSONObject();
        JSONArray encoding2 = new JSONArray();
        for (ApplicationProperty property : properties.keySet()) {
            JSONObject temp = new JSONObject();
            if (property.getType().equals("string")) {
                try {
                    encoding1.put(property.getName(), (Object)properties.get((Object)property));
                    temp.put(property.getName(), (Object)properties.get((Object)property));
                    encoding2.put((Object)temp);
                }
                catch (JSONException ignored) {}
                continue;
            }
            String val = properties.get((Object)property);
            val = val == null || val.equals("") || val.equalsIgnoreCase("false") || val.equals("0") ? "0" : "1";
            try {
                encoding1.put(property.getName(), (Object)val);
                temp.put(property.getName(), (Object)val);
                encoding2.put((Object)temp);
            }
            catch (JSONException ignored) {}
        }
        try {
            T d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, ExtensibleClient.newPair("properties", encoding1.toString()));
            return this.extractBoolean(d);
        }
        catch (FacebookException e) {
            T d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, ExtensibleClient.newPair("properties", encoding2.toString()));
            return this.extractBoolean(d);
        }
    }

    @Override
    @Deprecated
    public JSONObject admin_getAppProperties(Collection<ApplicationProperty> properties) throws FacebookException, IOException {
        String json = this.admin_getAppPropertiesAsString(properties);
        if (json == null) {
            return null;
        }
        try {
            if (json.matches("\\{.*\\}")) {
                return new JSONObject(json);
            }
            JSONArray temp = new JSONArray(json);
            JSONObject result = new JSONObject();
            for (int count = 0; count < temp.length(); ++count) {
                JSONObject obj = (JSONObject)temp.get(count);
                Iterator it = obj.keys();
                while (it.hasNext()) {
                    String next = (String)it.next();
                    result.put(next, obj.get(next));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new FacebookException(ErrorCode.GEN_SERVICE_ERROR, "Failed to parse server response:  " + json);
        }
    }

    @Override
    public Map<ApplicationProperty, String> admin_getAppPropertiesMap(Collection<ApplicationProperty> properties) throws FacebookException, IOException {
        String[] parts;
        LinkedHashMap<ApplicationProperty, String> result = new LinkedHashMap<ApplicationProperty, String>();
        String json = this.admin_getAppPropertiesAsString(properties);
        if (json == null) {
            return null;
        }
        json = json.matches("\\{.*\\}") ? json.substring(1, json.lastIndexOf("}")) : json.substring(1, json.lastIndexOf("]"));
        for (String part : parts = json.split("\\,")) {
            ExtensibleClient.parseFragment(part, result);
        }
        return result;
    }

    static Map<ApplicationProperty, String> parseProperties(String json) {
        String[] parts;
        TreeMap<ApplicationProperty, String> result = new TreeMap<ApplicationProperty, String>();
        if (json == null) {
            return null;
        }
        json = json.matches("\\{.*\\}") ? json.substring(1, json.lastIndexOf("}")) : json.substring(1, json.lastIndexOf("]"));
        for (String part : parts = json.split("\\,")) {
            ExtensibleClient.parseFragment(part, result);
        }
        return result;
    }

    private static void parseFragment(String fragment, Map<ApplicationProperty, String> result) {
        if (fragment.startsWith("{")) {
            fragment = fragment.substring(1, fragment.lastIndexOf("}"));
        }
        String keyString = fragment.substring(1);
        keyString = keyString.substring(0, keyString.indexOf(34));
        ApplicationProperty key = ApplicationProperty.getPropertyForString(keyString);
        String value = fragment.substring(fragment.indexOf(":") + 1).replaceAll("\\\\", "");
        if (key.getType().equals("string")) {
            result.put(key, value.substring(1, value.lastIndexOf(34)));
        } else if (value.equals("1")) {
            result.put(key, "true");
        } else {
            result.put(key, "false");
        }
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(titleTemplate, null);
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Long pageActorId) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(titleTemplate, null, null, null, null, null, null, pageActorId);
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images, Long pageActorId) throws FacebookException, IOException {
        assert (null != titleTemplate && !"".equals(titleTemplate));
        FacebookMethod method = FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(method.numParams());
        params.add(ExtensibleClient.newPair("title_template", titleTemplate));
        if (null != titleData && !titleData.isEmpty()) {
            JSONObject titleDataJson = new JSONObject();
            for (String key : titleData.keySet()) {
                try {
                    titleDataJson.put(key, (Object)titleData.get(key));
                }
                catch (Exception ignored) {}
            }
            params.add(ExtensibleClient.newPair("title_data", titleDataJson.toString()));
        }
        if (null != bodyTemplate && !"".equals(bodyTemplate)) {
            params.add(ExtensibleClient.newPair("body_template", bodyTemplate));
            if (null != bodyData && !bodyData.isEmpty()) {
                JSONObject bodyDataJson = new JSONObject();
                for (String key : bodyData.keySet()) {
                    try {
                        bodyDataJson.put(key, (Object)bodyData.get(key));
                    }
                    catch (Exception ignored) {}
                }
                params.add(ExtensibleClient.newPair("body_data", bodyDataJson.toString()));
            }
        }
        if (null != bodyTemplate && !"".equals(bodyTemplate)) {
            params.add(ExtensibleClient.newPair("body_template", bodyTemplate));
        }
        if (null != targetIds && !targetIds.isEmpty()) {
            params.add(ExtensibleClient.newPair("target_ids", ExtensibleClient.delimit(targetIds)));
        }
        if (bodyGeneral != null) {
            params.add(ExtensibleClient.newPair("body_general", bodyGeneral));
        }
        if (pageActorId != null) {
            params.add(ExtensibleClient.newPair("page_actor_id", pageActorId));
        }
        this.handleFeedImages(params, images);
        return this.extractBoolean(this.callMethod((IFacebookMethod)method, params));
    }

    @Override
    public T friends_get(Long friendListId) throws FacebookException, IOException {
        FacebookMethod method = FacebookMethod.FRIENDS_GET;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(method.numParams());
        if (null != friendListId) {
            if (0L >= friendListId) {
                throw new IllegalArgumentException("given invalid friendListId " + friendListId.toString());
            }
            params.add(ExtensibleClient.newPair("flid", friendListId.toString()));
        }
        return this.callMethod((IFacebookMethod)method, params);
    }

    @Override
    public T friends_getLists() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_LISTS, new Pair[0]);
    }

    @Override
    public boolean admin_setAppProperties(ApplicationPropertySet properties) throws FacebookException, IOException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'admin_setAppProperties'");
        }
        if (null == properties || properties.isEmpty()) {
            throw new IllegalArgumentException("expecting a non-empty set of application properties");
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, ExtensibleClient.newPair("properties", properties.toJsonString())));
    }

    @Override
    public ApplicationPropertySet admin_getAppPropertiesAsSet(EnumSet<ApplicationProperty> properties) throws FacebookException, IOException {
        String propJson = this.admin_getAppPropertiesAsString(properties);
        return new ApplicationPropertySet(propJson);
    }

    @Override
    public void beginBatch() {
        this.batchMode = true;
        this.queries = new ArrayList<BatchQuery>();
    }

    protected String encodeMethods(List<BatchQuery> queries) throws FacebookException {
        JSONArray result = new JSONArray();
        for (BatchQuery query : queries) {
            if (query.getMethod().takesFile()) {
                throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "File upload API calls cannot be batched:  " + query.getMethod().methodName());
            }
            result.put((Object)ExtensibleClient.delimit(query.getParams().entrySet(), "&", "=", true));
        }
        return result.toString();
    }

    @Override
    public T batch_run(String methods, boolean serial) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(ExtensibleClient.newPair("method_feed", methods));
        if (serial) {
            params.add(ExtensibleClient.newPair("serial_only", "1"));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.BATCH_RUN, params);
    }

    @Override
    public T application_getPublicInfo(Long applicationId, String applicationKey, String applicationCanvas) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (applicationId != null && applicationId > 0L) {
            params.add(ExtensibleClient.newPair("application_id", applicationId));
        } else if (applicationKey != null && !"".equals(applicationKey)) {
            params.add(ExtensibleClient.newPair("application_api_key", applicationKey));
        } else if (applicationCanvas != null && !"".equals(applicationCanvas)) {
            params.add(ExtensibleClient.newPair("application_canvas_name", applicationCanvas));
        } else {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You must specify at least on of {applicationId, applicationKey, applicationCanvas}");
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.APPLICATION_GET_PUBLIC_INFO, params);
    }

    @Override
    public T application_getPublicInfoById(Long applicationId) throws FacebookException, IOException {
        return this.application_getPublicInfo(applicationId, null, null);
    }

    @Override
    public T application_getPublicInfoByApiKey(String applicationKey) throws FacebookException, IOException {
        return this.application_getPublicInfo(null, applicationKey, null);
    }

    @Override
    public T application_getPublicInfoByCanvasName(String applicationCanvas) throws FacebookException, IOException {
        return this.application_getPublicInfo(null, null, applicationCanvas);
    }

    @Override
    public int admin_getAllocation(String allocationType) throws FacebookException, IOException {
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_ALLOCATION, ExtensibleClient.newPair("integration_point_name", allocationType)));
    }

    @Override
    public int admin_getAllocation(AllocationType allocationType) throws FacebookException, IOException {
        return this.admin_getAllocation(allocationType.getName());
    }

    @Override
    @Deprecated
    public int admin_getNotificationAllocation() throws FacebookException, IOException {
        return this.admin_getAllocation("notifications_per_day");
    }

    @Override
    @Deprecated
    public int admin_getRequestAllocation() throws FacebookException, IOException {
        return this.admin_getAllocation("requests_per_day");
    }

    @Override
    @Deprecated
    public T admin_getDailyMetrics(Set<Metric> metrics, Date start, Date end) throws FacebookException, IOException {
        return this.admin_getDailyMetrics(metrics, start.getTime(), end.getTime());
    }

    @Override
    @Deprecated
    public T admin_getDailyMetrics(Set<Metric> metrics, long start, long end) throws FacebookException, IOException {
        int size = 2 + (metrics != null ? metrics.size() : 0);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(size);
        if (metrics != null) {
            metrics.remove((Object)Metric.ACTIVE_USERS);
            if (!metrics.isEmpty()) {
                JSONArray metricsJson = new JSONArray();
                for (Metric metric : metrics) {
                    metricsJson.put((Object)metric.getName());
                }
                params.add(ExtensibleClient.newPair("metrics", metricsJson.toString()));
            }
        }
        params.add(ExtensibleClient.newPair("start_date", start / 1000L));
        params.add(ExtensibleClient.newPair("end_date", end / 1000L));
        return this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_DAILY_METRICS, params);
    }

    @Override
    public T permissions_checkGrantedApiAccess(String apiKey) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PERM_CHECK_GRANTED_API_ACCESS, ExtensibleClient.newPair("permissions_apikey", apiKey));
    }

    @Override
    public T permissions_checkAvailableApiAccess(String apiKey) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PERM_CHECK_AVAILABLE_API_ACCESS, ExtensibleClient.newPair("permissions_apikey", apiKey));
    }

    @Override
    public boolean permissions_grantApiAccess(String apiKey, Set<FacebookMethod> methods) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (methods != null && !methods.isEmpty()) {
            JSONArray methodsJson = new JSONArray();
            for (FacebookMethod method : methods) {
                methodsJson.put((Object)method.methodName());
            }
            params.add(ExtensibleClient.newPair("method_arr", methodsJson.toString()));
        }
        params.add(ExtensibleClient.newPair("permissions_apikey", apiKey));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PERM_GRANT_API_ACCESS, params));
    }

    @Override
    public boolean permissions_grantFullApiAccess(String apiKey) throws FacebookException, IOException {
        return this.permissions_grantApiAccess(apiKey, null);
    }

    @Override
    public boolean permissions_revokeApiAccess(String apiKey) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PERM_REVOKE_API_ACCESS, ExtensibleClient.newPair("permissions_apikey", apiKey)));
    }

    @Override
    public String auth_promoteSession() throws FacebookException, IOException {
        return this.extractString(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_PROMOTE_SESSION, new Pair[0]));
    }

    @Override
    public boolean auth_revokeAuthorization() throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_REVOKE_AUTHORIZATION, new Pair[0]));
    }

    @Override
    public boolean auth_expireSession() throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_EXPIRE_SESSION, new Pair[0]));
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, String attributes, Long userId) throws FacebookException, IOException {
        MarketListing test;
        if (listingId == null) {
            listingId = 0L;
        }
        if (!(test = new MarketListing(attributes)).verify()) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The specified listing is invalid!");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        params.add(ExtensibleClient.newPair("listing_id", listingId.toString()));
        if (showOnProfile) {
            params.add(ExtensibleClient.newPair("show_on_profile", "true"));
        }
        params.add(ExtensibleClient.newPair("listing_attrs", attributes));
        params.add(ExtensibleClient.newPair("uid", listingId));
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.MARKET_CREATE_LISTING_NOSESSION, params));
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, MarketListing listing, Long userId) throws FacebookException, IOException {
        return this.marketplace_createListing(listingId, showOnProfile, listing.getAttribs(), userId);
    }

    @Override
    public Long marketplace_createListing(boolean showOnProfile, MarketListing listing, Long userId) throws FacebookException, IOException {
        return this.marketplace_createListing((Long)0L, showOnProfile, listing.getAttribs(), userId);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, Long userId) throws FacebookException, IOException {
        return this.marketplace_removeListing(listingId, MarketListingStatus.DEFAULT, userId);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, MarketListingStatus status, Long userId) throws FacebookException, IOException {
        if (status == null) {
            status = MarketListingStatus.DEFAULT;
        }
        if (listingId == null) {
            return false;
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        params.add(ExtensibleClient.newPair("listing_id", listingId));
        params.add(ExtensibleClient.newPair("status", status.getName()));
        params.add(ExtensibleClient.newPair("uid", userId));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.MARKET_REMOVE_LISTING_NOSESSION, params));
    }

    private boolean photos_addTag(Long photoId, Double xPct, Double yPct, Long taggedUserId, CharSequence tagText, Long userId) throws FacebookException, IOException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        if (taggedUserId != null) {
            params.add(ExtensibleClient.newPair("tag_uid", taggedUserId.toString()));
        } else {
            params.add(ExtensibleClient.newPair("tag_text", ((Object)tagText).toString()));
        }
        params.add(ExtensibleClient.newPair("x", xPct.toString()));
        params.add(ExtensibleClient.newPair("y", yPct.toString()));
        params.add(ExtensibleClient.newPair("pid", photoId));
        params.add(ExtensibleClient.newPair("owner_uid", userId));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG_NOSESSION, params));
    }

    @Override
    public boolean photos_addTag(Long photoId, Long taggedUserId, Double pct, Double pct2, Long userId) throws FacebookException, IOException {
        return this.photos_addTag(photoId, pct, pct2, taggedUserId, null, userId);
    }

    @Override
    public boolean photos_addTag(Long photoId, CharSequence tagText, Double pct, Double pct2, Long userId) throws FacebookException, IOException {
        return this.photos_addTag(photoId, pct, pct2, null, tagText);
    }

    @Override
    public T photos_createAlbum(String albumName, Long userId) throws FacebookException, IOException {
        return this.photos_createAlbum(albumName, null, null, userId);
    }

    @Override
    public T photos_createAlbum(String name, String description, String location, Long userId) throws FacebookException, IOException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_CREATE_ALBUM.numParams());
        params.add(ExtensibleClient.newPair("name", name));
        if (null != description) {
            params.add(ExtensibleClient.newPair("description", description));
        }
        if (null != location) {
            params.add(ExtensibleClient.newPair("location", location));
        }
        params.add(ExtensibleClient.newPair("uid", userId));
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_CREATE_ALBUM_NOSESSION, params);
    }

    @Override
    public T photos_upload(Long userId, File photo) throws FacebookException, IOException {
        return this.photos_upload(userId, photo, null, null);
    }

    @Override
    public T photos_upload(Long userId, File photo, String caption) throws FacebookException, IOException {
        return this.photos_upload(userId, photo, caption, null);
    }

    @Override
    public T photos_upload(Long userId, File photo, Long albumId) throws FacebookException, IOException {
        return this.photos_upload(userId, photo, null, albumId);
    }

    @Override
    public T photos_upload(Long userId, File photo, String caption, Long albumId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_UPLOAD.numParams());
        assert (photo.exists() && photo.canRead());
        this._uploadFile = photo;
        if (null != albumId) {
            params.add(ExtensibleClient.newPair("aid", albumId));
        }
        if (null != caption) {
            params.add(ExtensibleClient.newPair("caption", caption));
        }
        params.add(ExtensibleClient.newPair("uid", userId));
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_UPLOAD_NOSESSION, params);
    }

    @Override
    @Deprecated
    public boolean users_isAppAdded(Long userId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED_NOSESSION, ExtensibleClient.newPair("uid", userId)));
    }

    @Override
    public boolean users_setStatus(String status, Long userId) throws FacebookException, IOException {
        return this.users_setStatus(status, false, userId);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, Long userId) throws FacebookException, IOException {
        return this.users_setStatus(newStatus, clear, false, userId);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, boolean statusIncludesVerb, Long userId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (newStatus != null) {
            params.add(ExtensibleClient.newPair("status", newStatus));
        }
        if (clear) {
            params.add(ExtensibleClient.newPair("clear", "true"));
        }
        if (statusIncludesVerb) {
            params.add(ExtensibleClient.newPair("status_includes_verb", "true"));
        }
        params.add(ExtensibleClient.newPair("uid", userId));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS_NOSESSION, params));
    }

    @Override
    public T feed_getRegisteredTemplateBundleByID(Long id) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FEED_GET_TEMPLATE_BY_ID, ExtensibleClient.newPair("template_bundle_id", id));
    }

    @Override
    public T feed_getRegisteredTemplateBundles() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FEED_GET_TEMPLATES, new Pair[0]);
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId) throws FacebookException, IOException {
        return this.feed_publishUserAction(bundleId, null, null, null);
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId, Map<String, String> templateData, List<Long> targetIds, String bodyGeneral) throws FacebookException, IOException {
        return this.feed_publishUserAction(bundleId, templateData, null, targetIds, bodyGeneral, 0);
    }

    @Override
    public Long feed_registerTemplateBundle(String template) throws FacebookException, IOException {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(template);
        return this.feed_registerTemplateBundle(temp);
    }

    @Override
    public Long feed_registerTemplateBundle(Collection<String> templates) throws FacebookException, IOException {
        return this.feed_registerTemplateBundle(templates, null, null);
    }

    @Override
    public Long feed_registerTemplateBundle(Collection<String> templates, Collection<BundleStoryTemplate> shortTemplates, BundleStoryTemplate longTemplate) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray templateArray = new JSONArray();
        for (String template : templates) {
            templateArray.put((Object)template);
        }
        params.add(ExtensibleClient.newPair("one_line_story_templates", templateArray.toString()));
        if (shortTemplates != null && !shortTemplates.isEmpty()) {
            JSONArray shortArray = new JSONArray();
            for (BundleStoryTemplate template : shortTemplates) {
                shortArray.put((Object)template.toJson());
            }
            params.add(ExtensibleClient.newPair("short_story_templates", shortArray.toString()));
        }
        if (longTemplate != null) {
            params.add(ExtensibleClient.newPair("full_story_template", longTemplate.toJsonString()));
        }
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.FEED_REGISTER_TEMPLATE, params));
    }

    @Override
    @Deprecated
    public Long feed_registerTemplateBundle(String template, String shortTemplate, String longTemplate) throws FacebookException, IOException {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add(template);
        return this.feed_registerTemplateBundle(templates, null, null);
    }

    @Override
    public T profile_getFBML() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[0]);
    }

    @Override
    public T profile_getFBML(Long userId) throws FacebookException, IOException {
        if (userId != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML_NOSESSION, ExtensibleClient.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[0]);
    }

    @Override
    public T profile_getFBML(int type) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, ExtensibleClient.newPair("type", type));
    }

    @Override
    public T profile_getFBML(int type, Long userId) throws FacebookException, IOException {
        if (userId != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML_NOSESSION, ExtensibleClient.newPair("type", type), ExtensibleClient.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, ExtensibleClient.newPair("type", type));
    }

    @Override
    public T profile_getInfo(Long userId) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_INFO, ExtensibleClient.newPair("uid", userId));
    }

    @Override
    public T profile_getInfoOptions(String field) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_INFO_OPTIONS, ExtensibleClient.newPair("field", field));
    }

    @Override
    public void profile_setInfo(Long userId, String title, boolean textOnly, List<ProfileInfoField> fields) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray json = new JSONArray();
        params.add(ExtensibleClient.newPair("uid", userId));
        params.add(ExtensibleClient.newPair("title", title));
        if (textOnly) {
            params.add(ExtensibleClient.newPair("type", "1"));
        } else {
            params.add(ExtensibleClient.newPair("type", "5"));
        }
        for (ProfileInfoField field : fields) {
            try {
                JSONObject innerJSON = new JSONObject();
                JSONArray fieldItems = new JSONArray();
                innerJSON.put("field", (Object)field.getFieldName());
                for (ProfileFieldItem item : field.getItems()) {
                    JSONObject itemJSON = new JSONObject();
                    for (String key : item.getMap().keySet()) {
                        itemJSON.put(key, (Object)item.getMap().get(key));
                    }
                    fieldItems.put((Object)itemJSON);
                }
                innerJSON.put("items", (Object)fieldItems);
                json.put((Object)innerJSON);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        params.add(ExtensibleClient.newPair("info_fields", json.toString()));
        this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_INFO, params);
    }

    @Override
    public void profile_setInfoOptions(ProfileInfoField field) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(2);
        ExtensibleClient.addParam("field", field.getFieldName(), params);
        JSONArray json = new JSONArray();
        for (ProfileFieldItem item : field.getItems()) {
            JSONObject itemJSON = new JSONObject();
            for (String key : item.getMap().keySet()) {
                try {
                    itemJSON.put(key, (Object)item.getMap().get(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            json.put((Object)itemJSON);
        }
        ExtensibleClient.addParam("options", json.toString(), params);
        this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_INFO_OPTIONS, params);
    }

    @Override
    public T photos_addTags(Long photoId, Collection<PhotoTag> tags, Long userId) throws FacebookException, IOException {
        assert (photoId > 0L);
        assert (null != tags && !tags.isEmpty());
        String tagStr = null;
        try {
            JSONArray jsonTags = new JSONArray();
            for (PhotoTag tag : tags) {
                jsonTags.put((Object)tag.jsonify());
            }
            tagStr = jsonTags.toString();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG_NOSESSION, ExtensibleClient.newPair("pid", photoId.toString()), ExtensibleClient.newPair("tags", tagStr), ExtensibleClient.newPair("uid", Long.toString(userId)));
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), ExtensibleClient.toString(mobileFbmlMarkup), null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), ExtensibleClient.toString(mobileFbmlMarkup), null);
    }

    @Override
    public boolean profile_setMobileFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, null, null, ExtensibleClient.toString(fbmlMarkup), null);
    }

    @Override
    public boolean profile_setMobileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, null, null, ExtensibleClient.toString(fbmlMarkup), null);
    }

    @Override
    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, null, ExtensibleClient.toString(fbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, null, ExtensibleClient.toString(fbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setProfileFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, ExtensibleClient.toString(fbmlMarkup), null, null, null);
    }

    @Override
    public boolean profile_setProfileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(fbmlMarkup), null, null, null);
    }

    @Override
    public boolean profile_setFBML(Long userId, String profileFbml, String actionFbml, String mobileFbml) throws FacebookException, IOException {
        return this.profile_setFBML(userId, profileFbml, actionFbml, mobileFbml, null);
    }

    @Override
    public boolean profile_setFBML(Long userId, String profileFbml, String actionFbml, String mobileFbml, String profileMain) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        ExtensibleClient.addParamIfNotBlank("uid", userId, params);
        ExtensibleClient.addParamIfNotBlank("profile", profileFbml, params);
        ExtensibleClient.addParamIfNotBlank("profile_action", actionFbml, params);
        ExtensibleClient.addParamIfNotBlank("mobile_fbml", mobileFbml, params);
        ExtensibleClient.addParamIfNotBlank("profile_main", profileMain, params);
        FacebookMethod method = this.isDesktop() || userId == null ? FacebookMethod.PROFILE_SET_FBML : FacebookMethod.PROFILE_SET_FBML_NOSESSION;
        return this.extractBoolean(this.callMethod((IFacebookMethod)method, params));
    }

    @Override
    public void setServerUrl(String newUrl) {
        String base = newUrl;
        if (base.startsWith("http")) {
            base = base.substring(base.indexOf("://") + 3);
        }
        try {
            String url = "http://" + base;
            this._serverUrl = new URL(url);
            this.setDefaultServerUrl(this._serverUrl);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public URL getDefaultServerUrl() {
        return SERVER_URL;
    }

    @Override
    public void setDefaultServerUrl(URL newUrl) {
        SERVER_URL = newUrl;
    }

    @Override
    public Boolean liveMessage_send(Long recipient, String eventName, JSONObject message) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        params.add(ExtensibleClient.newPair("recipient", recipient));
        params.add(ExtensibleClient.newPair("event_name", eventName));
        params.add(ExtensibleClient.newPair("message", message.toString()));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.LIVEMESSAGE_SEND, params));
    }

    @Override
    public T admin_getMetrics(Set<Metric> metrics, Date start, Date end, long period) throws FacebookException, IOException {
        return this.admin_getMetrics(metrics, start.getTime(), end.getTime(), period);
    }

    @Override
    public T admin_getMetrics(Set<Metric> metrics, long start, long end, long period) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (metrics != null) {
            metrics.remove((Object)Metric.DAILY_ACTIVE_USERS);
            if (!metrics.isEmpty()) {
                JSONArray metricsJson = new JSONArray();
                for (Metric metric : metrics) {
                    metricsJson.put((Object)metric.getName());
                }
                params.add(ExtensibleClient.newPair("metrics", metricsJson.toString()));
            }
        }
        params.add(ExtensibleClient.newPair("start_time", start / 1000L));
        params.add(ExtensibleClient.newPair("end_time", end / 1000L));
        params.add(ExtensibleClient.newPair("period", period));
        return this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_METRICS, params);
    }

    @Override
    public boolean feed_deactivateTemplateBundleByID(Long bundleId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("template_bundle_id", Long.toString(bundleId)));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_DEACTIVATE_TEMPLATE_BUNDLE, params));
    }

    @Override
    public void notifications_send(Collection<Long> recipientIds, String notification, boolean isAppToUser) throws FacebookException, IOException {
        if (null == notification || "".equals(notification)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You cannot send an empty notification!");
        }
        Pair<String, String> type = new Pair<String, String>("type", isAppToUser ? "app_to_user" : "user_to_user");
        if (recipientIds != null && !recipientIds.isEmpty()) {
            this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_SEND, new Pair<String, CharSequence>("to_ids", ExtensibleClient.delimit(recipientIds)), new Pair<String, String>("notification", notification), type);
        } else {
            this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_SEND, new Pair<String, String>("notification", notification), type);
        }
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId, Map<String, String> templateData, List<IFeedImage> images, List<Long> targetIds, String bodyGeneral, int storySize) throws FacebookException, IOException {
        if (images != null && images.size() > 4) {
            throw new IllegalArgumentException("Maximum of 4 images allowed per feed item.");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("template_bundle_id", Long.toString(bundleId)));
        if (targetIds != null && !targetIds.isEmpty()) {
            params.add(new Pair<String, CharSequence>("target_ids", ExtensibleClient.delimit(targetIds)));
        }
        if (bodyGeneral != null && !"".equals(bodyGeneral)) {
            params.add(new Pair<String, String>("body_general", bodyGeneral));
        }
        if (storySize == 1 || storySize == 2 || storySize == 4) {
            params.add(new Pair<String, String>("story_size", Integer.toString(storySize)));
        }
        JSONObject jsonTemplateData = new JSONObject();
        if (templateData != null && !templateData.isEmpty()) {
            for (String key : templateData.keySet()) {
                try {
                    jsonTemplateData.put(key, (Object)templateData.get(key));
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error constructing JSON object", exception);
                }
            }
        }
        if (images != null && !images.isEmpty()) {
            try {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < images.size(); ++i) {
                    IFeedImage image = images.get(i);
                    JSONObject jsonImage = new JSONObject();
                    jsonImage.put("src", (Object)image.getImageUrlString());
                    jsonImage.put("href", (Object)image.getLinkUrl().toExternalForm());
                    jsonArray.put(i, (Object)jsonImage);
                }
                jsonTemplateData.put("images", (Object)jsonArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error constructing JSON object", exception);
            }
        }
        if (jsonTemplateData.length() > 0) {
            params.add(new Pair<String, String>("template_data", jsonTemplateData.toString()));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_PUBLISH_USER_ACTION, params));
    }

    public static void printDom(Node n, String prefix, StringBuilder sb) {
        String outString = prefix;
        outString = n.getNodeType() == 3 ? outString + "'" + n.getTextContent().trim() + "'" : outString + n.getNodeName();
        sb.append(outString);
        sb.append("\n");
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            ExtensibleClient.printDom(children.item(i), prefix + "  ", sb);
        }
    }

    private static Pair<String, CharSequence> newPair(String name, Object value) {
        return new Pair<String, CharSequence>(name, String.valueOf(value));
    }

    private static Pair<String, CharSequence> newPair(String name, CharSequence value) {
        return new Pair<String, CharSequence>(name, value);
    }

    private static Pair<String, CharSequence> newPair(String name, Long value) {
        return new Pair<String, CharSequence>(name, Long.toString(value));
    }

    private static Pair<String, CharSequence> newPair(String name, Integer value) {
        return new Pair<String, CharSequence>(name, Integer.toString(value));
    }

    public static boolean addParam(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        params.add(ExtensibleClient.newPair(name, value));
        return true;
    }

    public static boolean addParamIfNotBlank(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        if (value != null) {
            return ExtensibleClient.addParam(name, value, params);
        }
        return false;
    }

    public static boolean addParam(String name, CharSequence value, Collection<Pair<String, CharSequence>> params) {
        params.add(ExtensibleClient.newPair(name, value));
        return true;
    }

    public static boolean addParamIfNotBlank(String name, CharSequence value, Collection<Pair<String, CharSequence>> params) {
        if (value != null && !"".equals(value)) {
            params.add(ExtensibleClient.newPair(name, value));
            return true;
        }
        return false;
    }

    public static String toString(CharSequence cs) {
        return cs == null ? null : ((Object)cs).toString();
    }

    protected boolean extractBoolean(T result) {
        if (result == null) {
            return false;
        }
        return 1 == this.extractInt(result);
    }

    protected abstract int extractInt(T var1);

    protected abstract Long extractLong(T var1);

    protected abstract URL extractURL(T var1) throws IOException;

    protected abstract String extractString(T var1);

    static {
        try {
            SERVER_URL = new URL("http://api.facebook.com/restserver.php");
            HTTPS_SERVER_URL = new URL("https://api.facebook.com/restserver.php");
        }
        catch (MalformedURLException ex) {
            log.error((Object)("MalformedURLException: " + ex.getMessage()), (Throwable)ex);
        }
    }
}

