/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class FacebookReturnTypeProcessor5
implements AnnotationProcessor {
    PrintWriter outJAXB;
    PrintWriter outJSON;
    PrintWriter outXML;
    AnnotationProcessorEnvironment processingEnv;

    public FacebookReturnTypeProcessor5(AnnotationProcessorEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    private CharSequence modifiers(ConstructorDeclaration e) {
        StringBuilder modifiers = new StringBuilder();
        Collection modifierSet = e.getModifiers();
        boolean isFirstModifier = true;
        for (Modifier m : modifierSet) {
            if (!isFirstModifier) {
                modifiers.append(" ");
            }
            modifiers.append(m.toString());
        }
        return modifiers;
    }

    private CharSequence throwClause(ConstructorDeclaration e) {
        StringBuilder throwClause = new StringBuilder();
        Collection thrownTypes = e.getThrownTypes();
        boolean isFirstThrows = true;
        for (ReferenceType t : thrownTypes) {
            if (isFirstThrows) {
                throwClause.append("throws ");
            } else {
                throwClause.append(", ");
            }
            throwClause.append(t.toString());
        }
        return throwClause;
    }

    private CharSequence throwClause(MethodDeclaration e) {
        StringBuilder throwClause = new StringBuilder();
        Collection thrownTypes = e.getThrownTypes();
        boolean isFirstThrows = true;
        for (ReferenceType t : thrownTypes) {
            if (isFirstThrows) {
                throwClause.append("throws ");
            } else {
                throwClause.append(", ");
            }
            throwClause.append(t.toString());
        }
        return throwClause;
    }

    private CharSequence parametersIncludingTypes(ConstructorDeclaration e) {
        StringBuilder methodCode = new StringBuilder();
        boolean isFirstParam = true;
        Collection parameters = e.getParameters();
        for (ParameterDeclaration param : parameters) {
            if (!isFirstParam) {
                methodCode.append(", ");
            }
            TypeMirror paramType = param.getType();
            methodCode.append(paramType.toString());
            methodCode.append(" ");
            String paramName = param.toString();
            if (paramName.contains(" ")) {
                paramName = paramName.substring(paramName.indexOf(32) + 1);
            }
            methodCode.append(paramName);
            isFirstParam = false;
        }
        return methodCode;
    }

    private CharSequence parametersIncludingTypes(MethodDeclaration e) {
        StringBuilder methodCode = new StringBuilder();
        boolean isFirstParam = true;
        Collection parameters = e.getParameters();
        for (ParameterDeclaration param : parameters) {
            if (!isFirstParam) {
                methodCode.append(", ");
            }
            TypeMirror paramType = param.getType();
            methodCode.append(paramType.toString());
            methodCode.append(" ");
            String paramName = param.toString();
            if (paramName.contains(" ")) {
                paramName = paramName.substring(paramName.indexOf(32) + 1);
            }
            methodCode.append(paramName);
            isFirstParam = false;
        }
        return methodCode;
    }

    private CharSequence parametersExcludingTypes(ConstructorDeclaration e) {
        StringBuilder paramListCode = new StringBuilder();
        boolean isFirstParam = true;
        Collection parameters = e.getParameters();
        for (ParameterDeclaration param : parameters) {
            String paramName;
            if (!isFirstParam) {
                paramListCode.append(", ");
            }
            if ((paramName = param.toString()).contains(" ")) {
                paramName = paramName.substring(paramName.indexOf(32) + 1);
            }
            paramListCode.append(paramName);
            isFirstParam = false;
        }
        return paramListCode;
    }

    private CharSequence parametersExcludingTypes(MethodDeclaration e) {
        StringBuilder paramListCode = new StringBuilder();
        boolean isFirstParam = true;
        Collection parameters = e.getParameters();
        for (ParameterDeclaration param : parameters) {
            String paramName;
            if (!isFirstParam) {
                paramListCode.append(", ");
            }
            if ((paramName = param.toString()).contains(" ")) {
                paramName = paramName.substring(paramName.indexOf(32) + 1);
            }
            paramListCode.append(paramName);
            isFirstParam = false;
        }
        return paramListCode;
    }

    private void writeHeader(PrintWriter out, String classNamePart, String now) {
        out.println("package com.google.code.facebookapi;");
        out.println();
        if (classNamePart.equals("Jaxb")) {
            out.println("@SuppressWarnings(\"unchecked\")");
        }
        out.println("public class Facebook" + classNamePart + "RestClient extends Facebook" + classNamePart + "RestClientBase {");
        out.println();
    }

    public void process() {
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.mmmZ");
        String now = isoDateFormat.format(new Date());
        try {
            this.outJAXB = this.processingEnv.getFiler().createSourceFile("com.google.code.facebookapi.FacebookJaxbRestClient");
            this.outJSON = this.processingEnv.getFiler().createSourceFile("com.google.code.facebookapi.FacebookJsonRestClient");
            this.outXML = this.processingEnv.getFiler().createSourceFile("com.google.code.facebookapi.FacebookXmlRestClient");
        }
        catch (IOException ex) {
            System.out.println("Ignoring second attempt to process annotations");
            return;
        }
        this.writeHeader(this.outJAXB, "Jaxb", now);
        this.writeHeader(this.outJSON, "Json", now);
        this.writeHeader(this.outXML, "Xml", now);
        CopyConstructorVisitor copyConstructorsJaxb = new CopyConstructorVisitor("Jaxb", this.outJAXB);
        CopyConstructorVisitor copyConstructorsJson = new CopyConstructorVisitor("Json", this.outJSON);
        CopyConstructorVisitor copyConstructorsXml = new CopyConstructorVisitor("Xml", this.outXML);
        ClassDeclaration facebookJaxbRestClientBase = (ClassDeclaration)this.processingEnv.getTypeDeclaration("com.google.code.facebookapi.FacebookJaxbRestClientBase");
        for (ConstructorDeclaration cd : facebookJaxbRestClientBase.getConstructors()) {
            cd.accept((DeclarationVisitor)copyConstructorsJaxb);
        }
        ClassDeclaration facebookJsonRestClientBase = (ClassDeclaration)this.processingEnv.getTypeDeclaration("com.google.code.facebookapi.FacebookJsonRestClientBase");
        for (ConstructorDeclaration cd : facebookJsonRestClientBase.getConstructors()) {
            cd.accept((DeclarationVisitor)copyConstructorsJson);
        }
        ClassDeclaration facebookXmlRestClientBase = (ClassDeclaration)this.processingEnv.getTypeDeclaration("com.google.code.facebookapi.FacebookXmlRestClientBase");
        for (ConstructorDeclaration cd : facebookXmlRestClientBase.getConstructors()) {
            cd.accept((DeclarationVisitor)copyConstructorsXml);
        }
        AnnotationVisitor visitor = new AnnotationVisitor();
        Collection elements = this.processingEnv.getDeclarationsAnnotatedWith((AnnotationTypeDeclaration)this.processingEnv.getTypeDeclaration("com.google.code.facebookapi.FacebookReturnType"));
        for (Declaration element : elements) {
            element.accept((DeclarationVisitor)visitor);
        }
        this.outJAXB.println("}");
        this.outJAXB.flush();
        this.outJAXB.close();
        this.outJSON.println("}");
        this.outJSON.flush();
        this.outJSON.close();
        this.outXML.println("}");
        this.outXML.flush();
        this.outXML.close();
    }

    private void shakeEnclosingElementMethods(MethodDeclaration e) {
        e.getDeclaringType().getMethods();
    }

    String stripDotClass(String input) {
        if (!input.endsWith(".class")) {
            return input;
        }
        return input.substring(0, input.length() - 6);
    }

    class AnnotationVisitor
    extends SimpleDeclarationVisitor {
        AnnotationVisitor() {
        }

        public void visitMethodDeclaration(MethodDeclaration e) {
            FacebookReturnTypeProcessor5.this.shakeEnclosingElementMethods(e);
            String jaxbReturnType = "Object";
            String jsonReturnType = "Object";
            String xmlReturnType = "org.w3c.dom.Document";
            Collection annotations = e.getAnnotationMirrors();
            AnnotationMirror firstAnnotation = (AnnotationMirror)annotations.iterator().next();
            Map annotationParams = firstAnnotation.getElementValues();
            boolean jaxbAlreadySet = false;
            for (AnnotationTypeElementDeclaration key : annotationParams.keySet()) {
                if (key.getSimpleName().contentEquals("JAXBList")) {
                    if (annotationParams.get(key) == null) continue;
                    jaxbReturnType = "java.util.List<" + FacebookReturnTypeProcessor5.this.stripDotClass(((AnnotationValue)annotationParams.get(key)).toString()) + ">";
                    jaxbAlreadySet = true;
                    continue;
                }
                if (!jaxbAlreadySet && key.getSimpleName().contentEquals("JAXB")) {
                    if (annotationParams.get(key) == null) continue;
                    jaxbReturnType = FacebookReturnTypeProcessor5.this.stripDotClass(((AnnotationValue)annotationParams.get(key)).toString());
                    continue;
                }
                if (!key.getSimpleName().contentEquals("JSON") || annotationParams.get(key) == null) continue;
                jsonReturnType = FacebookReturnTypeProcessor5.this.stripDotClass(((AnnotationValue)annotationParams.get(key)).toString());
            }
            StringBuilder methodCode = new StringBuilder();
            if (e.getAnnotation(Deprecated.class) != null) {
                methodCode.append("    @Deprecated").append(System.getProperty("line.separator"));
            }
            methodCode.append("    public ");
            methodCode.append("%RETURNTYPE%");
            methodCode.append(" ");
            methodCode.append(e.getSimpleName()).append("( ");
            methodCode.append(FacebookReturnTypeProcessor5.this.parametersIncludingTypes(e));
            methodCode.append(" ) ");
            methodCode.append(FacebookReturnTypeProcessor5.this.throwClause(e));
            methodCode.append(" {");
            CharSequence paramListCode = FacebookReturnTypeProcessor5.this.parametersExcludingTypes(e);
            FacebookReturnTypeProcessor5.this.outJAXB.println(methodCode.toString().replace("%RETURNTYPE%", jaxbReturnType));
            FacebookReturnTypeProcessor5.this.outJAXB.println("        client.setResponseFormat(\"xml\");");
            FacebookReturnTypeProcessor5.this.outJAXB.println("        Object rawResponse = client." + e.getSimpleName() + "( " + paramListCode + " );");
            FacebookReturnTypeProcessor5.this.outJAXB.println("        return (" + jaxbReturnType + ")parseCallResult( rawResponse );");
            FacebookReturnTypeProcessor5.this.outJAXB.println("    }");
            FacebookReturnTypeProcessor5.this.outJAXB.println();
            FacebookReturnTypeProcessor5.this.outJSON.println(methodCode.toString().replace("%RETURNTYPE%", jsonReturnType));
            FacebookReturnTypeProcessor5.this.outJSON.println("        client.setResponseFormat(\"json\");");
            FacebookReturnTypeProcessor5.this.outJSON.println("        Object rawResponse = client." + e.getSimpleName() + "( " + paramListCode + " );");
            FacebookReturnTypeProcessor5.this.outJSON.println("        return (" + jsonReturnType + ")parseCallResult( rawResponse );");
            FacebookReturnTypeProcessor5.this.outJSON.println("    }");
            FacebookReturnTypeProcessor5.this.outJSON.println();
            FacebookReturnTypeProcessor5.this.outXML.println(methodCode.toString().replace("%RETURNTYPE%", xmlReturnType));
            FacebookReturnTypeProcessor5.this.outXML.println("        client.setResponseFormat(\"xml\");");
            FacebookReturnTypeProcessor5.this.outXML.println("        Object rawResponse = client." + e.getSimpleName() + "( " + paramListCode + " );");
            FacebookReturnTypeProcessor5.this.outXML.println("        return (" + xmlReturnType + ")parseCallResult( rawResponse );");
            FacebookReturnTypeProcessor5.this.outXML.println("    }");
            FacebookReturnTypeProcessor5.this.outXML.println();
        }
    }

    class CopyConstructorVisitor
    extends SimpleDeclarationVisitor {
        String clientType;
        PrintWriter out;

        CopyConstructorVisitor(String clientType, PrintWriter out) {
            this.clientType = clientType;
            this.out = out;
        }

        public void visitConstructorDeclaration(ConstructorDeclaration e) {
            this.out.print("    ");
            this.out.print(FacebookReturnTypeProcessor5.this.modifiers(e));
            this.out.print(" ");
            this.out.print("Facebook");
            this.out.print(this.clientType);
            this.out.print("RestClient");
            this.out.print("( ");
            this.out.print(FacebookReturnTypeProcessor5.this.parametersIncludingTypes(e));
            this.out.print(" ) ");
            this.out.print(FacebookReturnTypeProcessor5.this.throwClause(e));
            this.out.println(" {");
            this.out.print("        super( ");
            this.out.print(FacebookReturnTypeProcessor5.this.parametersExcludingTypes(e));
            this.out.println(" );");
            this.out.println("    }");
            this.out.println();
        }
    }
}

