package cn.com.cjf.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import cn.com.cjf.entity.Char;

/**
 * ļ- - յԴļļع
 * @author saiya wyd1011@126.com
 * @lastEdit 2008-10-28
 */
public class LoadConfig {
	
	
	/**
	 * Ҫص -ӳļļĸʽUTF-8
	 */
	public static final String fjMapUTF8="fj_map_utf8.properties";
	
	
	/**
	 * Ҫص -ӳļļʽUTF-8
	 */
	public static final String jfMapUTF8="jf_map_utf8.properties";
	
	
	/**
	 * LoadConfig 
	 */
	private static LoadConfig instance = null ;
	
	
	/**
	 * ñ
	 * @return
	 */
	public static LoadConfig getInstance(){
		if(instance==null){
			instance=new LoadConfig();
		}
		return instance;
	}
	
	
	/**
	 * ط-ӳ䣬 Char[] ʽ
	 * @return
	 * @throws IOException ԴļIO⣬ļеԴݳ쳣ʱ׳
	 */
	public Char[] loadFJmapUTF8() throws IOException{
		String line=null;
		ArrayList list = new ArrayList();
		BufferedReader br = null;
		Char[] charList = null;
		try{
			br = this.getReader(fjMapUTF8);
			int index=0;
			while((line=br.readLine())!=null){
				if(line.startsWith("#")){
					continue;
				}
				if(line.trim().length()==0){
					continue;
				}
				char fChar=line.charAt(0);
				char jChar=line.charAt(2);
				if(index>=(int)fChar){
					list=null;
					throw new IOException("Բļ["+fjMapUTF8+"]⣡FCharId="+(int)fChar);
				}
				index=(int)fChar;
				list.add(new Char(jChar,fChar));
			}
			charList=new Char[list.size()];
			for(int i=0;i<list.size();i++){
				charList[i]=(Char)list.get(i);
			}
			list=null;
		}catch(IOException ex){
			list=null;
			throw ex;
		}finally{
			if(br!=null){try{br.close();}catch(IOException ex){}}
		}
		return charList;
	}
	
	
	
	/**
	 *  -ӳ䣬 Char[] ʽ
	 * @return
	 * @throws IOException ԴļIO⣬ļеԴݳ쳣ʱ׳
	 */
	public Char[] loadJFmapUTF8() throws IOException{
		String line=null;
		ArrayList list = new ArrayList();
		Char[] charList = null;
		BufferedReader br = null;
		try{
			br=this.getReader(jfMapUTF8);
			int index=0;
			while((line=br.readLine())!=null){
				if(line.startsWith("#")){
					continue;
				}
				if(line.trim().length()==0){
					continue;
				}
				char jChar=line.charAt(0);
				char fChar=line.charAt(2);
				if(index>=(int)jChar){
					list=null;
					throw new IOException("Բļ["+jfMapUTF8+"]⣡JCharId="+(int)jChar);
				}
				index=(int)jChar;
				list.add(new Char(jChar,fChar));
			}
			
			charList=new Char[list.size()];
			for(int i=0;i<list.size();i++){
				charList[i]=(Char)list.get(i);
			}
			list=null;
		}catch(IOException ex){
			list=null;
			throw ex;
		}finally{
			if(br!=null){try{br.close();}catch(IOException ex){}}
		}
		return charList;
	}
	
	
	
	/**
	 * һͬĿ¼һļͻһ"UTF-8"BufferedReader
	 * @param file ļ
	 * @return BufferedReader
	 * @throws RuntimeException IO쳣
	 */
	protected BufferedReader getReader(String file){
		BufferedReader bufferedReader = null;
		try{
			InputStream is = this.getClass().getResourceAsStream(file);
			InputStreamReader isr = new InputStreamReader(is , "UTF-8");
			bufferedReader = new BufferedReader(isr);
		}catch(IOException ex){
			bufferedReader=null;
			throw new RuntimeException(ex);
		}
		return bufferedReader;
	}
	
	
}
