/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.watcher.SpannerUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerUtilsTest {
    @Test
    public void TestBuildKey() {
        ResultSet resultSet = ResultSets.forRows((Type)Type.struct(Arrays.asList(Type.StructField.of((String)"bool", (Type)Type.bool()), Type.StructField.of((String)"bytes", (Type)Type.bytes()), Type.StructField.of((String)"date", (Type)Type.date()), Type.StructField.of((String)"float64", (Type)Type.float64()), Type.StructField.of((String)"int64", (Type)Type.int64()), Type.StructField.of((String)"numeric", (Type)Type.numeric()), Type.StructField.of((String)"string", (Type)Type.string()), Type.StructField.of((String)"timestamp", (Type)Type.timestamp()))), Arrays.asList(((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("bool").to(true)).set("bytes").to(ByteArray.copyFrom((String)"test"))).set("date").to(Date.fromYearMonthDay((int)2000, (int)1, (int)1))).set("float64").to(3.14)).set("int64").to(1L)).set("numeric").to(BigDecimal.ONE)).set("string").to("string")).set("timestamp").to(Timestamp.ofTimeMicroseconds((long)1000L))).build()));
        resultSet.next();
        Key key = SpannerUtils.buildKey(Arrays.asList("bool", "bytes", "date", "float64", "int64", "numeric", "string", "timestamp"), (ResultSet)resultSet);
        Iterator parts = key.getParts().iterator();
        Assert.assertEquals((Object)true, parts.next());
        Assert.assertEquals((Object)ByteArray.copyFrom((String)"test"), parts.next());
        Assert.assertEquals((Object)Date.fromYearMonthDay((int)2000, (int)1, (int)1), parts.next());
        Assert.assertEquals((Object)3.14, parts.next());
        Assert.assertEquals((Object)1L, parts.next());
        Assert.assertEquals((Object)BigDecimal.ONE, parts.next());
        Assert.assertEquals((Object)"string", parts.next());
        Assert.assertEquals((Object)Timestamp.ofTimeMicroseconds((long)1000L), parts.next());
    }
}

