/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ApiService;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.watcher.CommitTimestampRepository;
import com.google.cloud.spanner.watcher.FixedShardProvider;
import com.google.cloud.spanner.watcher.RowImpl;
import com.google.cloud.spanner.watcher.ShardProvider;
import com.google.cloud.spanner.watcher.SpannerCommitTimestampRepository;
import com.google.cloud.spanner.watcher.SpannerTableChangeWatcher;
import com.google.cloud.spanner.watcher.SpannerUtils;
import com.google.cloud.spanner.watcher.TableId;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.threeten.bp.Duration;

public class SpannerTableTailer
extends AbstractApiService
implements SpannerTableChangeWatcher {
    static final Logger logger = Logger.getLogger(SpannerTableTailer.class.getName());
    static final long MAX_WITH_QUERY_LIMIT = 100000L;
    static final int MAX_WITH_QUERY_SHARD_VALUES = 100;
    static final int DEFAULT_FALLBACK_TO_WITH_QUERY_SECONDS = 60;
    static final long DEFAULT_LIMIT = 10000L;
    static final String POLL_QUERY = "SELECT *\nFROM %s\nWHERE `%s`%s@prevCommitTimestamp";
    static final String POLL_QUERY_ORDER_BY = "\nORDER BY `%s`, %s\nLIMIT @limit";
    private final Object lock = new Object();
    private ScheduledFuture<?> scheduled;
    private ApiFuture<Void> currentPollFuture;
    private Statement lastPollStatement;
    private final DatabaseClient client;
    private final TableId table;
    private final String tableHint;
    private final long limit;
    private final int fallbackToWithQuerySeconds;
    private final ShardProvider shardProvider;
    private final List<SpannerTableChangeWatcher.RowChangeCallback> callbacks = new LinkedList<SpannerTableChangeWatcher.RowChangeCallback>();
    private final CommitTimestampRepository commitTimestampRepository;
    private final Duration pollInterval;
    private final ScheduledExecutorService executor;
    private final boolean isOwnedExecutor;
    private Timestamp startedPollWithCommitTimestamp;
    private Timestamp lastSeenCommitTimestamp;
    private boolean lastPollReturnedChanges;
    private int mutationCountForLastCommitTimestamp;
    private String commitTimestampColumn;
    private List<String> primaryKeyColumns;
    private String primaryKeyColumnsList;
    private WithPollQueryBuilder withPollQueryBuilder;

    public static Builder newBuilder(Spanner spanner, TableId table) {
        return new Builder(spanner, table);
    }

    private SpannerTableTailer(Builder builder) {
        this.client = builder.spanner.getDatabaseClient(builder.table.getDatabaseId());
        this.table = builder.table;
        this.tableHint = (String)Preconditions.checkNotNull((Object)builder.tableHint);
        this.limit = builder.limit;
        this.fallbackToWithQuerySeconds = builder.fallbackToWithQuerySeconds;
        this.shardProvider = builder.shardProvider;
        this.commitTimestampRepository = builder.commitTimestampRepository;
        this.pollInterval = builder.pollInterval;
        this.executor = builder.executor == null ? Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("spanner-tailer-" + this.table + "-%d").build()) : builder.executor;
        boolean bl = this.isOwnedExecutor = builder.executor == null;
        if (builder.commitTimestampColumn != null) {
            this.commitTimestampColumn = builder.commitTimestampColumn;
        }
    }

    @Override
    public void addCallback(SpannerTableChangeWatcher.RowChangeCallback callback) {
        Preconditions.checkState((this.state() == ApiService.State.NEW ? 1 : 0) != 0);
        this.callbacks.add(callback);
    }

    @Override
    public TableId getTable() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getLastPollStatement() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastPollStatement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastPollReturnedChanges() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastPollReturnedChanges;
        }
    }

    protected void doStart() {
        logger.log(Level.INFO, "Starting watcher for table {0}", this.table);
        final ApiFuture<String> commitTimestampColFut = this.commitTimestampColumn == null ? SpannerUtils.getTimestampColumn(this.client, this.table) : ApiFutures.immediateFuture((Object)this.commitTimestampColumn);
        commitTimestampColFut.addListener(new Runnable(){

            @Override
            public void run() {
                logger.log(Level.INFO, "Initializing watcher for table {0}", SpannerTableTailer.this.table);
                try {
                    if (SpannerTableTailer.this.shardProvider == null) {
                        SpannerTableTailer.this.lastSeenCommitTimestamp = SpannerTableTailer.this.commitTimestampRepository.get(SpannerTableTailer.this.table);
                    } else {
                        SpannerTableTailer.this.lastSeenCommitTimestamp = SpannerTableTailer.this.commitTimestampRepository.get(SpannerTableTailer.this.table, SpannerTableTailer.this.shardProvider.getShardValue());
                    }
                    SpannerTableTailer.this.commitTimestampColumn = (String)Futures.getUnchecked((Future)commitTimestampColFut);
                    SpannerTableTailer.this.primaryKeyColumns = (List)SpannerUtils.getPrimaryKeyColumns(SpannerTableTailer.this.client, SpannerTableTailer.this.table).get();
                    SpannerTableTailer.this.primaryKeyColumnsList = "`" + String.join((CharSequence)"`, `", SpannerTableTailer.this.primaryKeyColumns) + "`";
                    if (SpannerTableTailer.this.canUseWithQuery()) {
                        SpannerTableTailer.this.withPollQueryBuilder = new WithPollQueryBuilder();
                    }
                    logger.log(Level.INFO, "Watcher started for table {0}", SpannerTableTailer.this.table);
                    SpannerTableTailer.this.notifyStarted();
                    SpannerTableTailer.this.scheduled = SpannerTableTailer.this.executor.schedule(new SpannerTailerRunner(false), 0L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Could not initialize watcher for table {0}", (Object)SpannerTableTailer.this.table, t));
                    SpannerTableTailer.this.notifyFailed(t);
                }
            }
        }, (Executor)this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFailed(Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOwnedExecutor) {
                this.executor.shutdown();
            }
        }
        super.notifyFailed(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduled == null || this.scheduled.cancel(false)) {
                if (this.isOwnedExecutor) {
                    this.executor.shutdown();
                }
                this.notifyStopped();
            }
        }
    }

    boolean canUseWithQuery() {
        if (this.limit > 100000L) {
            return false;
        }
        if (this.shardProvider == null) {
            return false;
        }
        if (this.shardProvider.getColumnName() == null) {
            return false;
        }
        Value value = this.shardProvider.getShardValue();
        if (value == null) {
            return false;
        }
        if (value.getType().getCode() != Type.Code.ARRAY) {
            return false;
        }
        List<ShardProvider> providers = SpannerTableTailer.splitArrayValueShardProvider(this.shardProvider);
        return providers.size() <= 100;
    }

    static List<ShardProvider> splitArrayValueShardProvider(ShardProvider shardProvider) {
        Value value = shardProvider.getShardValue();
        String column = shardProvider.getColumnName();
        Supplier<String> paramNameSupplier = new Supplier<String>(){
            int index = 0;

            @Override
            public String get() {
                return "param" + this.index++;
            }
        };
        switch (value.getType().getArrayElementType().getCode()) {
            case BOOL: {
                return value.getBoolArray().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$0(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
            case BYTES: {
                return value.getBytesArray().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$1(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
            case DATE: {
                return value.getDateArray().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$2(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
            case FLOAT64: {
                return value.getFloat64Array().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$3(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
            case INT64: {
                return value.getInt64Array().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$4(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
            case JSON: {
                return value.getJsonArray().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$5(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
            case NUMERIC: {
                return value.getNumericArray().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$6(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
            case STRING: {
                return value.getStringArray().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$7(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
            case TIMESTAMP: {
                return value.getTimestampArray().stream().map(arg_0 -> SpannerTableTailer.lambda$splitArrayValueShardProvider$8(column, (Supplier)paramNameSupplier, arg_0)).collect(Collectors.toList());
            }
        }
        throw new IllegalArgumentException();
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$8(String column, Supplier paramNameSupplier, Timestamp b) {
        return new FixedShardProvider(column, Value.timestamp((Timestamp)b), (String)paramNameSupplier.get());
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$7(String column, Supplier paramNameSupplier, String b) {
        return new FixedShardProvider(column, Value.string((String)b), (String)paramNameSupplier.get());
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$6(String column, Supplier paramNameSupplier, BigDecimal b) {
        return new FixedShardProvider(column, Value.numeric((BigDecimal)b), (String)paramNameSupplier.get());
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$5(String column, Supplier paramNameSupplier, String b) {
        return new FixedShardProvider(column, Value.json((String)b), (String)paramNameSupplier.get());
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$4(String column, Supplier paramNameSupplier, Long b) {
        return new FixedShardProvider(column, Value.int64((Long)b), (String)paramNameSupplier.get());
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$3(String column, Supplier paramNameSupplier, Double b) {
        return new FixedShardProvider(column, Value.float64((Double)b), (String)paramNameSupplier.get());
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$2(String column, Supplier paramNameSupplier, Date b) {
        return new FixedShardProvider(column, Value.date((Date)b), (String)paramNameSupplier.get());
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$1(String column, Supplier paramNameSupplier, ByteArray b) {
        return new FixedShardProvider(column, Value.bytes((ByteArray)b), (String)paramNameSupplier.get());
    }

    private static /* synthetic */ FixedShardProvider lambda$splitArrayValueShardProvider$0(String column, Supplier paramNameSupplier, Boolean b) {
        return new FixedShardProvider(column, Value.bool((Boolean)b), (String)paramNameSupplier.get());
    }

    class WithPollQueryBuilder {
        final Statement.Builder withPollQuery = this.generateWithPollQuery();

        WithPollQueryBuilder() throws ExecutionException, InterruptedException {
        }

        private Statement.Builder generateWithPollQuery() {
            List<ShardProvider> providers = SpannerTableTailer.splitArrayValueShardProvider(SpannerTableTailer.this.shardProvider);
            Statement.Builder builder = Statement.newBuilder((String)"WITH\n");
            int index = 0;
            for (ShardProvider provider : providers) {
                builder.append("S").append(String.valueOf(index)).append(" AS (\n");
                builder.append("SELECT ").append(SpannerTableTailer.this.primaryKeyColumnsList).append(", ");
                builder.append(String.format("`%s`", SpannerTableTailer.this.commitTimestampColumn)).append("\n");
                builder.append("FROM ").append(SpannerTableTailer.this.table.getSqlIdentifier()).append(SpannerTableTailer.this.tableHint).append("\n");
                builder.append(String.format("WHERE `%s`>@prevCommitTimestamp", SpannerTableTailer.this.commitTimestampColumn));
                provider.appendShardFilter(builder);
                builder.append(String.format(SpannerTableTailer.POLL_QUERY_ORDER_BY, SpannerTableTailer.this.commitTimestampColumn, SpannerTableTailer.this.primaryKeyColumnsList));
                builder.append("\n),");
                ++index;
            }
            builder.append("AllShards AS (\n");
            builder.append("SELECT ").append(SpannerTableTailer.this.primaryKeyColumnsList).append("\n");
            builder.append("FROM (\n");
            for (index = 0; index < providers.size(); ++index) {
                if (index > 0) {
                    builder.append("UNION ALL\n");
                }
                builder.append("SELECT *\n").append("FROM S").append(String.valueOf(index)).append("\n");
            }
            builder.append(")");
            builder.append(String.format(SpannerTableTailer.POLL_QUERY_ORDER_BY, SpannerTableTailer.this.commitTimestampColumn, SpannerTableTailer.this.primaryKeyColumnsList));
            builder.append("\n)\n");
            builder.append(String.format("SELECT %s.*\nFROM AllShards\n", SpannerTableTailer.this.table.getSqlIdentifier()));
            builder.append("INNER JOIN ").append(SpannerTableTailer.this.table.getSqlIdentifier());
            builder.append(" ON ");
            index = 0;
            for (String pk : SpannerTableTailer.this.primaryKeyColumns) {
                if (index > 0) {
                    builder.append(" AND ");
                }
                builder.append(String.format("%s.`%s`=AllShards.`%s`", SpannerTableTailer.this.table.getSqlIdentifier(), pk, pk));
            }
            builder.append(String.format(SpannerTableTailer.POLL_QUERY_ORDER_BY, SpannerTableTailer.this.commitTimestampColumn, SpannerTableTailer.this.primaryKeyColumnsList));
            return builder;
        }
    }

    class SpannerTailerRunner
    implements Runnable {
        private final boolean finishCurrentCommitTimestamp;

        SpannerTailerRunner(boolean finishCurrentCommitTimestamp) {
            this.finishCurrentCommitTimestamp = finishCurrentCommitTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Statement.Builder statementBuilder;
            boolean shouldUseWithQuery;
            logger.log(Level.FINE, String.format("Starting poll for commit timestamp %s", SpannerTableTailer.this.lastSeenCommitTimestamp.toString()));
            SpannerTableTailer.this.startedPollWithCommitTimestamp = SpannerTableTailer.this.lastSeenCommitTimestamp;
            Object object = SpannerTableTailer.this.lock;
            synchronized (object) {
                shouldUseWithQuery = SpannerTableTailer.this.lastPollReturnedChanges && !this.finishCurrentCommitTimestamp && SpannerTableTailer.this.withPollQueryBuilder != null && Timestamp.now().getSeconds() - SpannerTableTailer.this.lastSeenCommitTimestamp.getSeconds() > (long)SpannerTableTailer.this.fallbackToWithQuerySeconds;
            }
            if (shouldUseWithQuery) {
                statementBuilder = ((SpannerTableTailer)SpannerTableTailer.this).withPollQueryBuilder.withPollQuery;
            } else {
                String operator = this.finishCurrentCommitTimestamp ? "=" : ">";
                statementBuilder = Statement.newBuilder((String)String.format(SpannerTableTailer.POLL_QUERY, SpannerTableTailer.this.table.getSqlIdentifier() + SpannerTableTailer.this.tableHint, SpannerTableTailer.this.commitTimestampColumn, operator));
                if (SpannerTableTailer.this.shardProvider != null) {
                    SpannerTableTailer.this.shardProvider.appendShardFilter(statementBuilder);
                }
                statementBuilder.append(String.format(SpannerTableTailer.POLL_QUERY_ORDER_BY, SpannerTableTailer.this.commitTimestampColumn, SpannerTableTailer.this.primaryKeyColumnsList));
                if (this.finishCurrentCommitTimestamp) {
                    statementBuilder.append(String.format(" OFFSET %d", SpannerTableTailer.this.mutationCountForLastCommitTimestamp));
                }
            }
            Statement statement = ((Statement.Builder)((Statement.Builder)statementBuilder.bind("prevCommitTimestamp").to(SpannerTableTailer.this.lastSeenCommitTimestamp)).bind("limit").to(SpannerTableTailer.this.limit)).build();
            if (!this.finishCurrentCommitTimestamp) {
                Object object2 = SpannerTableTailer.this.lock;
                synchronized (object2) {
                    SpannerTableTailer.this.lastPollStatement = statement;
                }
            }
            try (AsyncResultSet rs = SpannerTableTailer.this.client.singleUse().executeQueryAsync(statement, new Options.QueryOption[0]);){
                SpannerTableTailer.this.currentPollFuture = rs.setCallback((Executor)SpannerTableTailer.this.executor, (AsyncResultSet.ReadyCallback)new SpannerTailerCallback(this.finishCurrentCommitTimestamp));
            }
        }
    }

    class SpannerTailerCallback
    implements AsyncResultSet.ReadyCallback {
        private final boolean scheduleNextPollDirectlyAfterThis;
        private int mutationCount;

        SpannerTailerCallback(boolean scheduleNextPollDirectlyAfterThis) {
            this.scheduleNextPollDirectlyAfterThis = scheduleNextPollDirectlyAfterThis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleNextPollOrStop(final boolean reachedLimit) {
            if (SpannerTableTailer.this.lastSeenCommitTimestamp.compareTo(SpannerTableTailer.this.startedPollWithCommitTimestamp) > 0) {
                if (SpannerTableTailer.this.shardProvider == null) {
                    SpannerTableTailer.this.commitTimestampRepository.set(SpannerTableTailer.this.table, SpannerTableTailer.this.lastSeenCommitTimestamp);
                } else {
                    SpannerTableTailer.this.commitTimestampRepository.set(SpannerTableTailer.this.table, SpannerTableTailer.this.shardProvider.getShardValue(), SpannerTableTailer.this.lastSeenCommitTimestamp);
                }
            }
            Object object = SpannerTableTailer.this.lock;
            synchronized (object) {
                if (SpannerTableTailer.this.state() == ApiService.State.RUNNING) {
                    SpannerTableTailer.this.currentPollFuture.addListener(new Runnable(){

                        @Override
                        public void run() {
                            SpannerTableTailer.this.scheduled = SpannerTableTailer.this.executor.schedule(new SpannerTailerRunner(reachedLimit), reachedLimit || SpannerTailerCallback.this.scheduleNextPollDirectlyAfterThis ? 0L : SpannerTableTailer.this.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
                        }
                    }, MoreExecutors.directExecutor());
                } else {
                    if (SpannerTableTailer.this.isOwnedExecutor) {
                        SpannerTableTailer.this.executor.shutdown();
                    }
                    if (SpannerTableTailer.this.state() == ApiService.State.STOPPING) {
                        SpannerTableTailer.this.currentPollFuture.addListener(new Runnable(){

                            @Override
                            public void run() {
                                SpannerTableTailer.this.notifyStopped();
                            }
                        }, MoreExecutors.directExecutor());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
            try {
                while (true) {
                    Object object = SpannerTableTailer.this.lock;
                    synchronized (object) {
                        if (SpannerTableTailer.this.state() != ApiService.State.RUNNING) {
                            this.scheduleNextPollOrStop(false);
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                    }
                    switch (resultSet.tryNext()) {
                        case DONE: {
                            object = SpannerTableTailer.this.lock;
                            synchronized (object) {
                                SpannerTableTailer.this.lastPollReturnedChanges = this.mutationCount > 0 || this.scheduleNextPollDirectlyAfterThis;
                            }
                            this.scheduleNextPollOrStop((long)this.mutationCount == SpannerTableTailer.this.limit);
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case OK: {
                            Timestamp ts = resultSet.getTimestamp(SpannerTableTailer.this.commitTimestampColumn);
                            RowImpl row = new RowImpl((ResultSet)resultSet);
                            for (SpannerTableChangeWatcher.RowChangeCallback callback : SpannerTableTailer.this.callbacks) {
                                callback.rowChange(SpannerTableTailer.this.table, row, ts);
                            }
                            if (ts.compareTo(SpannerTableTailer.this.lastSeenCommitTimestamp) > 0) {
                                SpannerTableTailer.this.lastSeenCommitTimestamp = ts;
                                SpannerTableTailer.this.mutationCountForLastCommitTimestamp = 1;
                            } else {
                                SpannerTableTailer.this.mutationCountForLastCommitTimestamp++;
                            }
                            ++this.mutationCount;
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Error processing change set for table {0}", (Object)SpannerTableTailer.this.table, t));
                SpannerTableTailer.this.notifyFailed(t);
                this.scheduleNextPollOrStop(false);
                return AsyncResultSet.CallbackResponse.DONE;
            }
        }
    }

    public static class Builder {
        private final Spanner spanner;
        private final TableId table;
        private String tableHint = "";
        private long limit = 10000L;
        private int fallbackToWithQuerySeconds = 60;
        private ShardProvider shardProvider;
        private CommitTimestampRepository commitTimestampRepository;
        private Duration pollInterval = Duration.ofSeconds((long)1L);
        private ScheduledExecutorService executor;
        private String commitTimestampColumn;

        private Builder(Spanner spanner, TableId table) {
            this.spanner = (Spanner)Preconditions.checkNotNull((Object)spanner);
            this.table = (TableId)Preconditions.checkNotNull((Object)table);
            this.commitTimestampRepository = SpannerCommitTimestampRepository.newBuilder(spanner, table.getDatabaseId()).build();
        }

        public Builder setTableHint(String tableHint) {
            this.tableHint = (String)Preconditions.checkNotNull((Object)tableHint);
            return this;
        }

        public Builder setLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder setFallbackToWithQuerySeconds(int seconds) {
            this.fallbackToWithQuerySeconds = seconds;
            return this;
        }

        public Builder setShardProvider(ShardProvider provider) {
            this.shardProvider = provider;
            return this;
        }

        public Builder setCommitTimestampRepository(CommitTimestampRepository repository) {
            this.commitTimestampRepository = (CommitTimestampRepository)Preconditions.checkNotNull((Object)repository);
            return this;
        }

        public Builder setPollInterval(Duration interval) {
            this.pollInterval = (Duration)Preconditions.checkNotNull((Object)interval);
            return this;
        }

        public Builder setExecutor(ScheduledExecutorService executor) {
            this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
            return this;
        }

        public Builder setCommitTimestampColumn(String column) {
            this.commitTimestampColumn = column;
            return this;
        }

        public SpannerTableTailer build() {
            return new SpannerTableTailer(this);
        }
    }
}

