/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.extension.springboot;

import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.api.buildplan.LayerObject;
import com.google.cloud.tools.jib.maven.extension.JibMavenPluginExtension;
import com.google.cloud.tools.jib.maven.extension.MavenData;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class JibSpringBootExtension
implements JibMavenPluginExtension<Void> {
    public Optional<Class<Void>> getExtraConfigType() {
        return Optional.empty();
    }

    public ContainerBuildPlan extendContainerBuildPlan(ContainerBuildPlan buildPlan, Map<String, String> properties, Optional<Void> config, MavenData mavenData, ExtensionLogger logger) throws JibPluginExtensionException {
        logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Running Jib Spring Boot extension");
        if (!JibSpringBootExtension.shouldExcludeDevtools(mavenData.getMavenProject(), logger)) {
            logger.log(ExtensionLogger.LogLevel.INFO, "Keeping spring-boot-devtools (if any)");
            return buildPlan;
        }
        logger.log(ExtensionLogger.LogLevel.INFO, "Removing spring-boot-devtools (if any)");
        List newLayers = buildPlan.getLayers().stream().map(JibSpringBootExtension::filterOutDevtools).collect(Collectors.toList());
        return buildPlan.toBuilder().setLayers(newLayers).build();
    }

    @VisibleForTesting
    static boolean isDevtoolsJar(File file) {
        return file.getName().startsWith("spring-boot-devtools-") && file.getName().endsWith(".jar");
    }

    @VisibleForTesting
    static boolean shouldExcludeDevtools(MavenProject project, ExtensionLogger logger) {
        Xpp3Dom excludeDevtools;
        Plugin bootPlugin = project.getPlugin("org.springframework.boot:spring-boot-maven-plugin");
        if (bootPlugin == null) {
            logger.log(ExtensionLogger.LogLevel.WARN, "Jib Spring Boot extension: project doesn't have spring-boot-maven-plugin?");
            return true;
        }
        Xpp3Dom configuration = (Xpp3Dom)bootPlugin.getConfiguration();
        if (configuration != null && (excludeDevtools = configuration.getChild("excludeDevtools")) != null) {
            return "true".equalsIgnoreCase(excludeDevtools.getValue());
        }
        return true;
    }

    @VisibleForTesting
    static LayerObject filterOutDevtools(LayerObject layerObject) {
        String dependencyLayerName = JavaContainerBuilder.LayerType.DEPENDENCIES.getName();
        if (!dependencyLayerName.equals(layerObject.getName())) {
            return layerObject;
        }
        FileEntriesLayer layer = (FileEntriesLayer)layerObject;
        Predicate<FileEntry> notDevtoolsJar = fileEntry -> !JibSpringBootExtension.isDevtoolsJar(fileEntry.getSourceFile().toFile());
        List newEntries = layer.getEntries().stream().filter(notDevtoolsJar).collect(Collectors.toList());
        return layer.toBuilder().setEntries(newEntries).build();
    }
}

