/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.UpdateChecker;
import com.google.cloud.tools.jib.plugins.common.VersionChecker;
import com.google.cloud.tools.jib.plugins.common.globalconfig.GlobalConfig;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class MojoCommon {
    public static final String REQUIRED_VERSION_PROPERTY_NAME = "jib.requiredVersion";
    public static final String VERSION_URL = "https://storage.googleapis.com/jib-versions/jib-maven";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Future<Optional<String>> newUpdateChecker(ProjectProperties projectProperties, GlobalConfig globalConfig, Log logger) {
        if (projectProperties.isOffline() || !logger.isInfoEnabled() || globalConfig.isDisableUpdateCheck()) {
            return Futures.immediateFuture(Optional.empty());
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<Optional<String>> future = UpdateChecker.checkForUpdate(executorService, VERSION_URL, projectProperties.getToolName(), projectProperties.getToolVersion(), projectProperties::log);
            return future;
        }
        finally {
            executorService.shutdown();
        }
    }

    static void finishUpdateChecker(ProjectProperties projectProperties, Future<Optional<String>> updateCheckFuture) {
        UpdateChecker.finishUpdateCheck(updateCheckFuture).ifPresent(latestVersion -> {
            String updateMessage = String.format("A new version of %s (%s) is available (currently using %s). Update your build configuration to use the latest features and fixes!", projectProperties.getToolName(), latestVersion, projectProperties.getToolVersion());
            String privacyUrl = "https://github.com/GoogleContainerTools/jib/blob/master/docs/privacy.md";
            String privacyMessage = String.format("Please see %s for info on disabling this update check.", privacyUrl);
            projectProperties.log(LogEvent.lifecycle(""));
            projectProperties.log(LogEvent.lifecycle("\u001b[33m" + updateMessage + "\u001b[0m"));
            projectProperties.log(LogEvent.lifecycle("\u001b[33mhttps://github.com/GoogleContainerTools/jib/blob/master/jib-maven-plugin/CHANGELOG.md\u001b[0m"));
            projectProperties.log(LogEvent.lifecycle(""));
            projectProperties.log(LogEvent.lifecycle(privacyMessage));
            projectProperties.log(LogEvent.lifecycle(""));
        });
    }

    static List<JibPluginConfiguration.ExtraDirectoryParameters> getExtraDirectories(JibPluginConfiguration jibPluginConfiguration) {
        List<JibPluginConfiguration.ExtraDirectoryParameters> extraDirectories = jibPluginConfiguration.getExtraDirectories();
        if (!extraDirectories.isEmpty()) {
            for (JibPluginConfiguration.ExtraDirectoryParameters directory : extraDirectories) {
                if (!directory.getFrom().equals(Paths.get("", new String[0]))) continue;
                throw new IllegalArgumentException("Incomplete <extraDirectories><paths> configuration; source directory must be set");
            }
            return extraDirectories;
        }
        MavenProject project = (MavenProject)Preconditions.checkNotNull((Object)jibPluginConfiguration.getProject());
        return Collections.singletonList(new JibPluginConfiguration.ExtraDirectoryParameters(project.getBasedir().toPath().resolve("src").resolve("main").resolve("jib").toFile(), "/"));
    }

    static Map<String, FilePermissions> convertPermissionsList(List<JibPluginConfiguration.PermissionConfiguration> permissionList) {
        LinkedHashMap<String, FilePermissions> permissionsMap = new LinkedHashMap<String, FilePermissions>();
        for (JibPluginConfiguration.PermissionConfiguration permission : permissionList) {
            Optional<String> file = permission.getFile();
            Optional<String> mode = permission.getMode();
            if (!file.isPresent() || !mode.isPresent()) {
                throw new IllegalArgumentException("Incomplete <permission> configuration; requires <file> and <mode> fields to be set");
            }
            permissionsMap.put(file.get(), FilePermissions.fromOctalString((String)mode.get()));
        }
        return permissionsMap;
    }

    public static void checkJibVersion(PluginDescriptor descriptor) throws MojoExecutionException {
        String acceptableVersionSpec = System.getProperty(REQUIRED_VERSION_PROPERTY_NAME);
        if (acceptableVersionSpec == null) {
            return;
        }
        String actualVersion = descriptor.getVersion();
        if (actualVersion == null) {
            throw new MojoExecutionException("Could not determine Jib plugin version");
        }
        VersionChecker<DefaultArtifactVersion> checker = new VersionChecker<DefaultArtifactVersion>(DefaultArtifactVersion::new);
        if (!checker.compatibleVersion(acceptableVersionSpec, actualVersion)) {
            String failure = String.format("Jib plugin version is %s but is required to be %s", actualVersion, acceptableVersionSpec);
            throw new MojoExecutionException(failure);
        }
    }

    public static boolean shouldSkipJibExecution(JibPluginConfiguration jibPluginConfiguration) {
        Log log = jibPluginConfiguration.getLog();
        if (jibPluginConfiguration.isSkipped()) {
            log.info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return true;
        }
        if (!jibPluginConfiguration.isContainerizable()) {
            log.info((CharSequence)"Skipping containerization of this module (not specified in jib.containerize)");
            return true;
        }
        if ("pom".equals(jibPluginConfiguration.getProject().getPackaging())) {
            log.info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return true;
        }
        return false;
    }

    private MojoCommon() {
    }
}

