/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.cloud.tools.jib.registry.credentials.json.DockerConfigTemplate;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class DockerConfig {
    private final DockerConfigTemplate dockerConfigTemplate;

    @Nullable
    private static <K, T> Map.Entry<K, T> findFirstInMapByKey(Map<K, T> map, List<Predicate<K>> keyMatches) {
        return keyMatches.stream().map(keyMatch -> DockerConfig.findFirstInMapByKey(map, keyMatch)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private static <K, T> Map.Entry<K, T> findFirstInMapByKey(Map<K, T> map, Predicate<K> keyMatch) {
        return map.entrySet().stream().filter(entry -> keyMatch.test(entry.getKey())).findFirst().orElse(null);
    }

    DockerConfig(DockerConfigTemplate dockerConfigTemplate) {
        this.dockerConfigTemplate = dockerConfigTemplate;
    }

    @Nullable
    DockerConfigTemplate.AuthTemplate getAuthFor(String registry) {
        Map.Entry<String, DockerConfigTemplate.AuthTemplate> authEntry = DockerConfig.findFirstInMapByKey(this.dockerConfigTemplate.getAuths(), this.getRegistryMatchersFor(registry));
        return authEntry != null ? authEntry.getValue() : null;
    }

    @Nullable
    DockerCredentialHelper getCredentialHelperFor(String registry) {
        List registryMatchers = this.getRegistryMatchersFor(registry);
        Map.Entry<String, String> firstCredHelperMatch = DockerConfig.findFirstInMapByKey(this.dockerConfigTemplate.getCredHelpers(), registryMatchers);
        if (firstCredHelperMatch != null) {
            return new DockerCredentialHelper(firstCredHelperMatch.getKey(), Paths.get("docker-credential-" + firstCredHelperMatch.getValue(), new String[0]));
        }
        if (this.dockerConfigTemplate.getCredsStore() != null) {
            return new DockerCredentialHelper(registry, Paths.get("docker-credential-" + this.dockerConfigTemplate.getCredsStore(), new String[0]));
        }
        return null;
    }

    private List<Predicate<String>> getRegistryMatchersFor(String registry) {
        Predicate<String> exactMatch = registry::equals;
        Predicate<String> withHttps = ("https://" + registry)::equals;
        Predicate<String> withSuffix = name -> name.startsWith(registry + "/");
        Predicate<String> withHttpsAndSuffix = name -> name.startsWith("https://" + registry + "/");
        return Arrays.asList(exactMatch, withHttps, withSuffix, withHttpsAndSuffix);
    }
}

