/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.skaffold;

import com.google.api.client.util.Strings;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.skaffold.SkaffoldBindingMojo;
import com.google.cloud.tools.jib.maven.skaffold.SkaffoldConfiguration;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.SkaffoldFilesOutput;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;

@Mojo(name="_skaffold-files-v2", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, aggregator=true)
public class FilesMojoV2
extends SkaffoldBindingMojo {
    @VisibleForTesting
    static final String GOAL_NAME = "_skaffold-files-v2";
    @Nullable
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Nullable
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Nullable
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    private final SkaffoldFilesOutput skaffoldFilesOutput = new SkaffoldFilesOutput();

    @VisibleForTesting
    static Set<Path> getKotlinSourceDirectories(MavenProject project) {
        Plugin kotlinPlugin = project.getPlugin("org.jetbrains.kotlin:kotlin-maven-plugin");
        if (kotlinPlugin == null) {
            return Collections.emptySet();
        }
        Path projectBaseDir = project.getBasedir().toPath();
        Set<Path> kotlinSourceDirectories = kotlinPlugin.getExecutions().stream().filter(execution -> !execution.getGoals().contains("test-compile")).map(execution -> (Xpp3Dom)execution.getConfiguration()).filter(Objects::nonNull).map(configuration -> configuration.getChild("sourceDirs")).filter(Objects::nonNull).map(sourceDirs -> Arrays.asList(sourceDirs.getChildren())).flatMap(Collection::stream).map(Xpp3Dom::getValue).filter(value -> !Strings.isNullOrEmpty((String)value)).map(x$0 -> Paths.get(x$0, new String[0])).map(path -> path.isAbsolute() ? path : projectBaseDir.resolve((Path)path)).collect(Collectors.toSet());
        Path conventionalDirectory = projectBaseDir.resolve(Paths.get("src", "main", "kotlin"));
        kotlinSourceDirectories.add(conventionalDirectory);
        return kotlinSourceDirectories;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Preconditions.checkNotNull(this.projects);
        Preconditions.checkNotNull((Object)this.session);
        Preconditions.checkNotNull((Object)this.projectDependenciesResolver);
        this.checkJibVersion();
        for (MavenProject project : this.projects) {
            this.skaffoldFilesOutput.addBuild(project.getFile().toPath());
            if ("pom".equals(project.getPackaging())) continue;
            this.skaffoldFilesOutput.addInput(Paths.get(project.getBuild().getSourceDirectory(), new String[0]));
            for (Path directory : FilesMojoV2.getKotlinSourceDirectories(project)) {
                this.skaffoldFilesOutput.addInput(directory);
            }
            project.getBuild().getResources().stream().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0])).forEach(this.skaffoldFilesOutput::addInput);
            if (project.getPlugin("com.google.cloud.tools:jib-maven-plugin") != null) {
                this.resolveExtraDirectories(project).forEach(this.skaffoldFilesOutput::addInput);
            }
            SkaffoldConfiguration.Watch watch = this.collectWatchParameters(project);
            this.resolveFiles(watch.buildIncludes, project).forEach(this.skaffoldFilesOutput::addBuild);
            this.resolveFiles(watch.includes, project).forEach(this.skaffoldFilesOutput::addInput);
            this.resolveFiles(watch.excludes, project).forEach(this.skaffoldFilesOutput::addIgnore);
            Set projectArtifacts = this.projects.stream().map(MavenProject::getArtifact).map(Object::toString).collect(Collectors.toSet());
            DependencyFilter ignoreProjectDependenciesFilter = (node, parents) -> {
                if (node == null || node.getDependency() == null) {
                    return false;
                }
                if (projectArtifacts.contains(node.getArtifact().toString())) {
                    return false;
                }
                return "compile+runtime".contains(node.getDependency().getScope());
            };
            try {
                DependencyResolutionResult resolutionResult = this.projectDependenciesResolver.resolve(new DefaultDependencyResolutionRequest(project, this.session.getRepositorySession()).setResolutionFilter(ignoreProjectDependenciesFilter));
                resolutionResult.getDependencies().stream().map(Dependency::getArtifact).filter(Artifact::isSnapshot).map(Artifact::getFile).map(File::toPath).forEach(this.skaffoldFilesOutput::addInput);
            }
            catch (DependencyResolutionException ex) {
                throw new MojoExecutionException("Failed to resolve dependencies", (Exception)((Object)ex));
            }
        }
        try {
            System.out.println();
            System.out.println("BEGIN JIB JSON");
            System.out.println(this.skaffoldFilesOutput.getJsonString());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private List<Path> resolveExtraDirectories(MavenProject project) {
        return this.collectExtraDirectories(project).stream().map(path -> path.isAbsolute() ? path : project.getBasedir().toPath().resolve((Path)path)).collect(Collectors.toList());
    }

    private List<Path> collectExtraDirectories(MavenProject project) {
        Xpp3Dom paths;
        Xpp3Dom extraDirectoriesConfiguration;
        Xpp3Dom pluginConfiguration;
        String property = MavenProjectProperties.getProperty("jib.extraDirectories.paths", project, this.session);
        if (property != null) {
            List<String> paths2 = ConfigurationPropertyValidator.parseListProperty(property);
            return paths2.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        }
        Plugin jibMavenPlugin = project.getPlugin("com.google.cloud.tools:jib-maven-plugin");
        if (jibMavenPlugin != null && (pluginConfiguration = (Xpp3Dom)jibMavenPlugin.getConfiguration()) != null && (extraDirectoriesConfiguration = pluginConfiguration.getChild("extraDirectories")) != null && (paths = extraDirectoriesConfiguration.getChild("paths")) != null) {
            return this.xpp3ToList(paths, x$0 -> Paths.get(x$0, new String[0]));
        }
        Path projectBase = ((MavenProject)Preconditions.checkNotNull((Object)project)).getBasedir().getAbsoluteFile().toPath();
        Path srcMainJib = Paths.get("src", "main", "jib");
        return Collections.singletonList(projectBase.resolve(srcMainJib));
    }

    private SkaffoldConfiguration.Watch collectWatchParameters(MavenProject project) {
        Xpp3Dom watch;
        Xpp3Dom skaffold;
        Xpp3Dom pluginConfiguration;
        SkaffoldConfiguration.Watch watchConfig = new SkaffoldConfiguration.Watch();
        Plugin jibMavenPlugin = project.getPlugin("com.google.cloud.tools:jib-maven-plugin");
        if (jibMavenPlugin != null && (pluginConfiguration = (Xpp3Dom)jibMavenPlugin.getConfiguration()) != null && (skaffold = pluginConfiguration.getChild("skaffold")) != null && (watch = skaffold.getChild("watch")) != null) {
            Xpp3Dom excludes;
            Xpp3Dom includes;
            Xpp3Dom buildIncludes = watch.getChild("buildIncludes");
            if (buildIncludes != null) {
                watchConfig.buildIncludes = this.xpp3ToList(buildIncludes, File::new);
            }
            if ((includes = watch.getChild("includes")) != null) {
                watchConfig.includes = this.xpp3ToList(includes, File::new);
            }
            if ((excludes = watch.getChild("excludes")) != null) {
                watchConfig.excludes = this.xpp3ToList(excludes, File::new);
            }
        }
        return watchConfig;
    }

    private List<Path> resolveFiles(List<File> files, MavenProject project) {
        return files.stream().map(File::toPath).map(path -> path.isAbsolute() ? path : project.getBasedir().toPath().resolve((Path)path)).collect(Collectors.toList());
    }

    private <T> List<T> xpp3ToList(Xpp3Dom node, Function<String, T> converter) {
        Preconditions.checkNotNull((Object)node);
        return Arrays.stream(node.getChildren()).map(Xpp3Dom::getValue).map(converter).collect(Collectors.toList());
    }
}

