/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenHelpfulSuggestions;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenRawConfiguration;
import com.google.cloud.tools.jib.maven.MavenSettingsProxyProvider;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.InvalidCreationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidFilesModificationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, threadSafe=true)
public class BuildImageMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "build";
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Build image failed";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkJibVersion();
        if (MojoCommon.shouldSkipJibExecution(this)) {
            return;
        }
        if (Arrays.stream(ImageFormat.values()).noneMatch(value -> value.name().equals(this.getFormat()))) {
            throw new MojoFailureException("<format> parameter is configured with value '" + this.getFormat() + "', but the only valid configuration options are '" + (Object)((Object)ImageFormat.Docker) + "' and '" + (Object)((Object)ImageFormat.OCI) + "'.");
        }
        if (Strings.isNullOrEmpty((String)this.getTargetImage())) {
            throw new MojoFailureException(HelpfulSuggestions.forToNotConfigured("Missing target image parameter", "<to><image>", "pom.xml", "mvn compile jib:build -Dimage=<your image name>"));
        }
        MavenSettingsProxyProvider.activateHttpAndHttpsProxies(this.getSession().getSettings(), this.getSettingsDecrypter());
        TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();
        MavenProjectProperties projectProperties = MavenProjectProperties.getForProject((PluginDescriptor)Preconditions.checkNotNull((Object)this.descriptor), this.getProject(), this.getSession(), this.getLog(), tempDirectoryProvider);
        Future<Optional<String>> updateCheckFuture = MojoCommon.newUpdateChecker(projectProperties, this.getLog());
        try {
            PluginConfigurationProcessor.createJibBuildRunnerForRegistryImage(new MavenRawConfiguration(this), new MavenSettingsServerCredentials(this.getSession().getSettings(), this.getSettingsDecrypter()), projectProperties, new MavenHelpfulSuggestions(HELPFUL_SUGGESTIONS_PREFIX)).runBuild();
        }
        catch (InvalidAppRootException ex) {
            throw new MojoExecutionException("<container><appRoot> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerizingModeException ex) {
            throw new MojoExecutionException("invalid value for <containerizingMode>: " + ex.getInvalidContainerizingMode(), (Exception)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new MojoExecutionException("<container><workingDirectory> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new MojoExecutionException("<container><volumes> is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Exception)ex);
        }
        catch (InvalidFilesModificationTimeException ex) {
            throw new MojoExecutionException("<container><filesModificationTime> should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or special keyword \"EPOCH_PLUS_SECOND\": " + ex.getInvalidFilesModificationTime(), (Exception)ex);
        }
        catch (InvalidCreationTimeException ex) {
            throw new MojoExecutionException("<container><creationTime> should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or a special keyword (\"EPOCH\", \"USE_CURRENT_TIMESTAMP\"): " + ex.getInvalidCreationTime(), (Exception)ex);
        }
        catch (JibPluginExtensionException ex) {
            String extensionName = ex.getExtensionClass().getName();
            throw new MojoExecutionException("error running extension '" + extensionName + "': " + ex.getMessage(), (Exception)ex);
        }
        catch (IncompatibleBaseImageJavaVersionException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forIncompatibleBaseImageJavaVersionForMaven(ex.getBaseImageMajorJavaVersion(), ex.getProjectMajorJavaVersion()), (Exception)ex);
        }
        catch (InvalidImageReferenceException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forInvalidImageReference(ex.getInvalidReference()), (Exception)ex);
        }
        catch (CacheDirectoryCreationException | MainClassInferenceException | IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        catch (BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
        finally {
            tempDirectoryProvider.close();
            MojoCommon.finishUpdateChecker(projectProperties, updateCheckFuture);
            projectProperties.waitForLoggingThread();
            this.getLog().info((CharSequence)"");
        }
    }
}

