/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api.buildplan;

import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.LayerObject;
import com.google.cloud.tools.jib.api.buildplan.Port;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ContainerBuildPlan {
    private final String baseImage;
    private final String architectureHint;
    private final String osHint;
    private final Instant creationTime;
    private final ImageFormat format;
    private final Map<String, String> environment;
    private final Map<String, String> labels;
    private final Set<AbsoluteUnixPath> volumes;
    private final Set<Port> exposedPorts;
    @Nullable
    private final String user;
    @Nullable
    private final AbsoluteUnixPath workingDirectory;
    @Nullable
    private final List<String> entrypoint;
    @Nullable
    private final List<String> cmd;
    private final List<LayerObject> layers;

    public static Builder builder() {
        return new Builder();
    }

    private ContainerBuildPlan(String baseImage, String architectureHint, String osHint, Instant creationTime, ImageFormat format, Map<String, String> environment, Map<String, String> labels, Set<AbsoluteUnixPath> volumes, Set<Port> exposedPorts, @Nullable String user, @Nullable AbsoluteUnixPath workingDirectory, @Nullable List<String> entrypoint, @Nullable List<String> cmd, List<LayerObject> layers) {
        this.baseImage = baseImage;
        this.architectureHint = architectureHint;
        this.osHint = osHint;
        this.creationTime = creationTime;
        this.format = format;
        this.environment = environment;
        this.labels = labels;
        this.volumes = volumes;
        this.exposedPorts = exposedPorts;
        this.user = user;
        this.workingDirectory = workingDirectory;
        this.entrypoint = entrypoint;
        this.cmd = cmd;
        this.layers = layers;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public String getArchitectureHint() {
        return this.architectureHint;
    }

    public String getOsHint() {
        return this.osHint;
    }

    public ImageFormat getFormat() {
        return this.format;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Map<String, String> getEnvironment() {
        return new HashMap<String, String>(this.environment);
    }

    public Set<AbsoluteUnixPath> getVolumes() {
        return new HashSet<AbsoluteUnixPath>(this.volumes);
    }

    public Map<String, String> getLabels() {
        return new HashMap<String, String>(this.labels);
    }

    public Set<Port> getExposedPorts() {
        return new HashSet<Port>(this.exposedPorts);
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    @Nullable
    public AbsoluteUnixPath getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public List<String> getEntrypoint() {
        return this.entrypoint == null ? null : new ArrayList<String>(this.entrypoint);
    }

    @Nullable
    public List<String> getCmd() {
        return this.cmd == null ? null : new ArrayList<String>(this.cmd);
    }

    public List<? extends LayerObject> getLayers() {
        return new ArrayList<LayerObject>(this.layers);
    }

    public Builder toBuilder() {
        return ContainerBuildPlan.builder().setBaseImage(this.baseImage).setArchitectureHint(this.architectureHint).setOsHint(this.osHint).setCreationTime(this.creationTime).setFormat(this.format).setEnvironment(this.environment).setLabels(this.labels).setVolumes(this.volumes).setExposedPorts(this.exposedPorts).setUser(this.user).setWorkingDirectory(this.workingDirectory).setEntrypoint(this.entrypoint).setCmd(this.cmd).setLayers(this.layers);
    }

    public static class Builder {
        private String baseImage = "scratch";
        private String architectureHint = "amd64";
        private String osHint = "linux";
        private Instant creationTime = Instant.EPOCH;
        private ImageFormat format = ImageFormat.Docker;
        private Map<String, String> environment = new HashMap<String, String>();
        private Map<String, String> labels = new HashMap<String, String>();
        private Set<AbsoluteUnixPath> volumes = new HashSet<AbsoluteUnixPath>();
        private Set<Port> exposedPorts = new HashSet<Port>();
        @Nullable
        private String user;
        @Nullable
        private AbsoluteUnixPath workingDirectory;
        @Nullable
        private List<String> entrypoint;
        @Nullable
        private List<String> cmd;
        private List<LayerObject> layers = new ArrayList<LayerObject>();

        private Builder() {
        }

        public Builder setBaseImage(String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        public Builder setArchitectureHint(String architectureHint) {
            this.architectureHint = architectureHint;
            return this;
        }

        public Builder setOsHint(String osHint) {
            this.osHint = osHint;
            return this;
        }

        public Builder setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setFormat(ImageFormat format) {
            this.format = format;
            return this;
        }

        public Builder setEnvironment(Map<String, String> environment) {
            this.environment = new HashMap<String, String>(environment);
            return this;
        }

        public Builder addEnvironmentVariable(String name, String value) {
            this.environment.put(name, value);
            return this;
        }

        public Builder setVolumes(Set<AbsoluteUnixPath> volumes) {
            this.volumes = new HashSet<AbsoluteUnixPath>(volumes);
            return this;
        }

        public Builder addVolume(AbsoluteUnixPath volume) {
            this.volumes.add(volume);
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = new HashMap<String, String>(labels);
            return this;
        }

        public Builder addLabel(String key, String value) {
            this.labels.put(key, value);
            return this;
        }

        public Builder setExposedPorts(Set<Port> exposedPorts) {
            this.exposedPorts = new HashSet<Port>(exposedPorts);
            return this;
        }

        public Builder addExposedPort(Port exposedPort) {
            this.exposedPorts.add(exposedPort);
            return this;
        }

        public Builder setUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public Builder setWorkingDirectory(@Nullable AbsoluteUnixPath workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder setEntrypoint(@Nullable List<String> entrypoint) {
            this.entrypoint = entrypoint == null ? null : new ArrayList<String>(entrypoint);
            return this;
        }

        public Builder setCmd(@Nullable List<String> cmd) {
            this.cmd = cmd == null ? null : new ArrayList<String>(cmd);
            return this;
        }

        public Builder addLayer(LayerObject layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder setLayers(List<? extends LayerObject> layer) {
            this.layers = new ArrayList<LayerObject>(layer);
            return this;
        }

        public ContainerBuildPlan build() {
            return new ContainerBuildPlan(this.baseImage, this.architectureHint, this.osHint, this.creationTime, this.format, this.environment, this.labels, this.volumes, this.exposedPorts, this.user, this.workingDirectory, this.entrypoint, this.cmd, this.layers);
        }
    }
}

