/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.Port;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.configuration.DockerHealthCheck;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ImageToJsonTranslator {
    private final Image image;

    @Nullable
    @VisibleForTesting
    static Map<String, Map<?, ?>> portSetToMap(@Nullable Set<Port> exposedPorts) {
        return ImageToJsonTranslator.setToMap(exposedPorts, port -> port.getPort() + "/" + port.getProtocol());
    }

    @Nullable
    @VisibleForTesting
    static Map<String, Map<?, ?>> volumesSetToMap(@Nullable Set<AbsoluteUnixPath> volumes) {
        return ImageToJsonTranslator.setToMap(volumes, AbsoluteUnixPath::toString);
    }

    @Nullable
    @VisibleForTesting
    static ImmutableList<String> environmentMapToList(@Nullable Map<String, String> environment) {
        if (environment == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)environment.keySet().stream().noneMatch(key -> key.contains("=")), (Object)"Illegal environment variable: name cannot contain '='");
        return (ImmutableList)environment.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private static <E> Map<String, Map<?, ?>> setToMap(@Nullable Set<E> set, Function<E, String> keyMapper) {
        if (set == null) {
            return null;
        }
        return (Map)set.stream().collect(ImmutableSortedMap.toImmutableSortedMap(String::compareTo, keyMapper, ignored -> Collections.emptyMap()));
    }

    public ImageToJsonTranslator(Image image) {
        this.image = image;
    }

    public JsonTemplate getContainerConfiguration() {
        ContainerConfigurationTemplate template = new ContainerConfigurationTemplate();
        for (Layer layer : this.image.getLayers()) {
            template.addLayerDiffId(layer.getDiffId());
        }
        for (HistoryEntry historyObject : this.image.getHistory()) {
            template.addHistoryEntry(historyObject);
        }
        template.setCreated(this.image.getCreated() == null ? null : this.image.getCreated().toString());
        template.setArchitecture(this.image.getArchitecture());
        template.setOs(this.image.getOs());
        template.setContainerEnvironment((List<String>)ImageToJsonTranslator.environmentMapToList(this.image.getEnvironment()));
        template.setContainerEntrypoint((List<String>)this.image.getEntrypoint());
        template.setContainerCmd((List<String>)this.image.getProgramArguments());
        template.setContainerExposedPorts(ImageToJsonTranslator.portSetToMap(this.image.getExposedPorts()));
        template.setContainerVolumes(ImageToJsonTranslator.volumesSetToMap(this.image.getVolumes()));
        template.setContainerLabels((Map<String, String>)this.image.getLabels());
        template.setContainerWorkingDir(this.image.getWorkingDirectory());
        template.setContainerUser(this.image.getUser());
        DockerHealthCheck healthCheck = this.image.getHealthCheck();
        if (this.image.getImageFormat() == V22ManifestTemplate.class && healthCheck != null) {
            template.setContainerHealthCheckTest(healthCheck.getCommand());
            healthCheck.getInterval().ifPresent(interval -> template.setContainerHealthCheckInterval(interval.toNanos()));
            healthCheck.getTimeout().ifPresent(timeout -> template.setContainerHealthCheckTimeout(timeout.toNanos()));
            healthCheck.getStartPeriod().ifPresent(startPeriod -> template.setContainerHealthCheckStartPeriod(startPeriod.toNanos()));
            template.setContainerHealthCheckRetries(healthCheck.getRetries().orElse(null));
        }
        return template;
    }

    public <T extends BuildableManifestTemplate> T getManifestTemplate(Class<T> manifestTemplateClass, BlobDescriptor containerConfigurationBlobDescriptor) {
        try {
            BuildableManifestTemplate template = (BuildableManifestTemplate)manifestTemplateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DescriptorDigest containerConfigurationDigest = containerConfigurationBlobDescriptor.getDigest();
            long containerConfigurationSize = containerConfigurationBlobDescriptor.getSize();
            template.setContainerConfiguration(containerConfigurationSize, containerConfigurationDigest);
            for (Layer layer : this.image.getLayers()) {
                template.addLayer(layer.getBlobDescriptor().getSize(), layer.getBlobDescriptor().getDigest());
            }
            return (T)template;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException(manifestTemplateClass + " cannot be instantiated", ex);
        }
    }
}

