/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.filesystem.RelativeUnixPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaEntrypointConstructor {
    public static final RelativeUnixPath DEFAULT_RELATIVE_RESOURCES_PATH_ON_IMAGE = RelativeUnixPath.get("resources");
    public static final RelativeUnixPath DEFAULT_RELATIVE_CLASSES_PATH_ON_IMAGE = RelativeUnixPath.get("classes");
    public static final RelativeUnixPath DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE = RelativeUnixPath.get("libs");

    public static List<String> makeDefaultEntrypoint(AbsoluteUnixPath appRoot, List<String> jvmFlags, String mainClass) {
        return JavaEntrypointConstructor.makeEntrypoint(Arrays.asList(appRoot.resolve(DEFAULT_RELATIVE_RESOURCES_PATH_ON_IMAGE).toString(), appRoot.resolve(DEFAULT_RELATIVE_CLASSES_PATH_ON_IMAGE).toString(), appRoot.resolve(DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE).resolve("*").toString()), jvmFlags, mainClass);
    }

    public static List<String> makeDistrolessJettyEntrypoint() {
        return Arrays.asList("java", "-jar", "/jetty/start.jar");
    }

    public static List<String> makeEntrypoint(List<String> classpathElements, List<String> jvmFlags, String mainClass) {
        String classpathString = String.join((CharSequence)":", classpathElements);
        ArrayList<String> entrypoint = new ArrayList<String>(4 + jvmFlags.size());
        entrypoint.add("java");
        entrypoint.addAll(jvmFlags);
        entrypoint.add("-cp");
        entrypoint.add(classpathString);
        entrypoint.add(mainClass);
        return entrypoint;
    }

    private JavaEntrypointConstructor() {
    }
}

