/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.registry.AuthenticationMethodRetriever;
import com.google.cloud.tools.jib.registry.BlobChecker;
import com.google.cloud.tools.jib.registry.BlobPuller;
import com.google.cloud.tools.jib.registry.ManifestPuller;
import com.google.cloud.tools.jib.registry.ManifestPusher;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryEndpointCaller;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class RegistryClient {
    private Timer parentTimer = new Timer(new JibLogger(){

        @Override
        public void debug(CharSequence message) {
        }

        @Override
        public void info(CharSequence message) {
        }

        @Override
        public void warn(CharSequence message) {
        }

        @Override
        public void error(CharSequence message) {
        }

        @Override
        public void lifecycle(CharSequence message) {
        }
    }, "NULL TIMER");
    private final JibLogger buildLogger;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final boolean allowInsecureRegistries;
    private final String userAgent;

    public RegistryClient setTimer(Timer parentTimer) {
        this.parentTimer = parentTimer;
        return this;
    }

    public static Factory factory(JibLogger buildLogger, String serverUrl, String imageName) {
        return new Factory(buildLogger, new RegistryEndpointRequestProperties(serverUrl, imageName));
    }

    private RegistryClient(JibLogger buildLogger, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowInsecureRegistries, String userAgent) {
        this.buildLogger = buildLogger;
        this.authorization = authorization;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.allowInsecureRegistries = allowInsecureRegistries;
        this.userAgent = userAgent;
    }

    @Nullable
    public RegistryAuthenticator getRegistryAuthenticator() throws IOException, RegistryException {
        return this.callRegistryEndpoint(new AuthenticationMethodRetriever(this.registryEndpointRequestProperties));
    }

    public <T extends ManifestTemplate> T pullManifest(String imageTag, Class<T> manifestTemplateClass) throws IOException, RegistryException {
        ManifestPuller<T> manifestPuller = new ManifestPuller<T>(this.registryEndpointRequestProperties, imageTag, manifestTemplateClass);
        ManifestTemplate manifestTemplate = (ManifestTemplate)this.callRegistryEndpoint(manifestPuller);
        if (manifestTemplate == null) {
            throw new IllegalStateException("ManifestPuller#handleResponse does not return null");
        }
        return (T)manifestTemplate;
    }

    public ManifestTemplate pullManifest(String imageTag) throws IOException, RegistryException {
        return this.pullManifest(imageTag, ManifestTemplate.class);
    }

    public void pushManifest(BuildableManifestTemplate manifestTemplate, String imageTag) throws IOException, RegistryException {
        this.callRegistryEndpoint(new ManifestPusher(this.registryEndpointRequestProperties, manifestTemplate, imageTag));
    }

    @Nullable
    public BlobDescriptor checkBlob(DescriptorDigest blobDigest) throws IOException, RegistryException {
        BlobChecker blobChecker = new BlobChecker(this.registryEndpointRequestProperties, blobDigest);
        return this.callRegistryEndpoint(blobChecker);
    }

    public Void pullBlob(DescriptorDigest blobDigest, OutputStream destinationOutputStream) throws RegistryException, IOException {
        BlobPuller blobPuller = new BlobPuller(this.registryEndpointRequestProperties, blobDigest, destinationOutputStream);
        return this.callRegistryEndpoint(blobPuller);
    }

    /*
     * Exception decompiling
     */
    public boolean pushBlob(DescriptorDigest blobDigest, Blob blob, @Nullable String sourceRepository) throws IOException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    String getApiRouteBase() {
        return this.registryEndpointRequestProperties.getServerUrl() + "/v2/";
    }

    @VisibleForTesting
    String getUserAgent() {
        return this.userAgent;
    }

    @Nullable
    private <T> T callRegistryEndpoint(RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        return new RegistryEndpointCaller<T>(this.buildLogger, this.userAgent, this.getApiRouteBase(), registryEndpointProvider, this.authorization, this.registryEndpointRequestProperties, this.allowInsecureRegistries).call();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class Factory {
        private final JibLogger buildLogger;
        private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
        private boolean allowInsecureRegistries = false;
        @Nullable
        private String userAgentSuffix;
        @Nullable
        private Authorization authorization;

        private Factory(JibLogger buildLogger, RegistryEndpointRequestProperties registryEndpointRequestProperties) {
            this.buildLogger = buildLogger;
            this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        }

        public Factory setAllowInsecureRegistries(boolean allowInsecureRegistries) {
            this.allowInsecureRegistries = allowInsecureRegistries;
            return this;
        }

        public Factory setAuthorization(@Nullable Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public Factory setUserAgentSuffix(@Nullable String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public RegistryClient newRegistryClient() {
            return new RegistryClient(this.buildLogger, this.authorization, this.registryEndpointRequestProperties, this.allowInsecureRegistries, this.makeUserAgent());
        }

        private String makeUserAgent() {
            if (!JibSystemProperties.isUserAgentEnabled()) {
                return "";
            }
            String version = RegistryClient.class.getPackage().getImplementationVersion();
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("jib");
            if (version != null) {
                userAgentBuilder.append(" ").append(version);
            }
            if (this.userAgentSuffix != null) {
                userAgentBuilder.append(" ").append(this.userAgentSuffix);
            }
            return userAgentBuilder.toString();
        }
    }
}

