/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.filesystem.TemporaryDirectory;
import com.google.cloud.tools.jib.hash.CountingDigestOutputStream;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.ncache.CacheEntry;
import com.google.cloud.tools.jib.ncache.CacheWrite;
import com.google.cloud.tools.jib.ncache.DefaultCacheEntry;
import com.google.cloud.tools.jib.ncache.DefaultCacheStorageFiles;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;

class DefaultCacheStorageWriter {
    private final DefaultCacheStorageFiles defaultCacheStorageFiles;

    private static void moveIfDoesNotExist(Path source, Path destination) throws IOException {
        try {
            Files.move(source, destination, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (AtomicMoveNotSupportedException ignored) {
            try {
                Files.move(source, destination, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    DefaultCacheStorageWriter(DefaultCacheStorageFiles defaultCacheStorageFiles) {
        this.defaultCacheStorageFiles = defaultCacheStorageFiles;
    }

    CacheEntry write(CacheWrite cacheWrite) throws IOException {
        Files.createDirectories(this.defaultCacheStorageFiles.getLayersDirectory(), new FileAttribute[0]);
        try (TemporaryDirectory temporaryDirectory = new TemporaryDirectory();){
            Path temporaryLayerDirectory = temporaryDirectory.getDirectory();
            WrittenLayer writtenLayer = this.writeLayerBlobToDirectory(cacheWrite.getLayerBlob(), temporaryLayerDirectory);
            if (cacheWrite.getMetadataBlob().isPresent()) {
                this.writeMetadataBlobToDirectory(cacheWrite.getMetadataBlob().get(), temporaryLayerDirectory);
            }
            DefaultCacheStorageWriter.moveIfDoesNotExist(temporaryLayerDirectory, this.defaultCacheStorageFiles.getLayerDirectory(writtenLayer.layerDigest));
            Path layerFile = this.defaultCacheStorageFiles.getLayerFile(writtenLayer.layerDigest, writtenLayer.layerDiffId);
            DefaultCacheEntry.Builder cacheEntryBuilder = DefaultCacheEntry.builder().setLayerDigest(writtenLayer.layerDigest).setLayerDiffId(writtenLayer.layerDiffId).setLayerSize(writtenLayer.layerSize).setLayerBlob(Blobs.from(layerFile));
            if (cacheWrite.getMetadataBlob().isPresent()) {
                Path metadataFile = this.defaultCacheStorageFiles.getMetadataFile(writtenLayer.layerDigest);
                cacheEntryBuilder.setMetadataBlob(Blobs.from(metadataFile)).build();
            }
            if (cacheWrite.getSelector().isPresent()) {
                this.writeSelector(cacheWrite.getSelector().get(), writtenLayer.layerDigest);
            }
            CacheEntry cacheEntry = cacheEntryBuilder.build();
            return cacheEntry;
        }
    }

    private WrittenLayer writeLayerBlobToDirectory(Blob layerBlob, Path layerDirectory) throws IOException {
        Path temporaryLayerFile = Files.createTempFile(layerDirectory, null, null, new FileAttribute[0]);
        temporaryLayerFile.toFile().deleteOnExit();
        try (CountingDigestOutputStream compressedDigestOutputStream = new CountingDigestOutputStream(new BufferedOutputStream(Files.newOutputStream(temporaryLayerFile, new OpenOption[0])));){
            GZIPOutputStream compressorStream = new GZIPOutputStream(compressedDigestOutputStream);
            DescriptorDigest layerDiffId = layerBlob.writeTo(compressorStream).getDigest();
            compressorStream.close();
            BlobDescriptor compressedBlobDescriptor = compressedDigestOutputStream.toBlobDescriptor();
            DescriptorDigest layerDigest = compressedBlobDescriptor.getDigest();
            long layerSize = compressedBlobDescriptor.getSize();
            Path layerFile = layerDirectory.resolve(this.defaultCacheStorageFiles.getLayerFilename(layerDiffId));
            DefaultCacheStorageWriter.moveIfDoesNotExist(temporaryLayerFile, layerFile);
            WrittenLayer writtenLayer = new WrittenLayer(layerDigest, layerDiffId, layerSize);
            return writtenLayer;
        }
    }

    private void writeMetadataBlobToDirectory(Blob metadataBlob, Path layerDirectory) throws IOException {
        Path metadataFile = layerDirectory.resolve(this.defaultCacheStorageFiles.getMetadataFilename());
        Blobs.writeToFileWithLock(metadataBlob, metadataFile);
    }

    private void writeSelector(DescriptorDigest selector, DescriptorDigest layerDigest) throws IOException {
        Path selectorFile = this.defaultCacheStorageFiles.getSelectorFile(selector);
        Files.createDirectories(selectorFile.getParent(), new FileAttribute[0]);
        Path temporarySelectorFile = Files.createTempFile(null, null, new FileAttribute[0]);
        temporarySelectorFile.toFile().deleteOnExit();
        Blobs.writeToFileWithLock(Blobs.from(layerDigest.getHash()), temporarySelectorFile);
        try {
            Files.move(temporarySelectorFile, selectorFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException ignored) {
            Files.move(temporarySelectorFile, selectorFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static class WrittenLayer {
        private final DescriptorDigest layerDigest;
        private final DescriptorDigest layerDiffId;
        private final long layerSize;

        private WrittenLayer(DescriptorDigest layerDigest, DescriptorDigest layerDiffId, long layerSize) {
            this.layerDigest = layerDigest;
            this.layerDiffId = layerDiffId;
            this.layerSize = layerSize;
        }
    }
}

