/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.maven.MavenJibLogger;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

class MavenSettingsServerCredentials {
    static final String CREDENTIAL_SOURCE = "Maven settings";
    private static final Pattern ENCRYPTED_STRING_PATTERN = Pattern.compile(".*?[^\\\\]?\\{(.*?[^\\\\])\\}.*");
    private final Settings settings;
    @Nullable
    private final SettingsDecrypter settingsDecrypter;
    private final MavenJibLogger mavenJibLogger;

    @VisibleForTesting
    static boolean isEncrypted(String password) {
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(password);
        return matcher.matches() || matcher.find();
    }

    MavenSettingsServerCredentials(Settings settings, @Nullable SettingsDecrypter settingsDecrypter, MavenJibLogger mavenJibLogger) {
        this.settings = settings;
        this.settingsDecrypter = settingsDecrypter;
        this.mavenJibLogger = mavenJibLogger;
    }

    Optional<Credential> retrieve(@Nullable String registry) throws MojoExecutionException {
        if (registry == null) {
            return Optional.empty();
        }
        Server registryServer = this.settings.getServer(registry);
        if (registryServer == null) {
            return Optional.empty();
        }
        if (this.settingsDecrypter != null) {
            DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(registryServer);
            SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
            for (SettingsProblem problem : result.getProblems()) {
                if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
                throw new MojoExecutionException("Unable to decrypt password for " + registry + ": " + problem);
            }
            if (result.getServer() != null) {
                registryServer = result.getServer();
            }
        } else if (MavenSettingsServerCredentials.isEncrypted(registryServer.getPassword())) {
            this.mavenJibLogger.warn("Server password for registry " + registry + " appears to be encrypted, but there is no decrypter available");
        }
        return Optional.of(Credential.basic(registryServer.getUsername(), registryServer.getPassword()));
    }
}

