/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.frontend.MainClassFinder;
import com.google.cloud.tools.jib.frontend.MainClassInferenceException;
import com.google.cloud.tools.jib.frontend.ProjectProperties;
import com.google.cloud.tools.jib.maven.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenBuildLogger;
import com.google.cloud.tools.jib.maven.MavenSourceFilesConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class MavenProjectProperties
implements ProjectProperties {
    private static final String PLUGIN_NAME = "jib-maven-plugin";
    private static final String JAR_PLUGIN_NAME = "'maven-jar-plugin'";
    private final MavenProject project;
    private final MavenBuildLogger mavenBuildLogger;
    private final SourceFilesConfiguration sourceFilesConfiguration;

    static MavenProjectProperties getForProject(MavenProject project, MavenBuildLogger mavenBuildLogger) throws MojoExecutionException {
        try {
            return new MavenProjectProperties(project, mavenBuildLogger, MavenSourceFilesConfiguration.getForProject(project));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Obtaining project build output files failed; make sure you have compiled your project before trying to build the image. (Did you accidentally run \"mvn clean jib:build\" instead of \"mvn clean compile jib:build\"?)", (Exception)ex);
        }
    }

    static void disableHttpLogging() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "error");
    }

    @VisibleForTesting
    MavenProjectProperties(MavenProject project, MavenBuildLogger mavenBuildLogger, SourceFilesConfiguration sourceFilesConfiguration) {
        this.project = project;
        this.mavenBuildLogger = mavenBuildLogger;
        this.sourceFilesConfiguration = sourceFilesConfiguration;
    }

    @Override
    public SourceFilesConfiguration getSourceFilesConfiguration() {
        return this.sourceFilesConfiguration;
    }

    @Override
    public HelpfulSuggestions getMainClassHelpfulSuggestions(String prefix) {
        return HelpfulSuggestionsProvider.get(prefix);
    }

    @Override
    public BuildLogger getLogger() {
        return this.mavenBuildLogger;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public String getMainClassFromJar() {
        Plugin mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
        if (mavenJarPlugin != null) {
            Xpp3Dom jarConfiguration = (Xpp3Dom)mavenJarPlugin.getConfiguration();
            if (jarConfiguration == null) {
                return null;
            }
            Xpp3Dom archiveObject = jarConfiguration.getChild("archive");
            if (archiveObject == null) {
                return null;
            }
            Xpp3Dom manifestObject = archiveObject.getChild("manifest");
            if (manifestObject == null) {
                return null;
            }
            Xpp3Dom mainClassObject = manifestObject.getChild("mainClass");
            if (mainClassObject == null) {
                return null;
            }
            return mainClassObject.getValue();
        }
        return null;
    }

    @Override
    public Path getCacheDirectory() {
        return Paths.get(this.project.getBuild().getDirectory(), "jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    String getMainClass(JibPluginConfiguration jibPluginConfiguration) throws MojoExecutionException {
        try {
            return MainClassFinder.resolveMainClass(jibPluginConfiguration.getMainClass(), this);
        }
        catch (MainClassInferenceException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

