/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class JibPluginConfiguration
extends AbstractMojo {
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Nullable
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Parameter
    private FromConfiguration from = new FromConfiguration();
    @Parameter(property="image")
    private ToConfiguration to = new ToConfiguration();
    @Parameter
    private List<String> jvmFlags = Collections.emptyList();
    @Nullable
    @Parameter
    private Map<String, String> environment;
    @Nullable
    @Parameter
    private String mainClass;
    @Parameter
    private List<String> args = Collections.emptyList();
    @Nullable
    @Parameter(defaultValue="Docker", required=true)
    private String format;
    @Parameter(defaultValue="false", required=true)
    private boolean useOnlyProjectCache;

    JibPluginConfiguration() {
    }

    static ImageReference parseBaseImageReference(String from) {
        try {
            return ImageReference.parse(from);
        }
        catch (InvalidImageReferenceException ex) {
            throw new IllegalStateException("Parameter 'from' is invalid", ex);
        }
    }

    static ImageReference parseTargetImageReference(String to) {
        try {
            return ImageReference.parse(to);
        }
        catch (InvalidImageReferenceException ex) {
            throw new IllegalStateException("Parameter 'to' is invalid", ex);
        }
    }

    MavenProject getProject() {
        return (MavenProject)Preconditions.checkNotNull((Object)this.project);
    }

    String getBaseImage() {
        return (String)Preconditions.checkNotNull((Object)((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).image);
    }

    @Nullable
    String getBaseImageCredentialHelperName() {
        return ((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).credHelper;
    }

    @Nullable
    String getTargetImage() {
        return this.to.image;
    }

    @Nullable
    String getTargetImageCredentialHelperName() {
        return ((ToConfiguration)Preconditions.checkNotNull((Object)this.to)).credHelper;
    }

    List<String> getJvmFlags() {
        return this.jvmFlags;
    }

    @Nullable
    Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    String getMainClass() {
        return this.mainClass;
    }

    List<String> getArgs() {
        return this.args;
    }

    String getFormat() {
        return (String)Preconditions.checkNotNull((Object)this.format);
    }

    boolean getUseOnlyProjectCache() {
        return this.useOnlyProjectCache;
    }

    public static class ToConfiguration {
        @Nullable
        @Parameter
        private String image;
        @Nullable
        @Parameter
        private String credHelper;

        public void set(String image) {
            this.image = image;
        }
    }

    public static class FromConfiguration {
        @Nullable
        @Parameter(required=true)
        private String image = "gcr.io/distroless/java";
        @Nullable
        @Parameter
        private String credHelper;
    }
}

