/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryAuthenticators;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class AuthenticatePullStep
implements AsyncStep<Authorization>,
Callable<Authorization> {
    private static final String DESCRIPTION = "Authenticating pull from %s";
    private final BuildConfiguration buildConfiguration;
    private final RetrieveRegistryCredentialsStep retrieveBaseRegistryCredentialsStep;
    private final ListenableFuture<Authorization> listenableFuture;

    AuthenticatePullStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, RetrieveRegistryCredentialsStep retrieveBaseRegistryCredentialsStep) {
        this.buildConfiguration = buildConfiguration;
        this.retrieveBaseRegistryCredentialsStep = retrieveBaseRegistryCredentialsStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{retrieveBaseRegistryCredentialsStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<Authorization> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public Authorization call() throws RegistryAuthenticationFailedException, IOException, RegistryException, ExecutionException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), String.format(DESCRIPTION, this.buildConfiguration.getBaseImageRegistry()));){
            Authorization registryCredentials = NonBlockingSteps.get(this.retrieveBaseRegistryCredentialsStep);
            RegistryAuthenticator registryAuthenticator = RegistryAuthenticators.forOther(this.buildConfiguration.getBaseImageRegistry(), this.buildConfiguration.getBaseImageRepository());
            if (registryAuthenticator == null) {
                Authorization authorization = registryCredentials;
                return authorization;
            }
            Authorization authorization = registryAuthenticator.setAuthorization(registryCredentials).authenticatePull();
            return authorization;
        }
    }
}

