/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.tar;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarStreamBuilder {
    private final LinkedHashMap<TarArchiveEntry, Blob> archiveMap = new LinkedHashMap();

    public void writeAsTarArchiveTo(OutputStream out) throws IOException {
        try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(out, StandardCharsets.UTF_8.name());){
            tarArchiveOutputStream.setLongFileMode(3);
            tarArchiveOutputStream.setBigNumberMode(2);
            for (Map.Entry<TarArchiveEntry, Blob> entry : this.archiveMap.entrySet()) {
                tarArchiveOutputStream.putArchiveEntry(entry.getKey());
                entry.getValue().writeTo((OutputStream)tarArchiveOutputStream);
                tarArchiveOutputStream.closeArchiveEntry();
            }
        }
    }

    public void addTarArchiveEntry(TarArchiveEntry entry) {
        this.archiveMap.put(entry, entry.isFile() ? Blobs.from(entry.getPath()) : Blobs.from(ignored -> {}, true));
    }

    public void addByteEntry(byte[] contents, String name, Instant modificationTime) {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        entry.setSize((long)contents.length);
        entry.setModTime(modificationTime.toEpochMilli());
        this.archiveMap.put(entry, Blobs.from(outputStream -> outputStream.write(contents), true));
    }

    public void addBlobEntry(Blob blob, long size, String name, Instant modificationTime) {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        entry.setSize(size);
        entry.setModTime(modificationTime.toEpochMilli());
        this.archiveMap.put(entry, blob);
    }
}

