/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TempDirectoryProvider
implements Closeable {
    private final Set<Path> directories = Collections.synchronizedSet(new HashSet());

    public Path newDirectory() throws IOException {
        Path path = Files.createTempDirectory(null, new FileAttribute[0]);
        this.directories.add(path);
        return path;
    }

    public Path newDirectory(Path parentDirectory) throws IOException {
        Path path = Files.createTempDirectory(parentDirectory, null, new FileAttribute[0]);
        this.directories.add(path);
        return path;
    }

    @Override
    public void close() {
        for (Path path : this.directories) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                MoreFiles.deleteRecursively((Path)path, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
            catch (IOException iOException) {}
        }
        this.directories.clear();
    }
}

