/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.event.progress.ThrottledAccumulatingConsumer;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import javax.annotation.Nullable;

class ThrottledProgressEventDispatcherWrapper
implements Closeable {
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final String description;
    @Nullable
    private ProgressEventDispatcher progressEventDispatcher;
    @Nullable
    private ThrottledAccumulatingConsumer throttledDispatcher;

    ThrottledProgressEventDispatcherWrapper(ProgressEventDispatcher.Factory progressEventDispatcherFactory, String description) {
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.description = description;
    }

    public void dispatchProgress(Long progressUnits) {
        Preconditions.checkNotNull((Object)this.throttledDispatcher);
        this.throttledDispatcher.accept(progressUnits);
    }

    @Override
    public void close() {
        Preconditions.checkNotNull((Object)this.progressEventDispatcher);
        Preconditions.checkNotNull((Object)this.throttledDispatcher);
        this.throttledDispatcher.close();
        this.progressEventDispatcher.close();
    }

    void setProgressTarget(long allocationUnits) {
        Preconditions.checkState((this.progressEventDispatcher == null ? 1 : 0) != 0);
        this.progressEventDispatcher = this.progressEventDispatcherFactory.create(this.description, allocationUnits);
        this.throttledDispatcher = new ThrottledAccumulatingConsumer(this.progressEventDispatcher::dispatchProgress);
    }
}

