/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.RegistryCredentialRetriever;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import java.io.IOException;
import java.util.concurrent.Callable;

class AuthenticatePushStep
implements Callable<RegistryClient> {
    private static final String DESCRIPTION = "Authenticating push to %s";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;

    AuthenticatePushStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
    }

    @Override
    public RegistryClient call() throws CredentialRetrievalException, IOException, RegistryException {
        String registry = this.buildContext.getTargetImageConfiguration().getImageRegistry();
        try (ProgressEventDispatcher progressDispatcher = this.progressEventDispatcherFactory.create("authenticating push to " + registry, 2L);){
            TimerEventDispatcher ignored2 = new TimerEventDispatcher(this.buildContext.getEventHandlers(), String.format(DESCRIPTION, registry));
            try {
                Credential credential = RegistryCredentialRetriever.getTargetImageCredential(this.buildContext).orElse(null);
                progressDispatcher.dispatchProgress(1L);
                RegistryClient registryClient = this.buildContext.newTargetImageRegistryClientFactory().setCredential(credential).newRegistryClient();
                if (!registryClient.doPushBearerAuth() && credential != null && !credential.isOAuth2RefreshToken()) {
                    registryClient.configureBasicAuth();
                }
                RegistryClient registryClient2 = registryClient;
                ignored2.close();
                return registryClient2;
            }
            catch (Throwable throwable) {
                try {
                    ignored2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

