/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.api.client.http.HttpTransport;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.UpdateChecker;
import com.google.cloud.tools.jib.plugins.common.globalconfig.GlobalConfig;
import com.google.common.util.concurrent.Futures;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.slf4j.OutputEventListenerBackedLoggerContext;
import org.slf4j.LoggerFactory;

class TaskCommon {
    public static final String VERSION_URL = "https://storage.googleapis.com/jib-versions/jib-gradle";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Future<Optional<String>> newUpdateChecker(ProjectProperties projectProperties, GlobalConfig globalConfig, org.gradle.api.logging.Logger logger) {
        if (projectProperties.isOffline() || !logger.isLifecycleEnabled() || globalConfig.isDisableUpdateCheck()) {
            return Futures.immediateFuture(Optional.empty());
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<Optional<String>> future = UpdateChecker.checkForUpdate(executorService, VERSION_URL, projectProperties.getToolName(), projectProperties.getToolVersion(), projectProperties::log);
            return future;
        }
        finally {
            executorService.shutdown();
        }
    }

    static void finishUpdateChecker(ProjectProperties projectProperties, Future<Optional<String>> updateCheckFuture) {
        UpdateChecker.finishUpdateCheck(updateCheckFuture).ifPresent(latestVersion -> {
            String changelogUrl = "https://github.com/GoogleContainerTools/jib/blob/master/jib-gradle-plugin/CHANGELOG.md";
            String privacyUrl = "https://github.com/GoogleContainerTools/jib/blob/master/docs/privacy.md";
            String message = String.format("\n\u001b[33mA new version of %s (%s) is available (currently using %s). Update your build configuration to use the latest features and fixes!\n%s\u001b[0m\n\nPlease see %s for info on disabling this update check.\n", projectProperties.getToolName(), latestVersion, projectProperties.getToolVersion(), changelogUrl, privacyUrl);
            projectProperties.log(LogEvent.lifecycle(message));
        });
    }

    @Nullable
    static TaskProvider<Task> getWarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin(WarPlugin.class)) {
            return project.getTasks().named("war");
        }
        return null;
    }

    @Nullable
    static TaskProvider<Task> getBootWarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin("org.springframework.boot")) {
            try {
                return project.getTasks().named("bootWar");
            }
            catch (UnknownTaskException unknownTaskException) {
                // empty catch block
            }
        }
        return null;
    }

    static void disableHttpLogging() {
        OutputEventListenerBackedLoggerContext context = (OutputEventListenerBackedLoggerContext)LoggerFactory.getILoggerFactory();
        OutputEventListener defaultOutputEventListener = context.getOutputEventListener();
        context.setOutputEventListener(event -> {
            org.gradle.internal.logging.events.LogEvent logEvent = (org.gradle.internal.logging.events.LogEvent)event;
            if (!logEvent.getCategory().contains("org.apache")) {
                defaultOutputEventListener.onOutput(event);
            }
        });
        if (System.getProperty("java.util.logging.config.file") == null) {
            Logger.getLogger(HttpTransport.class.getName()).setLevel(Level.OFF);
        }
    }

    static Map<String, FilePermissions> convertPermissionsMap(Map<String, String> stringMap) {
        LinkedHashMap<String, FilePermissions> permissionsMap = new LinkedHashMap<String, FilePermissions>();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            permissionsMap.put(entry.getKey(), FilePermissions.fromOctalString((String)entry.getValue()));
        }
        return permissionsMap;
    }

    private TaskCommon() {
    }
}

