/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.AuthParameters;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class BaseImageParameters {
    private final AuthParameters auth;
    @Nullable
    private String image;
    @Nullable
    private String credHelper;

    @Inject
    public BaseImageParameters(ObjectFactory objectFactory) {
        this.auth = (AuthParameters)objectFactory.newInstance(AuthParameters.class, new Object[]{"from.auth"});
    }

    @Input
    @Nullable
    @Optional
    public String getImage() {
        if (System.getProperty("jib.from.image") != null) {
            return System.getProperty("jib.from.image");
        }
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Input
    @Nullable
    @Optional
    public String getCredHelper() {
        if (System.getProperty("jib.from.credHelper") != null) {
            return System.getProperty("jib.from.credHelper");
        }
        return this.credHelper;
    }

    public void setCredHelper(String credHelper) {
        this.credHelper = credHelper;
    }

    @Nested
    @Optional
    public AuthParameters getAuth() {
        return this.auth;
    }

    public void auth(Action<? super AuthParameters> action) {
        action.execute((Object)this.auth);
    }
}

