/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.stage;

import com.google.cloud.tools.appengine.AppEngineException;
import com.google.cloud.tools.appengine.configuration.AppYamlProjectStageConfiguration;
import com.google.cloud.tools.maven.stage.AbstractStageMojo;
import com.google.cloud.tools.maven.stage.Stager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;

public class AppYamlStager
implements Stager {
    private final AbstractStageMojo stageMojo;
    private final ConfigBuilder configBuilder;

    public static AppYamlStager newAppYamlStager(AbstractStageMojo stageMojo) {
        return new AppYamlStager(stageMojo, new ConfigBuilder(stageMojo));
    }

    AppYamlStager(AbstractStageMojo stageMojo, ConfigBuilder configBuilder) {
        this.stageMojo = stageMojo;
        this.configBuilder = configBuilder;
    }

    @Override
    public void stage() throws MojoExecutionException {
        AppYamlProjectStageConfiguration config = this.configBuilder.buildConfiguration();
        Path stagingDirectory = config.getStagingDirectory();
        this.stageMojo.getLog().info((CharSequence)("Staging the application to: " + stagingDirectory));
        this.stageMojo.getLog().info((CharSequence)"Detected App Engine app.yaml based application.");
        if (!Files.exists(stagingDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(stagingDirectory, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Unable to create staging directory.", (Exception)ex);
            }
        }
        try {
            this.stageMojo.getAppEngineFactory().appYamlStaging().stageArchive(config);
        }
        catch (AppEngineException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class ConfigBuilder {
        private final AbstractStageMojo stageMojo;

        ConfigBuilder(AbstractStageMojo stageMojo) {
            this.stageMojo = stageMojo;
        }

        AppYamlProjectStageConfiguration buildConfiguration() {
            return AppYamlProjectStageConfiguration.builder((Path)this.processAppYamlBasedAppEngineDirectory(), (Path)this.stageMojo.getArtifact(), (Path)this.stageMojo.getStagingDirectory()).extraFilesDirectories(this.stageMojo.getExtraFilesDirectories()).dockerDirectory(this.stageMojo.getDockerDirectory()).build();
        }

        private Path processAppYamlBasedAppEngineDirectory() {
            if (this.stageMojo.getAppEngineDirectory() == null) {
                return this.stageMojo.getMavenProject().getBasedir().toPath().resolve("src").resolve("main").resolve("appengine");
            }
            return this.stageMojo.getAppEngineDirectory();
        }
    }
}

