/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.kms;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.google.cloud.kms.v1.KeyManagementServiceSettings;
import com.google.cloud.spring.autoconfigure.kms.GcpKmsProperties;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.kms.KmsTemplate;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={GcpKmsProperties.class})
@ConditionalOnClass(value={KeyManagementServiceClient.class, KmsTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.kms.enabled"}, matchIfMissing=true)
public class GcpKmsAutoConfiguration {
    private final GcpProjectIdProvider gcpProjectIdProvider;
    private final CredentialsProvider credentialsProvider;

    public GcpKmsAutoConfiguration(GcpProjectIdProvider coreProjectIdProvider, GcpKmsProperties properties, CredentialsProvider credentialsProvider) throws IOException {
        this.gcpProjectIdProvider = properties.getProjectId() != null ? properties::getProjectId : coreProjectIdProvider;
        this.credentialsProvider = properties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)properties) : credentialsProvider;
    }

    GcpProjectIdProvider getGcpProjectIdProvider() {
        return this.gcpProjectIdProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public KeyManagementServiceClient keyManagementClient(CredentialsProvider googleCredentials) throws IOException {
        KeyManagementServiceSettings settings = ((KeyManagementServiceSettings.Builder)((KeyManagementServiceSettings.Builder)KeyManagementServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpKmsAutoConfiguration.class))).build();
        return KeyManagementServiceClient.create((KeyManagementServiceSettings)settings);
    }

    @Bean
    @ConditionalOnMissingBean
    public KmsTemplate kmsTemplate(KeyManagementServiceClient client) {
        return new KmsTemplate(client, this.gcpProjectIdProvider);
    }
}

