/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.sleuth;

import brave.SpanCustomizer;
import brave.http.HttpRequest;
import brave.http.HttpRequestParser;
import brave.http.HttpTags;
import brave.propagation.TraceContext;
import java.net.URI;

public class StackdriverHttpRequestParser
implements HttpRequestParser {
    public void parse(HttpRequest request, TraceContext context, SpanCustomizer customizer) {
        HttpRequestParser.DEFAULT.parse(request, context, customizer);
        HttpTags.URL.tag((Object)request, context, customizer);
        HttpTags.ROUTE.tag((Object)request, context, customizer);
        String url = request.url();
        URI uri = URI.create(url);
        if (uri.getHost() != null) {
            customizer.tag("http.host", uri.getHost());
        }
    }
}

