/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.beam.sdk.io.hadoop;

import com.google.cloud.spark.bigquery.repackaged.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;

public class SerializableConfiguration
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private transient Configuration conf;

    public SerializableConfiguration() {
    }

    public SerializableConfiguration(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("Configuration must not be null.");
        }
        this.conf = conf;
    }

    public Configuration get() {
        return this.conf;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.conf.getClass().getCanonicalName());
        this.conf.write((DataOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String className = in.readUTF();
        try {
            this.conf = Class.forName(className).asSubclass(Configuration.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.conf.readFields((DataInput)in);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Unable to create configuration: " + e);
        }
    }

    public static Job newJob(@Nullable SerializableConfiguration conf) throws IOException {
        if (conf == null) {
            return Job.getInstance();
        }
        Job job = Job.getInstance((Configuration)new Configuration(false));
        for (Map.Entry entry : conf.get()) {
            job.getConfiguration().set((String)entry.getKey(), (String)entry.getValue());
        }
        return job;
    }

    public static SerializableConfiguration fromMap(Map<String, String> entries) {
        Configuration hadoopConfiguration = new Configuration();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            hadoopConfiguration.set(entry.getKey(), entry.getValue());
        }
        return new SerializableConfiguration(hadoopConfiguration);
    }

    public static Configuration newConfiguration(@Nullable SerializableConfiguration conf) {
        if (conf == null) {
            return new Configuration();
        }
        return conf.get();
    }
}

