/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write.context;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.ComparisonResult;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.spark.bigquery.PartitionOverwriteMode;
import com.google.cloud.spark.bigquery.ProtobufUtils;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.metrics.SparkBigQueryConnectorMetricsUtils;
import com.google.cloud.spark.bigquery.write.context.BigQueryDirectDataWriterContextFactory;
import com.google.cloud.spark.bigquery.write.context.BigQueryDirectWriterCommitMessageContext;
import com.google.cloud.spark.bigquery.write.context.DataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.DataWriterContextFactory;
import com.google.cloud.spark.bigquery.write.context.WriterCommitMessageContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Optional;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryDirectDataSourceWriterContext
implements DataSourceWriterContext {
    final Logger logger = LoggerFactory.getLogger(BigQueryDirectDataSourceWriterContext.class);
    private final BigQueryClient bigQueryClient;
    private final BigQueryClientFactory writeClientFactory;
    private final TableId destinationTableId;
    private final StructType sparkSchema;
    private final ProtoSchema protoSchema;
    private final String writeUUID;
    private final RetrySettings bigqueryDataWriterHelperRetrySettings;
    private final com.google.common.base.Optional<String> traceId;
    private final boolean enableModeCheckForSchemaFields;
    private final ImmutableMap<String, String> tableLabels;
    private final BigQueryTable tableToWrite;
    private final String tablePathForBigQueryStorage;
    private final SchemaConvertersConfiguration schemaConvertersConfiguration;
    private final com.google.common.base.Optional<String> destinationTableKmsKeyName;
    private final boolean writeAtLeastOnce;
    private BigQueryWriteClient writeClient;
    private com.google.common.base.Optional<TableInfo> tableInfo = com.google.common.base.Optional.absent();
    private PartitionOverwriteMode overwriteMode;
    private WritingMode writingMode = WritingMode.ALL_ELSE;
    private final SparkContext sparkContext;

    public BigQueryDirectDataSourceWriterContext(BigQueryClient bigQueryClient, BigQueryClientFactory bigQueryWriteClientFactory, TableId destinationTableId, String writeUUID, SaveMode saveMode, StructType sparkSchema, RetrySettings bigqueryDataWriterHelperRetrySettings, com.google.common.base.Optional<String> traceId, boolean enableModeCheckForSchemaFields, ImmutableMap<String, String> tableLabels, SchemaConvertersConfiguration schemaConvertersConfiguration, Optional<String> destinationTableKmsKeyName, boolean writeAtLeastOnce, PartitionOverwriteMode overwriteMode, Optional<ImmutableList<String>> clusteredFields, SparkContext sparkContext) throws IllegalArgumentException {
        this.bigQueryClient = bigQueryClient;
        this.writeClientFactory = bigQueryWriteClientFactory;
        this.destinationTableId = destinationTableId;
        this.writeUUID = writeUUID;
        this.sparkSchema = sparkSchema;
        this.bigqueryDataWriterHelperRetrySettings = bigqueryDataWriterHelperRetrySettings;
        this.traceId = traceId;
        this.enableModeCheckForSchemaFields = enableModeCheckForSchemaFields;
        this.tableLabels = tableLabels;
        this.schemaConvertersConfiguration = schemaConvertersConfiguration;
        this.destinationTableKmsKeyName = com.google.common.base.Optional.fromJavaUtil(destinationTableKmsKeyName);
        this.writeAtLeastOnce = writeAtLeastOnce;
        this.sparkContext = sparkContext;
        Schema bigQuerySchema = SchemaConverters.from(this.schemaConvertersConfiguration).toBigQuerySchema(sparkSchema);
        try {
            this.protoSchema = ProtobufUtils.toProtoSchema(sparkSchema);
        }
        catch (IllegalArgumentException e) {
            throw new BigQueryConnectorException.InvalidSchemaException("Could not convert Spark schema to protobuf descriptor", (Throwable)e);
        }
        this.tableToWrite = this.getOrCreateTable(saveMode, destinationTableId, bigQuerySchema, clusteredFields);
        this.tablePathForBigQueryStorage = bigQueryClient.createTablePathForBigQueryStorage(this.tableToWrite.getTableId());
        if (!this.writingMode.equals((Object)WritingMode.IGNORE_INPUTS)) {
            this.writeClient = this.writeClientFactory.getBigQueryWriteClient();
        }
        this.overwriteMode = overwriteMode;
    }

    private BigQueryTable getOrCreateTable(SaveMode saveMode, TableId destinationTableId, Schema bigQuerySchema, Optional<ImmutableList<String>> clusteredFields) throws IllegalArgumentException {
        if (this.bigQueryClient.tableExists(destinationTableId)) {
            TableInfo destinationTable = this.bigQueryClient.getTable(destinationTableId);
            Schema tableSchema = destinationTable.getDefinition().getSchema();
            ComparisonResult schemaWritableResult = BigQueryUtil.schemaWritable((Schema)bigQuerySchema, (Schema)tableSchema, (boolean)false, (boolean)this.enableModeCheckForSchemaFields);
            Preconditions.checkArgument((boolean)schemaWritableResult.valuesAreEqual(), (Object)new BigQueryConnectorException.InvalidSchemaException("Destination table's schema is not compatible with dataframe's schema. " + schemaWritableResult.makeMessage()));
            switch (saveMode) {
                case Append: {
                    if (!this.writeAtLeastOnce) break;
                    this.writingMode = WritingMode.APPEND_AT_LEAST_ONCE;
                    return new BigQueryTable(this.bigQueryClient.createTempTable(destinationTableId, tableSchema).getTableId(), true);
                }
                case Overwrite: {
                    this.writingMode = WritingMode.OVERWRITE;
                    return new BigQueryTable(this.bigQueryClient.createTempTable(destinationTableId, tableSchema).getTableId(), true);
                }
                case Ignore: {
                    this.writingMode = WritingMode.IGNORE_INPUTS;
                    break;
                }
                case ErrorIfExists: {
                    throw new IllegalArgumentException("Table already exists in BigQuery");
                }
            }
            return new BigQueryTable(destinationTable.getTableId(), false);
        }
        return new BigQueryTable(this.bigQueryClient.createTable(destinationTableId, bigQuerySchema, BigQueryClient.CreateTableOptions.of((Optional)this.destinationTableKmsKeyName.toJavaUtil(), this.tableLabels, clusteredFields)).getTableId(), true);
    }

    @Override
    public DataWriterContextFactory<InternalRow> createWriterContextFactory() {
        return new BigQueryDirectDataWriterContextFactory(this.writeClientFactory, this.tablePathForBigQueryStorage, this.sparkSchema, this.protoSchema, this.writingMode.equals((Object)WritingMode.IGNORE_INPUTS), this.bigqueryDataWriterHelperRetrySettings, this.traceId, this.writeAtLeastOnce);
    }

    @Override
    public void onDataWriterCommit(WriterCommitMessageContext message) {
    }

    @Override
    public void commit(WriterCommitMessageContext[] messages) {
        if (this.writingMode.equals((Object)WritingMode.IGNORE_INPUTS)) {
            return;
        }
        this.logger.info("BigQuery DataSource writer {} committed with messages:\n{}", (Object)this.writeUUID, (Object)Arrays.toString(messages));
        long bytesWritten = 0L;
        if (!this.writeAtLeastOnce) {
            BatchCommitWriteStreamsRequest.Builder batchCommitWriteStreamsRequest = BatchCommitWriteStreamsRequest.newBuilder().setParent(this.tablePathForBigQueryStorage);
            for (WriterCommitMessageContext message : messages) {
                bytesWritten += ((BigQueryDirectWriterCommitMessageContext)message).getBytesWritten();
                batchCommitWriteStreamsRequest.addWriteStreams(((BigQueryDirectWriterCommitMessageContext)message).getWriteStreamName());
            }
            BatchCommitWriteStreamsResponse batchCommitWriteStreamsResponse = this.writeClient.batchCommitWriteStreams(batchCommitWriteStreamsRequest.build());
            if (!batchCommitWriteStreamsResponse.hasCommitTime()) {
                throw new BigQueryConnectorException("DataSource writer failed to batch commit its BigQuery write-streams");
            }
            this.logger.info("BigQuery DataSource writer has committed at time: {}", (Object)batchCommitWriteStreamsResponse.getCommitTime());
        }
        if (this.writingMode.equals((Object)WritingMode.APPEND_AT_LEAST_ONCE) || this.writingMode.equals((Object)WritingMode.OVERWRITE)) {
            Job queryJob = this.writingMode.equals((Object)WritingMode.OVERWRITE) ? (this.overwriteMode == PartitionOverwriteMode.STATIC ? this.bigQueryClient.overwriteDestinationWithTemporary(this.tableToWrite.getTableId(), this.destinationTableId) : this.bigQueryClient.overwriteDestinationWithTemporaryDynamicPartitons(this.tableToWrite.getTableId(), this.destinationTableId)) : this.bigQueryClient.appendDestinationWithTemporary(this.tableToWrite.getTableId(), this.destinationTableId);
            this.bigQueryClient.waitForJob(queryJob);
            Preconditions.checkState((boolean)this.bigQueryClient.deleteTable(this.tableToWrite.getTableId()), (Object)new BigQueryConnectorException(String.format("Could not delete temporary table %s from BigQuery", this.tableToWrite)));
        }
        if (!this.tableLabels.isEmpty()) {
            TableInfo originalTableInfo = this.bigQueryClient.getTable(this.destinationTableId);
            TableInfo.Builder updatedTableInfo = originalTableInfo.toBuilder();
            updatedTableInfo.setLabels(this.tableLabels);
            this.bigQueryClient.update(updatedTableInfo.build());
        }
        long currentTimeMillis = System.currentTimeMillis();
        SparkBigQueryConnectorMetricsUtils.postWriteSessionMetrics(currentTimeMillis, SparkBigQueryConfig.WriteMethod.DIRECT, bytesWritten, Optional.empty(), this.sparkContext);
    }

    @Override
    public void abort(WriterCommitMessageContext[] messages) {
        this.logger.warn("BigQuery Data Source writer {} aborted", (Object)this.writeUUID);
        if (this.writingMode.equals((Object)WritingMode.IGNORE_INPUTS)) {
            return;
        }
        if (this.tableToWrite.toDeleteOnAbort()) {
            this.bigQueryClient.deleteTable(this.tableToWrite.getTableId());
        }
    }

    @Override
    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = com.google.common.base.Optional.fromNullable((Object)tableInfo);
    }

    static class BigQueryTable {
        private final TableId tableId;
        private final boolean toDeleteOnAbort;

        public BigQueryTable(TableId tableId, boolean toDeleteOnAbort) {
            this.tableId = tableId;
            this.toDeleteOnAbort = toDeleteOnAbort;
        }

        public TableId getTableId() {
            return this.tableId;
        }

        public boolean toDeleteOnAbort() {
            return this.toDeleteOnAbort;
        }
    }

    static enum WritingMode {
        IGNORE_INPUTS,
        APPEND_AT_LEAST_ONCE,
        OVERWRITE,
        ALL_ELSE;

    }
}

