/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.events;

import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.spark.bigquery.events.LoadJobCompletedEvent;
import com.google.cloud.spark.bigquery.events.QueryJobCompletedEvent;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import org.apache.spark.scheduler.SparkListenerEvent;

public abstract class BigQueryJobCompletedEvent
implements SparkListenerEvent,
Serializable {
    private static final long serialVersionUID = 5831270570484516631L;
    protected final JobInfo jobInfo;

    protected BigQueryJobCompletedEvent(JobInfo jobInfo, JobConfiguration.Type expectedType) {
        Preconditions.checkArgument((boolean)expectedType.equals((Object)jobInfo.getConfiguration().getType()), (Object)("Created event of the wrong type, expected to be " + expectedType + ", got " + jobInfo.getConfiguration().getType()));
        this.jobInfo = jobInfo;
    }

    public static Optional<BigQueryJobCompletedEvent> from(JobInfo completedJob) {
        switch (completedJob.getConfiguration().getType()) {
            case QUERY: {
                return Optional.of(new QueryJobCompletedEvent(completedJob));
            }
            case LOAD: {
                return Optional.of(new LoadJobCompletedEvent(completedJob));
            }
        }
        return Optional.empty();
    }

    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public String getEtag() {
        return this.jobInfo.getEtag();
    }

    public String getGeneratedId() {
        return this.jobInfo.getGeneratedId();
    }

    public JobId getJobId() {
        return this.jobInfo.getJobId();
    }

    public String getSelfLink() {
        return this.jobInfo.getSelfLink();
    }

    public JobStatus getStatus() {
        return this.jobInfo.getStatus();
    }

    public String getUserEmail() {
        return this.jobInfo.getUserEmail();
    }

    public boolean logEvent() {
        return false;
    }
}

