/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.common.collect.ImmutableList;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkFilterUtils {
    private SparkFilterUtils() {
    }

    public static boolean isTopLevelFieldHandled(boolean pushAllFilters, Filter filter, DataFormat readDataFormat, Map<String, StructField> fields) {
        if (pushAllFilters) {
            return true;
        }
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, equalTo.attribute());
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, equalNullSafe.attribute());
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, greaterThan.attribute());
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, greaterThanOrEqual.attribute());
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, lessThan.attribute());
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, lessThanOrEqual.attribute());
        }
        if (filter instanceof In) {
            In in = (In)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, in.attribute());
        }
        if (filter instanceof IsNull) {
            IsNull isNull = (IsNull)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, isNull.attribute());
        }
        if (filter instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, isNotNull.attribute());
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return SparkFilterUtils.isTopLevelFieldHandled(pushAllFilters, and.left(), readDataFormat, fields) && SparkFilterUtils.isTopLevelFieldHandled(pushAllFilters, and.right(), readDataFormat, fields);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return readDataFormat == DataFormat.AVRO && SparkFilterUtils.isTopLevelFieldHandled(pushAllFilters, or.left(), readDataFormat, fields) && SparkFilterUtils.isTopLevelFieldHandled(pushAllFilters, or.right(), readDataFormat, fields);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return SparkFilterUtils.isTopLevelFieldHandled(pushAllFilters, not.child(), readDataFormat, fields);
        }
        if (filter instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, stringStartsWith.attribute());
        }
        if (filter instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, stringEndsWith.attribute());
        }
        if (filter instanceof StringContains) {
            StringContains stringContains = (StringContains)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(pushAllFilters, filter, readDataFormat, fields, stringContains.attribute());
        }
        throw new IllegalArgumentException(String.format("Invalid filter: %s", filter));
    }

    static boolean isFilterWithNamedFieldHandled(boolean pushAllFilters, Filter filter, DataFormat readDataFormat, Map<String, StructField> fields, String fieldName) {
        return Optional.ofNullable(fields.get(fieldName)).filter(field -> field.dataType() instanceof StructType || field.dataType() instanceof ArrayType).map(field -> false).orElse(SparkFilterUtils.isHandled(pushAllFilters, filter, readDataFormat));
    }

    public static boolean isHandled(boolean pushAllFilters, Filter filter, DataFormat readDataFormat) {
        if (pushAllFilters) {
            return true;
        }
        if (filter instanceof EqualTo || filter instanceof GreaterThan || filter instanceof GreaterThanOrEqual || filter instanceof LessThan || filter instanceof LessThanOrEqual || filter instanceof In || filter instanceof IsNull || filter instanceof IsNotNull || filter instanceof StringStartsWith || filter instanceof StringEndsWith || filter instanceof StringContains || filter instanceof EqualNullSafe) {
            return true;
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return SparkFilterUtils.isHandled(pushAllFilters, and.left(), readDataFormat) && SparkFilterUtils.isHandled(pushAllFilters, and.right(), readDataFormat);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return readDataFormat == DataFormat.AVRO && SparkFilterUtils.isHandled(pushAllFilters, or.left(), readDataFormat) && SparkFilterUtils.isHandled(pushAllFilters, or.right(), readDataFormat);
        }
        if (filter instanceof Not) {
            return SparkFilterUtils.isHandled(pushAllFilters, ((Not)filter).child(), readDataFormat);
        }
        return false;
    }

    public static Iterable<Filter> handledFilters(boolean pushAllFilters, DataFormat readDataFormat, Filter ... filters) {
        return SparkFilterUtils.handledFilters(pushAllFilters, readDataFormat, (Iterable<Filter>)ImmutableList.copyOf((Object[])filters));
    }

    public static Iterable<Filter> handledFilters(boolean pushAllFilters, DataFormat readDataFormat, Iterable<Filter> filters) {
        return StreamSupport.stream(filters.spliterator(), false).filter(f -> SparkFilterUtils.isHandled(pushAllFilters, f, readDataFormat)).collect(Collectors.toList());
    }

    public static Iterable<Filter> unhandledFilters(boolean pushAllFilters, DataFormat readDataFormat, Filter ... filters) {
        return SparkFilterUtils.unhandledFilters(pushAllFilters, readDataFormat, (Iterable<Filter>)ImmutableList.copyOf((Object[])filters));
    }

    public static Iterable<Filter> unhandledFilters(boolean pushAllFilters, DataFormat readDataFormat, Iterable<Filter> filters) {
        return StreamSupport.stream(filters.spliterator(), false).filter(f -> !SparkFilterUtils.isHandled(pushAllFilters, f, readDataFormat)).collect(Collectors.toList());
    }

    public static String getCompiledFilter(boolean pushAllFilters, DataFormat readDataFormat, Optional<String> configFilter, Filter ... pushedFilters) {
        String compiledPushedFilter = SparkFilterUtils.compileFilters(SparkFilterUtils.handledFilters(pushAllFilters, readDataFormat, (Iterable<Filter>)ImmutableList.copyOf((Object[])pushedFilters)));
        return Stream.of(configFilter, compiledPushedFilter.isEmpty() ? Optional.empty() : Optional.of(compiledPushedFilter)).filter(Optional::isPresent).map(Optional::get).map(filter -> filter.startsWith("(") && filter.endsWith(")") ? filter : "(" + filter + ")").collect(Collectors.joining(" AND "));
    }

    public static String compileFilter(Filter filter) {
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            return String.format("%s = %s", SparkFilterUtils.quote(equalTo.attribute()), SparkFilterUtils.compileValue(equalTo.value()));
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String left = SparkFilterUtils.quote(equalNullSafe.attribute());
            String right = SparkFilterUtils.compileValue(equalNullSafe.value());
            return String.format("(%1$s IS NULL AND %2$s IS NULL) OR (%1$s IS NOT NULL AND %2$s IS NOT NULL AND %1$s = %2$s)", left, right);
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            return String.format("%s > %s", SparkFilterUtils.quote(greaterThan.attribute()), SparkFilterUtils.compileValue(greaterThan.value()));
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            return String.format("%s >= %s", SparkFilterUtils.quote(greaterThanOrEqual.attribute()), SparkFilterUtils.compileValue(greaterThanOrEqual.value()));
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            return String.format("%s < %s", SparkFilterUtils.quote(lessThan.attribute()), SparkFilterUtils.compileValue(lessThan.value()));
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            return String.format("%s <= %s", SparkFilterUtils.quote(lessThanOrEqual.attribute()), SparkFilterUtils.compileValue(lessThanOrEqual.value()));
        }
        if (filter instanceof In) {
            In in = (In)filter;
            return String.format("%s IN %s", SparkFilterUtils.quote(in.attribute()), SparkFilterUtils.compileValue(in.values(), '(', ')'));
        }
        if (filter instanceof IsNull) {
            IsNull isNull = (IsNull)filter;
            return String.format("%s IS NULL", SparkFilterUtils.quote(isNull.attribute()));
        }
        if (filter instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter;
            return String.format("%s IS NOT NULL", SparkFilterUtils.quote(isNotNull.attribute()));
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return String.format("(%s) AND (%s)", SparkFilterUtils.compileFilter(and.left()), SparkFilterUtils.compileFilter(and.right()));
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return String.format("(%s) OR (%s)", SparkFilterUtils.compileFilter(or.left()), SparkFilterUtils.compileFilter(or.right()));
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return String.format("NOT (%s)", SparkFilterUtils.compileFilter(not.child()));
        }
        if (filter instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter;
            return String.format("%s LIKE '%s%%'", SparkFilterUtils.quote(stringStartsWith.attribute()), SparkFilterUtils.escape(stringStartsWith.value()));
        }
        if (filter instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter;
            return String.format("%s LIKE '%%%s'", SparkFilterUtils.quote(stringEndsWith.attribute()), SparkFilterUtils.escape(stringEndsWith.value()));
        }
        if (filter instanceof StringContains) {
            StringContains stringContains = (StringContains)filter;
            return String.format("%s LIKE '%%%s%%'", SparkFilterUtils.quote(stringContains.attribute()), SparkFilterUtils.escape(stringContains.value()));
        }
        throw new IllegalArgumentException(String.format("Invalid filter: %s", filter));
    }

    public static String compileFilters(Iterable<Filter> filters) {
        return StreamSupport.stream(filters.spliterator(), false).map(SparkFilterUtils::compileFilter).sorted().map(filter -> "(" + filter + ")").collect(Collectors.joining(" AND "));
    }

    static String compileValue(Object value) {
        return SparkFilterUtils.compileValue(value, '[', ']');
    }

    static String compileValue(Object value, char arrayStart, char arrayEnd) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "'" + SparkFilterUtils.escape((String)value) + "'";
        }
        if (value instanceof Date || value instanceof LocalDate) {
            return "DATE '" + value + "'";
        }
        if (value instanceof Timestamp || value instanceof Instant) {
            Instant instant = value instanceof Timestamp ? ((Timestamp)value).toInstant() : (Instant)value;
            return "TIMESTAMP '" + instant.toString() + "'";
        }
        if (value instanceof LocalDateTime) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
            return "DATETIME '" + ((LocalDateTime)value).format(formatter) + "'";
        }
        if (value instanceof Object[]) {
            return Arrays.stream((Object[])value).map(SparkFilterUtils::compileValue).collect(Collectors.joining(", ", Character.toString(arrayStart), Character.toString(arrayEnd)));
        }
        return value.toString();
    }

    static String escape(String value) {
        return value.replace("'", "\\'");
    }

    static String quote(String value) {
        return value.contains(".") ? Arrays.stream(value.split("\\.")).collect(Collectors.joining("`.`", "`", "`")) : "`" + value + "`";
    }
}

