/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.ParquetOptions;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.BigQueryConfigurationUtil;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.connector.common.BigQueryCredentialsSupplier;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.MaterializationConfiguration;
import com.google.cloud.bigquery.connector.common.QueryParameterHelper;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfigBuilder;
import com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.PartitionOverwriteMode;
import com.google.cloud.spark.bigquery.SparkBigQueryProxyAndHttpConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.threeten.bp.Duration;
import scala.util.Properties;

public class SparkBigQueryConfig
implements BigQueryConfig,
BigQueryClient.CreateTableOptions,
BigQueryClient.LoadDataOptions,
Serializable {
    private static final long serialVersionUID = 728392817473829L;
    public static final int MAX_TRACE_ID_LENGTH = 256;
    public static final TableId QUERY_DUMMY_TABLE_ID = TableId.of((String)"QUERY", (String)"QUERY");
    public static final String IMPERSONATION_GLOBAL = "gcpImpersonationServiceAccount";
    public static final String IMPERSONATION_FOR_USER_PREFIX = "gcpImpersonationServiceAccountForUser.";
    public static final String IMPERSONATION_FOR_GROUP_PREFIX = "gcpImpersonationServiceAccountForGroup.";
    public static final String VIEWS_ENABLED_OPTION = "viewsEnabled";
    public static final String USE_AVRO_LOGICAL_TYPES_OPTION = "useAvroLogicalTypes";
    public static final String DATE_PARTITION_PARAM = "datePartition";
    public static final String VALIDATE_SPARK_AVRO_PARAM = "validateSparkAvroInternalParam";
    public static final String ENABLE_LIST_INFERENCE = "enableListInference";
    public static final String INTERMEDIATE_FORMAT_OPTION = "intermediateFormat";
    public static final String WRITE_METHOD_PARAM = "writeMethod";
    public static final String WRITE_AT_LEAST_ONCE_OPTION = "writeAtLeastOnce";
    @VisibleForTesting
    static final DataFormat DEFAULT_READ_DATA_FORMAT = DataFormat.ARROW;
    @VisibleForTesting
    static final IntermediateFormat DEFAULT_INTERMEDIATE_FORMAT = IntermediateFormat.PARQUET;
    @VisibleForTesting
    static final ArrowSerializationOptions.CompressionCodec DEFAULT_ARROW_COMPRESSION_CODEC = ArrowSerializationOptions.CompressionCodec.COMPRESSION_UNSPECIFIED;
    @VisibleForTesting
    static final ReadSession.TableReadOptions.ResponseCompressionCodec DEFAULT_RESPONSE_COMPRESSION_CODEC = ReadSession.TableReadOptions.ResponseCompressionCodec.RESPONSE_COMPRESSION_CODEC_UNSPECIFIED;
    static final String GCS_CONFIG_CREDENTIALS_FILE_PROPERTY = "google.cloud.auth.service.account.json.keyfile";
    static final String GCS_CONFIG_PROJECT_ID_PROPERTY = "fs.gs.project.id";
    private static final String READ_DATA_FORMAT_OPTION = "readDataFormat";
    private static final ImmutableList<String> PERMITTED_READ_DATA_FORMATS = ImmutableList.of((Object)DataFormat.ARROW.toString(), (Object)DataFormat.AVRO.toString());
    private static final String CONF_PREFIX = "spark.datasource.bigquery.";
    private static final int DEFAULT_BIGQUERY_CLIENT_CONNECT_TIMEOUT = 60000;
    private static final int DEFAULT_BIGQUERY_CLIENT_READ_TIMEOUT = 60000;
    private static final Pattern QUICK_LOWERCASE_QUERY_PATTERN = Pattern.compile("(?i)^\\s*(select|with|\\()\\b[\\s\\S]*");
    private static final Pattern HAS_WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern SQL_KEYWORD_PATTERN = Pattern.compile("(?i)\\b(select|from|where|join|group by|order by|union all)\\b");
    public static final int MIN_BUFFERED_RESPONSES_PER_STREAM = 1;
    public static final int MIN_STREAMS_PER_PARTITION = 1;
    private static final int DEFAULT_BIGQUERY_CLIENT_RETRIES = 10;
    private static final String ARROW_COMPRESSION_CODEC_OPTION = "arrowCompressionCodec";
    private static final String RESPONSE_COMPRESSION_CODEC_OPTION = "responseCompressionCodec";
    private static final WriteMethod DEFAULT_WRITE_METHOD = WriteMethod.INDIRECT;
    public static final int DEFAULT_CACHE_EXPIRATION_IN_MINUTES = 15;
    static final String BIGQUERY_JOB_LABEL_PREFIX = "bigQueryJobLabel.";
    static final String BIGQUERY_TABLE_LABEL_PREFIX = "bigQueryTableLabel.";
    public static final QueryJobConfiguration.Priority DEFAULT_JOB_PRIORITY = QueryJobConfiguration.Priority.INTERACTIVE;
    static final String ALLOW_MAP_TYPE_CONVERSION = "allowMapTypeConversion";
    static final Boolean ALLOW_MAP_TYPE_CONVERSION_DEFAULT = true;
    public static final String partitionOverwriteModeProperty = "spark.sql.sources.partitionOverwriteMode";
    public PartitionOverwriteMode partitionOverwriteModeValue = PartitionOverwriteMode.STATIC;
    public static final String BIGQUERY_JOB_TIMEOUT_IN_MINUTES = "bigQueryJobTimeoutInMinutes";
    static final long BIGQUERY_JOB_TIMEOUT_IN_MINUTES_DEFAULT = 360L;
    public static final String GPN_ATTRIBUTION = "GPN";
    public static final String BIG_NUMERIC_DEFAULT_PRECISION = "bigNumericDefaultPrecision";
    public static final String BIG_NUMERIC_DEFAULT_SCALE = "bigNumericDefaultScale";
    private static final String DATAPROC_SYSTEM_BUCKET_CONFIGURATION = "fs.gs.system.bucket";
    TableId tableId;
    com.google.common.base.Optional<String> query = BigQueryConfigurationUtil.empty();
    String parentProjectId;
    boolean useParentProjectForMetadataOperations;
    com.google.common.base.Optional<String> accessTokenProviderFQCN;
    com.google.common.base.Optional<String> accessTokenProviderConfig;
    String loggedInUserName;
    Set<String> loggedInUserGroups;
    com.google.common.base.Optional<String> impersonationServiceAccount;
    com.google.common.base.Optional<Map<String, String>> impersonationServiceAccountsForUsers;
    com.google.common.base.Optional<Map<String, String>> impersonationServiceAccountsForGroups;
    com.google.common.base.Optional<String> credentialsKey;
    com.google.common.base.Optional<String> credentialsFile;
    com.google.common.base.Optional<String> accessToken;
    com.google.common.base.Optional<ImmutableList<String>> credentialsScopes;
    com.google.common.base.Optional<String> filter = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<StructType> schema = BigQueryConfigurationUtil.empty();
    Integer maxParallelism = null;
    Integer preferredMinParallelism = null;
    int defaultParallelism = 1;
    com.google.common.base.Optional<String> temporaryGcsBucket = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<String> persistentGcsBucket = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<String> persistentGcsPath = BigQueryConfigurationUtil.empty();
    IntermediateFormat intermediateFormat = DEFAULT_INTERMEDIATE_FORMAT;
    DataFormat readDataFormat = DEFAULT_READ_DATA_FORMAT;
    boolean combinePushedDownFilters = true;
    boolean viewsEnabled = false;
    com.google.common.base.Optional<String> materializationProject = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<String> materializationDataset = BigQueryConfigurationUtil.empty();
    int materializationExpirationTimeInMinutes;
    com.google.common.base.Optional<String> partitionField = BigQueryConfigurationUtil.empty();
    Long partitionExpirationMs = null;
    com.google.common.base.Optional<Boolean> partitionRequireFilter = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<TimePartitioning.Type> partitionType = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<Long> partitionRangeStart = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<Long> partitionRangeEnd = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<Long> partitionRangeInterval = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<ImmutableList<String>> clusteredFields = BigQueryConfigurationUtil.empty();
    com.google.common.base.Optional<JobInfo.CreateDisposition> createDisposition = BigQueryConfigurationUtil.empty();
    boolean optimizedEmptyProjection = true;
    boolean useAvroLogicalTypes = false;
    List<String> decimalTargetTypes = Collections.emptyList();
    List<JobInfo.SchemaUpdateOption> loadSchemaUpdateOptions = Collections.emptyList();
    int maxReadRowsRetries = 3;
    boolean pushAllFilters = true;
    boolean enableModeCheckForSchemaFields = true;
    private com.google.common.base.Optional<String> encodedCreateReadSessionRequest = BigQueryConfigurationUtil.empty();
    private com.google.common.base.Optional<String> bigQueryStorageGrpcEndpoint = BigQueryConfigurationUtil.empty();
    private com.google.common.base.Optional<String> bigQueryHttpEndpoint = BigQueryConfigurationUtil.empty();
    private int numBackgroundThreadsPerStream = 0;
    private int numPrebufferReadRowsResponses = 1;
    private int numStreamsPerPartition = 1;
    private int channelPoolSize = 1;
    private com.google.common.base.Optional<Integer> flowControlWindowBytes = com.google.common.base.Optional.absent();
    private boolean enableReadSessionCaching = true;
    private long readSessionCacheDurationMins = 5L;
    private Long snapshotTimeMillis = null;
    private SparkBigQueryProxyAndHttpConfig sparkBigQueryProxyAndHttpConfig;
    private ArrowSerializationOptions.CompressionCodec arrowCompressionCodec = DEFAULT_ARROW_COMPRESSION_CODEC;
    private ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec = DEFAULT_RESPONSE_COMPRESSION_CODEC;
    private WriteMethod writeMethod = DEFAULT_WRITE_METHOD;
    boolean writeAtLeastOnce = false;
    private int cacheExpirationTimeInMinutes = 15;
    private com.google.common.base.Optional<String> traceId;
    private Map<String, String> bigQueryJobLabels = Collections.emptyMap();
    private Map<String, String> bigQueryTableLabels = Collections.emptyMap();
    private com.google.common.base.Optional<Long> createReadSessionTimeoutInSeconds;
    private QueryJobConfiguration.Priority queryJobPriority = DEFAULT_JOB_PRIORITY;
    private com.google.common.base.Optional<String> destinationTableKmsKeyName = BigQueryConfigurationUtil.empty();
    private boolean allowMapTypeConversion = ALLOW_MAP_TYPE_CONVERSION_DEFAULT;
    private long bigQueryJobTimeoutInMinutes = 360L;
    private com.google.common.base.Optional<String> gpn;
    private int bigNumericDefaultPrecision;
    private int bigNumericDefaultScale;
    private QueryParameterHelper queryParameterHelper;

    @VisibleForTesting
    SparkBigQueryConfig() {
    }

    public static SparkBigQueryConfig from(Map<String, String> options, ImmutableMap<String, String> customDefaults, DataSourceVersion dataSourceVersion, SparkSession spark, Optional<StructType> schema, boolean tableIsMandatory) {
        return SparkBigQueryConfig.from(options, customDefaults, dataSourceVersion, spark, schema, tableIsMandatory, Optional.empty());
    }

    public static SparkBigQueryConfig from(Map<String, String> options, ImmutableMap<String, String> customDefaults, DataSourceVersion dataSourceVersion, SparkSession spark, Optional<StructType> schema, boolean tableIsMandatory, Optional<TableId> overrideTableId) {
        HashMap<String, String> optionsMap = new HashMap<String, String>(options);
        dataSourceVersion.updateOptionsMap(optionsMap);
        return SparkBigQueryConfig.from((Map<String, String>)ImmutableMap.copyOf(optionsMap), (ImmutableMap<String, String>)ImmutableMap.copyOf(SparkBigQueryUtil.scalaMapToJavaMap(spark.conf().getAll())), spark.sparkContext().hadoopConfiguration(), customDefaults, spark.sparkContext().defaultParallelism(), spark.sessionState().conf(), spark.version(), schema, tableIsMandatory, overrideTableId);
    }

    @VisibleForTesting
    public static SparkBigQueryConfig from(Map<String, String> optionsInput, ImmutableMap<String, String> originalGlobalOptions, Configuration hadoopConfiguration, ImmutableMap<String, String> customDefaults, int defaultParallelism, SQLConf sqlConf, String sparkVersion, Optional<StructType> schema, boolean tableIsMandatory) {
        return SparkBigQueryConfig.from(optionsInput, originalGlobalOptions, hadoopConfiguration, customDefaults, defaultParallelism, sqlConf, sparkVersion, schema, tableIsMandatory, Optional.empty());
    }

    @VisibleForTesting
    public static SparkBigQueryConfig from(Map<String, String> optionsInput, ImmutableMap<String, String> originalGlobalOptions, Configuration hadoopConfiguration, ImmutableMap<String, String> customDefaults, int defaultParallelism, SQLConf sqlConf, String sparkVersion, Optional<StructType> schema, boolean tableIsMandatory, Optional<TableId> overrideTableId) {
        SparkBigQueryConfig config = new SparkBigQueryConfig();
        ImmutableMap<String, String> options = SparkBigQueryConfig.toLowerCaseKeysMap(optionsInput);
        ImmutableMap<String, String> globalOptions = SparkBigQueryConfig.normalizeConf(originalGlobalOptions);
        config.sparkBigQueryProxyAndHttpConfig = SparkBigQueryProxyAndHttpConfig.from(options, globalOptions, hadoopConfiguration);
        config.viewsEnabled = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)VIEWS_ENABLED_OPTION, (boolean)false);
        MaterializationConfiguration materializationConfiguration = MaterializationConfiguration.from(globalOptions, options);
        config.materializationProject = materializationConfiguration.getMaterializationProject();
        config.materializationDataset = materializationConfiguration.getMaterializationDataset();
        config.materializationExpirationTimeInMinutes = materializationConfiguration.getMaterializationExpirationTimeInMinutes();
        com.google.common.base.Optional<String> fallbackDataset = config.materializationDataset;
        Optional fallbackProject = com.google.common.base.Optional.fromNullable((Object)hadoopConfiguration.get(GCS_CONFIG_PROJECT_ID_PROPERTY)).toJavaUtil();
        Optional datasetParam = BigQueryConfigurationUtil.getOption(options, (String)"dataset").or(fallbackDataset).toJavaUtil();
        Optional projectParam = BigQueryUtil.firstPresent((Optional[])new Optional[]{BigQueryConfigurationUtil.getOption(options, (String)"project").toJavaUtil(), fallbackProject});
        config.partitionType = BigQueryConfigurationUtil.getOption(options, (String)"partitionType").transform(TimePartitioning.Type::valueOf);
        config.partitionRangeStart = BigQueryConfigurationUtil.getOption(options, (String)"partitionRangeStart").transform(Long::parseLong);
        config.partitionRangeEnd = BigQueryConfigurationUtil.getOption(options, (String)"partitionRangeEnd").transform(Long::parseLong);
        config.partitionRangeInterval = BigQueryConfigurationUtil.getOption(options, (String)"partitionRangeInterval").transform(Long::parseLong);
        if (overrideTableId.isPresent()) {
            config.tableId = overrideTableId.get();
        } else {
            Optional tableParam = BigQueryConfigurationUtil.getOptionFromMultipleParams(options, (Collection)ImmutableList.of((Object)"table", (Object)"path"), (Supplier)BigQueryConfigurationUtil.DEFAULT_FALLBACK).toJavaUtil();
            Optional datePartitionParam = BigQueryConfigurationUtil.getOption(options, (String)DATE_PARTITION_PARAM).toJavaUtil();
            datePartitionParam.ifPresent(date -> SparkBigQueryConfig.validateDateFormat(date, config.getPartitionTypeOrDefault(), DATE_PARTITION_PARAM));
            if (tableParam.isPresent()) {
                String tableParamStr = ((String)tableParam.get()).trim();
                if (SparkBigQueryConfig.isQuery(tableParamStr)) {
                    config.query = com.google.common.base.Optional.of((Object)tableParamStr);
                    config.tableId = datasetParam.map(ignored -> BigQueryUtil.parseTableId((String)"QUERY", (Optional)datasetParam, (Optional)projectParam, (Optional)datePartitionParam)).orElse(QUERY_DUMMY_TABLE_ID);
                } else {
                    config.tableId = BigQueryUtil.parseTableId((String)tableParamStr, (Optional)datasetParam, (Optional)projectParam, (Optional)datePartitionParam);
                }
            } else {
                config.query = BigQueryConfigurationUtil.getOption(options, (String)"query").transform(String::trim);
                if (config.query.isPresent()) {
                    config.tableId = datasetParam.map(ignored -> BigQueryUtil.parseTableId((String)"QUERY", (Optional)datasetParam, (Optional)projectParam, (Optional)datePartitionParam)).orElse(QUERY_DUMMY_TABLE_ID);
                } else if (tableIsMandatory) {
                    throw new IllegalArgumentException("No table has been specified");
                }
            }
        }
        config.parentProjectId = (String)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"parentProject").or(BigQueryConfigurationUtil.defaultBilledProject());
        config.useParentProjectForMetadataOperations = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)"useParentProjectForMetadataOperations", (boolean)false);
        config.accessTokenProviderFQCN = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"gcpAccessTokenProvider");
        config.accessTokenProviderConfig = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"gcpAccessTokenProviderConfig");
        try {
            UserGroupInformation ugiCurrentUser = UserGroupInformation.getCurrentUser();
            config.loggedInUserName = ugiCurrentUser.getShortUserName();
            config.loggedInUserGroups = Sets.newHashSet((Object[])ugiCurrentUser.getGroupNames());
        }
        catch (IOException e) {
            throw new BigQueryConnectorException("Failed to get the UserGroupInformation current user", (Throwable)e);
        }
        config.impersonationServiceAccount = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)IMPERSONATION_GLOBAL);
        config.impersonationServiceAccountsForUsers = BigQueryConfigurationUtil.removePrefixFromMapKeys((com.google.common.base.Optional)BigQueryConfigurationUtil.getAnyOptionsWithPrefix(globalOptions, options, (String)IMPERSONATION_FOR_USER_PREFIX.toLowerCase()), (String)IMPERSONATION_FOR_USER_PREFIX.toLowerCase());
        config.impersonationServiceAccountsForGroups = BigQueryConfigurationUtil.removePrefixFromMapKeys((com.google.common.base.Optional)BigQueryConfigurationUtil.getAnyOptionsWithPrefix(globalOptions, options, (String)IMPERSONATION_FOR_GROUP_PREFIX.toLowerCase()), (String)IMPERSONATION_FOR_GROUP_PREFIX.toLowerCase());
        config.accessToken = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"gcpAccessToken");
        config.credentialsKey = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"credentials");
        config.credentialsFile = BigQueryConfigurationUtil.fromJavaUtil((Optional)BigQueryUtil.firstPresent((Optional[])new Optional[]{BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"credentialsFile").toJavaUtil(), com.google.common.base.Optional.fromNullable((Object)hadoopConfiguration.get(GCS_CONFIG_CREDENTIALS_FILE_PROPERTY)).toJavaUtil()}));
        config.credentialsScopes = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"credentialsScopes").transform(SparkBigQueryConfig::splitOnComma);
        config.filter = BigQueryConfigurationUtil.getOption(options, (String)"filter");
        config.schema = BigQueryConfigurationUtil.fromJavaUtil(schema);
        config.maxParallelism = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (Collection)ImmutableList.of((Object)"maxParallelism", (Object)"parallelism")).transform(Integer::valueOf).orNull();
        config.preferredMinParallelism = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"preferredMinParallelism").transform(Integer::valueOf).orNull();
        config.defaultParallelism = defaultParallelism;
        config.temporaryGcsBucket = SparkBigQueryConfig.stripPrefix((com.google.common.base.Optional<String>)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"temporaryGcsBucket")).or(com.google.common.base.Optional.fromNullable((Object)hadoopConfiguration.get(DATAPROC_SYSTEM_BUCKET_CONFIGURATION)));
        config.persistentGcsBucket = SparkBigQueryConfig.stripPrefix((com.google.common.base.Optional<String>)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"persistentGcsBucket"));
        config.persistentGcsPath = BigQueryConfigurationUtil.getOption(options, (String)"persistentGcsPath");
        WriteMethod writeMethodDefault = Optional.ofNullable(customDefaults.get((Object)WRITE_METHOD_PARAM)).map(WriteMethod::from).orElse(DEFAULT_WRITE_METHOD);
        config.writeMethod = (WriteMethod)((Object)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)WRITE_METHOD_PARAM).transform(WriteMethod::from).or((Object)writeMethodDefault));
        config.writeAtLeastOnce = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)WRITE_AT_LEAST_ONCE_OPTION, (boolean)false);
        boolean validateSparkAvro = config.writeMethod == WriteMethod.INDIRECT && Boolean.valueOf(BigQueryConfigurationUtil.getRequiredOption(options, (String)VALIDATE_SPARK_AVRO_PARAM, () -> "true")) != false;
        boolean enableListInferenceForParquetMode = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)ENABLE_LIST_INFERENCE, (boolean)false);
        String intermediateFormatOption = (String)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)INTERMEDIATE_FORMAT_OPTION).transform(String::toLowerCase).or((Object)DEFAULT_INTERMEDIATE_FORMAT.getDataSource());
        config.intermediateFormat = IntermediateFormat.from(intermediateFormatOption, sparkVersion, sqlConf, validateSparkAvro, enableListInferenceForParquetMode);
        String readDataFormatParam = (String)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)READ_DATA_FORMAT_OPTION).transform(String::toUpperCase).or((Object)DEFAULT_READ_DATA_FORMAT.toString());
        if (!PERMITTED_READ_DATA_FORMATS.contains((Object)readDataFormatParam)) {
            throw new IllegalArgumentException(String.format("Data read format '%s' is not supported. Supported formats are '%s'", readDataFormatParam, String.join((CharSequence)",", PERMITTED_READ_DATA_FORMATS)));
        }
        config.useAvroLogicalTypes = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)USE_AVRO_LOGICAL_TYPES_OPTION, (boolean)false);
        config.readDataFormat = DataFormat.valueOf((String)readDataFormatParam);
        config.combinePushedDownFilters = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)"combinePushedDownFilters", (boolean)true);
        config.partitionField = BigQueryConfigurationUtil.getOption(options, (String)"partitionField");
        config.partitionExpirationMs = (Long)BigQueryConfigurationUtil.getOption(options, (String)"partitionExpirationMs").transform(Long::valueOf).orNull();
        config.partitionRequireFilter = BigQueryConfigurationUtil.getOption(options, (String)"partitionRequireFilter").transform(Boolean::valueOf);
        config.clusteredFields = BigQueryConfigurationUtil.getOption(options, (String)"clusteredFields").transform(SparkBigQueryConfig::splitOnComma);
        config.createDisposition = BigQueryConfigurationUtil.getOption(options, (String)"createDisposition").transform(String::toUpperCase).transform(JobInfo.CreateDisposition::valueOf);
        config.optimizedEmptyProjection = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)"optimizedEmptyProjection", (boolean)true);
        boolean allowFieldAddition = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)"allowFieldAddition", (boolean)false);
        boolean allowFieldRelaxation = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)"allowFieldRelaxation", (boolean)false);
        ImmutableList.Builder loadSchemaUpdateOptions = ImmutableList.builder();
        if (allowFieldAddition) {
            loadSchemaUpdateOptions.add((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
        }
        if (allowFieldRelaxation) {
            loadSchemaUpdateOptions.add((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION);
        }
        config.loadSchemaUpdateOptions = Collections.unmodifiableList(loadSchemaUpdateOptions.build());
        config.decimalTargetTypes = (List)BigQueryConfigurationUtil.getOption(options, (String)"decimalTargetTypes").transform(SparkBigQueryConfig::splitOnComma).or((Object)ImmutableList.of());
        config.bigQueryStorageGrpcEndpoint = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"bigQueryStorageGrpcEndpoint");
        config.bigQueryHttpEndpoint = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"bigQueryHttpEndpoint");
        config.encodedCreateReadSessionRequest = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"bqEncodedCreateReadSessionRequest");
        config.numBackgroundThreadsPerStream = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"bqBackgroundThreadsPerStream").transform(Integer::parseInt).or((Object)0);
        config.pushAllFilters = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)"pushAllFilters", (boolean)true);
        config.enableModeCheckForSchemaFields = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)"enableModeCheckForSchemaFields", (boolean)true);
        config.numPrebufferReadRowsResponses = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"bqPrebufferResponsesPerStream").transform(Integer::parseInt).or((Object)1);
        config.flowControlWindowBytes = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"bqFlowControlWindowBytes").transform(Integer::parseInt);
        config.numStreamsPerPartition = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"bqNumStreamsPerPartition").transform(Integer::parseInt).or((Object)1);
        int sparkExecutorCores = Integer.parseInt((String)globalOptions.getOrDefault((Object)"spark.executor.cores", (Object)"1"));
        int defaultChannelPoolSize = sparkExecutorCores * config.numStreamsPerPartition;
        config.channelPoolSize = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"bqChannelPoolSize").transform(Integer::parseInt).or((Object)defaultChannelPoolSize);
        config.enableReadSessionCaching = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, (String)"enableReadSessionCaching", (boolean)true);
        config.readSessionCacheDurationMins = (Long)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"readSessionCacheDurationMins").transform(Long::parseLong).or((Object)5L);
        if (config.readSessionCacheDurationMins <= 0L || config.readSessionCacheDurationMins > 300L) {
            throw new IllegalArgumentException("readSessionCacheDurationMins should be > 0 and <= 300");
        }
        String arrowCompressionCodecParam = (String)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)ARROW_COMPRESSION_CODEC_OPTION).transform(String::toUpperCase).or((Object)DEFAULT_ARROW_COMPRESSION_CODEC.toString());
        try {
            config.arrowCompressionCodec = ArrowSerializationOptions.CompressionCodec.valueOf((String)arrowCompressionCodecParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Compression codec '%s' for Arrow is not supported. Supported formats are %s", arrowCompressionCodecParam, Arrays.toString(ArrowSerializationOptions.CompressionCodec.values())));
        }
        String responseCompressionCodecParam = (String)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)RESPONSE_COMPRESSION_CODEC_OPTION).transform(String::toUpperCase).or((Object)DEFAULT_RESPONSE_COMPRESSION_CODEC.toString());
        try {
            config.responseCompressionCodec = ReadSession.TableReadOptions.ResponseCompressionCodec.valueOf((String)responseCompressionCodecParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Response compression codec '%s' is not supported. Supported formats are %s", responseCompressionCodecParam, Arrays.toString(ReadSession.TableReadOptions.ResponseCompressionCodec.values())));
        }
        config.cacheExpirationTimeInMinutes = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"cacheExpirationTimeInMinutes").transform(Integer::parseInt).or((Object)15);
        if (config.cacheExpirationTimeInMinutes < 0) {
            throw new IllegalArgumentException("cacheExpirationTimeInMinutes must have a positive value, the configured value is " + config.cacheExpirationTimeInMinutes);
        }
        com.google.common.base.Optional traceApplicationNameParam = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"traceApplicationName").or(com.google.common.base.Optional.fromNullable((Object)"traceApplicationName"));
        config.traceId = traceApplicationNameParam.transform(traceApplicationName -> {
            String traceJobIdParam = (String)BigQueryConfigurationUtil.getAnyOption((ImmutableMap)globalOptions, (Map)options, (String)"traceJobId").or((Object)SparkBigQueryUtil.getJobId(sqlConf));
            String traceIdParam = "Spark:" + traceApplicationName + ":" + traceJobIdParam;
            if (traceIdParam.length() > 256) {
                throw new IllegalArgumentException(String.format("trace ID cannot longer than %d. Provided value was [%s]", 256, traceIdParam));
            }
            return traceIdParam;
        });
        config.bigQueryJobLabels = SparkBigQueryConfig.parseBigQueryLabels(globalOptions, options, BIGQUERY_JOB_LABEL_PREFIX);
        config.bigQueryTableLabels = SparkBigQueryConfig.parseBigQueryLabels(globalOptions, options, BIGQUERY_TABLE_LABEL_PREFIX);
        config.createReadSessionTimeoutInSeconds = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"createReadSessionTimeoutInSeconds").transform(Long::parseLong);
        config.queryJobPriority = (QueryJobConfiguration.Priority)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"queryJobPriority").transform(String::toUpperCase).transform(QueryJobConfiguration.Priority::valueOf).or((Object)DEFAULT_JOB_PRIORITY);
        config.destinationTableKmsKeyName = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)"destinationTableKmsKeyName");
        config.allowMapTypeConversion = (Boolean)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)ALLOW_MAP_TYPE_CONVERSION).transform(Boolean::valueOf).or((Object)ALLOW_MAP_TYPE_CONVERSION_DEFAULT);
        config.partitionOverwriteModeValue = (PartitionOverwriteMode)((Object)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)partitionOverwriteModeProperty).transform(String::toUpperCase).transform(PartitionOverwriteMode::valueOf).or((Object)PartitionOverwriteMode.STATIC));
        config.bigQueryJobTimeoutInMinutes = (Long)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)BIGQUERY_JOB_TIMEOUT_IN_MINUTES).transform(Long::valueOf).or((Object)360L);
        config.gpn = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)GPN_ATTRIBUTION);
        config.snapshotTimeMillis = (Long)BigQueryConfigurationUtil.getOption(options, (String)"snapshotTimeMillis").transform(Long::valueOf).orNull();
        config.bigNumericDefaultPrecision = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)BIG_NUMERIC_DEFAULT_PRECISION).transform(Integer::parseInt).or((Object)76);
        config.bigNumericDefaultScale = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (String)BIG_NUMERIC_DEFAULT_SCALE).transform(Integer::parseInt).or((Object)38);
        config.queryParameterHelper = BigQueryUtil.parseQueryParameters(options);
        return config;
    }

    private static ImmutableList<String> splitOnComma(String value) {
        return (ImmutableList)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToStream((CharSequence)value).collect(ImmutableList.toImmutableList());
    }

    private static com.google.common.base.Optional<String> stripPrefix(com.google.common.base.Optional<String> bucket) {
        return bucket.transform(path -> {
            if (path.startsWith("gs://")) {
                return path.substring(5);
            }
            return path;
        });
    }

    @VisibleForTesting
    static Map<String, String> parseBigQueryLabels(ImmutableMap<String, String> globalOptions, ImmutableMap<String, String> options, String labelPrefix) {
        String lowerCasePrefix = labelPrefix.toLowerCase(Locale.ROOT);
        ImmutableMap allOptions = ImmutableMap.builder().putAll(globalOptions).putAll(options).buildKeepingLast();
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : allOptions.entrySet()) {
            if (!((String)entry.getKey()).toLowerCase(Locale.ROOT).startsWith(lowerCasePrefix)) continue;
            result.put((Object)((String)entry.getKey()).substring(labelPrefix.length()), entry.getValue());
        }
        return Collections.unmodifiableMap(result.build());
    }

    private static ImmutableMap<String, String> toLowerCaseKeysMap(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
        }
        return ImmutableMap.copyOf(result);
    }

    @VisibleForTesting
    static boolean isQuery(String tableParamStr) {
        if (tableParamStr == null || tableParamStr.trim().isEmpty()) {
            return false;
        }
        String potentialQuery = tableParamStr.trim();
        if (potentialQuery.startsWith("`") && potentialQuery.endsWith("`")) {
            return false;
        }
        if (QUICK_LOWERCASE_QUERY_PATTERN.matcher(potentialQuery).matches()) {
            return true;
        }
        return HAS_WHITESPACE_PATTERN.matcher(potentialQuery).find() && SQL_KEYWORD_PATTERN.matcher(potentialQuery).find();
    }

    private static void validateDateFormat(String date, TimePartitioning.Type partitionType, String optionName) {
        try {
            ImmutableMap formatterMap = ImmutableMap.of((Object)TimePartitioning.Type.HOUR, (Object)DateTimeFormatter.ofPattern("yyyyMMddHH"), (Object)TimePartitioning.Type.DAY, (Object)DateTimeFormatter.BASIC_ISO_DATE, (Object)TimePartitioning.Type.MONTH, (Object)DateTimeFormatter.ofPattern("yyyyMM"), (Object)TimePartitioning.Type.YEAR, (Object)DateTimeFormatter.ofPattern("yyyy"));
            DateTimeFormatter dateTimeFormatter = (DateTimeFormatter)formatterMap.get(partitionType);
            dateTimeFormatter.parse(date);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Invalid argument for option %s, format is YYYYMMDD", optionName));
        }
    }

    static ImmutableMap<String, String> normalizeConf(Map<String, String> conf) {
        Map<String, String> normalizeConf = conf.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CONF_PREFIX)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(CONF_PREFIX.length()), e -> (String)e.getValue()));
        HashMap<String, String> result = new HashMap<String, String>(conf);
        result.putAll(normalizeConf);
        return ImmutableMap.copyOf(result);
    }

    public Credentials createCredentials() {
        return new BigQueryCredentialsSupplier(this.accessTokenProviderFQCN.toJavaUtil(), this.accessTokenProviderConfig.toJavaUtil(), this.accessToken.toJavaUtil(), this.credentialsKey.toJavaUtil(), this.credentialsFile.toJavaUtil(), this.loggedInUserName, this.loggedInUserGroups, this.impersonationServiceAccountsForUsers.toJavaUtil(), this.impersonationServiceAccountsForGroups.toJavaUtil(), this.impersonationServiceAccount.toJavaUtil(), this.credentialsScopes.toJavaUtil(), this.sparkBigQueryProxyAndHttpConfig.getProxyUri(), this.sparkBigQueryProxyAndHttpConfig.getProxyUsername(), this.sparkBigQueryProxyAndHttpConfig.getProxyPassword()).getCredentials();
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public TableId getTableIdWithExplicitProject() {
        if (this.tableId.getProject() != null) {
            return this.tableId;
        }
        return TableId.of((String)ServiceOptions.getDefaultProjectId(), (String)this.tableId.getDataset(), (String)this.tableId.getTable());
    }

    public TableId getTableIdWithoutThePartition() {
        String tableAndPartition = this.tableId.getTable();
        if (!tableAndPartition.contains("$")) {
            return this.tableId;
        }
        String table = tableAndPartition.substring(0, tableAndPartition.indexOf(36));
        return this.tableId.getProject() != null ? TableId.of((String)this.tableId.getProject(), (String)this.tableId.getDataset(), (String)table) : TableId.of((String)this.tableId.getDataset(), (String)table);
    }

    public Optional<String> getQuery() {
        return this.query.toJavaUtil();
    }

    public QueryParameterHelper getQueryParameterHelper() {
        return this.queryParameterHelper;
    }

    public String getParentProjectId() {
        return this.parentProjectId;
    }

    public boolean useParentProjectForMetadataOperations() {
        return this.useParentProjectForMetadataOperations;
    }

    public Optional<String> getAccessTokenProviderFQCN() {
        return this.accessTokenProviderFQCN.toJavaUtil();
    }

    public Optional<String> getAccessTokenProviderConfig() {
        return this.accessTokenProviderConfig.toJavaUtil();
    }

    public String getLoggedInUserName() {
        return this.loggedInUserName;
    }

    public Set<String> getLoggedInUserGroups() {
        return this.loggedInUserGroups;
    }

    public Optional<Map<String, String>> getImpersonationServiceAccountsForUsers() {
        return this.impersonationServiceAccountsForUsers.toJavaUtil();
    }

    public Optional<Map<String, String>> getImpersonationServiceAccountsForGroups() {
        return this.impersonationServiceAccountsForGroups.toJavaUtil();
    }

    public Optional<String> getImpersonationServiceAccount() {
        return this.impersonationServiceAccount.toJavaUtil();
    }

    public Optional<String> getCredentialsKey() {
        return this.credentialsKey.toJavaUtil();
    }

    public Optional<String> getCredentialsFile() {
        return this.credentialsFile.toJavaUtil();
    }

    public Optional<String> getAccessToken() {
        return this.accessToken.toJavaUtil();
    }

    public Optional<ImmutableList<String>> getCredentialsScopes() {
        return this.credentialsScopes.toJavaUtil();
    }

    public Optional<String> getFilter() {
        return this.filter.toJavaUtil();
    }

    public Optional<StructType> getSchema() {
        return this.schema.toJavaUtil();
    }

    public OptionalInt getMaxParallelism() {
        return this.maxParallelism == null ? OptionalInt.empty() : OptionalInt.of(this.maxParallelism);
    }

    public OptionalInt getPreferredMinParallelism() {
        return this.preferredMinParallelism == null ? OptionalInt.empty() : OptionalInt.of(this.preferredMinParallelism);
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public Optional<String> getTemporaryGcsBucket() {
        return this.temporaryGcsBucket.toJavaUtil();
    }

    public Optional<String> getPersistentGcsBucket() {
        return this.persistentGcsBucket.toJavaUtil();
    }

    public Optional<String> getPersistentGcsPath() {
        return this.persistentGcsPath.toJavaUtil();
    }

    public IntermediateFormat getIntermediateFormat() {
        return this.intermediateFormat;
    }

    public DataFormat getReadDataFormat() {
        return this.readDataFormat;
    }

    public ArrowSerializationOptions.CompressionCodec getArrowCompressionCodec() {
        return this.arrowCompressionCodec;
    }

    public ReadSession.TableReadOptions.ResponseCompressionCodec getResponseCompressionCodec() {
        return this.responseCompressionCodec;
    }

    public boolean isCombinePushedDownFilters() {
        return this.combinePushedDownFilters;
    }

    public boolean isUseAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    public ImmutableList<String> getDecimalTargetTypes() {
        return ImmutableList.copyOf(this.decimalTargetTypes);
    }

    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    public Optional<String> getMaterializationProject() {
        return this.materializationProject.toJavaUtil();
    }

    public Optional<String> getMaterializationDataset() {
        return this.materializationDataset.toJavaUtil();
    }

    public int getMaterializationExpirationTimeInMinutes() {
        return this.materializationExpirationTimeInMinutes;
    }

    public Optional<String> getPartitionField() {
        return this.partitionField.toJavaUtil();
    }

    public OptionalLong getPartitionExpirationMs() {
        return this.partitionExpirationMs == null ? OptionalLong.empty() : OptionalLong.of(this.partitionExpirationMs);
    }

    public Optional<Boolean> getPartitionRequireFilter() {
        return this.partitionRequireFilter.toJavaUtil();
    }

    public Optional<TimePartitioning.Type> getPartitionType() {
        return this.partitionType.toJavaUtil();
    }

    public Optional<RangePartitioning.Range> getPartitionRange() {
        if (this.partitionRangeStart.isPresent() && this.partitionRangeEnd.isPresent() && this.partitionRangeInterval.isPresent()) {
            return Optional.of(RangePartitioning.Range.newBuilder().setStart((Long)this.partitionRangeStart.get()).setEnd((Long)this.partitionRangeEnd.get()).setInterval((Long)this.partitionRangeInterval.get()).build());
        }
        return Optional.empty();
    }

    public TimePartitioning.Type getPartitionTypeOrDefault() {
        return (TimePartitioning.Type)this.partitionType.or((Object)TimePartitioning.Type.DAY);
    }

    public Optional<ImmutableList<String>> getClusteredFields() {
        return this.clusteredFields.transform(fields -> ImmutableList.copyOf((Collection)fields)).toJavaUtil();
    }

    public Optional<JobInfo.CreateDisposition> getCreateDisposition() {
        return this.createDisposition.toJavaUtil();
    }

    public boolean isOptimizedEmptyProjection() {
        return this.optimizedEmptyProjection;
    }

    public ImmutableList<JobInfo.SchemaUpdateOption> getLoadSchemaUpdateOptions() {
        return ImmutableList.copyOf(this.loadSchemaUpdateOptions);
    }

    public int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    public boolean getPushAllFilters() {
        return this.pushAllFilters;
    }

    public boolean getEnableModeCheckForSchemaFields() {
        return this.enableModeCheckForSchemaFields;
    }

    public int getBigQueryClientConnectTimeout() {
        return this.sparkBigQueryProxyAndHttpConfig.getHttpConnectTimeout().orElse(60000);
    }

    public int getBigQueryClientReadTimeout() {
        return this.sparkBigQueryProxyAndHttpConfig.getHttpReadTimeout().orElse(60000);
    }

    public BigQueryProxyConfig getBigQueryProxyConfig() {
        return this.sparkBigQueryProxyAndHttpConfig;
    }

    public Optional<String> getBigQueryStorageGrpcEndpoint() {
        return this.bigQueryStorageGrpcEndpoint.toJavaUtil();
    }

    public Optional<String> getBigQueryHttpEndpoint() {
        return this.bigQueryHttpEndpoint.toJavaUtil();
    }

    public int getCacheExpirationTimeInMinutes() {
        return this.cacheExpirationTimeInMinutes;
    }

    public Optional<Long> getCreateReadSessionTimeoutInSeconds() {
        return this.createReadSessionTimeoutInSeconds.toJavaUtil();
    }

    public PartitionOverwriteMode getPartitionOverwriteModeValue() {
        return this.partitionOverwriteModeValue;
    }

    public int getChannelPoolSize() {
        return this.channelPoolSize;
    }

    public Optional<Integer> getFlowControlWindowBytes() {
        return this.flowControlWindowBytes.toJavaUtil();
    }

    public QueryJobConfiguration.Priority getQueryJobPriority() {
        return this.queryJobPriority;
    }

    public Optional<String> getKmsKeyName() {
        return this.destinationTableKmsKeyName.toJavaUtil();
    }

    public RetrySettings getBigQueryClientRetrySettings() {
        int maxAttempts = this.sparkBigQueryProxyAndHttpConfig.getHttpMaxRetry().orElse(10);
        return SparkBigQueryConfig.getRetrySettings(maxAttempts);
    }

    private static RetrySettings getRetrySettings(int maxAttempts) {
        return RetrySettings.newBuilder().setMaxAttempts(maxAttempts).setTotalTimeout(Duration.ofMinutes((long)10L)).setInitialRpcTimeout(Duration.ofSeconds((long)60L)).setMaxRpcTimeout(Duration.ofMinutes((long)5L)).setRpcTimeoutMultiplier(1.6).setRetryDelayMultiplier(1.6).setInitialRetryDelay(Duration.ofMillis((long)1250L)).setMaxRetryDelay(Duration.ofSeconds((long)5L)).build();
    }

    public RetrySettings getBigqueryDataWriteHelperRetrySettings() {
        return SparkBigQueryConfig.getRetrySettings(5);
    }

    public WriteMethod getWriteMethod() {
        return this.writeMethod;
    }

    public boolean isWriteAtLeastOnce() {
        return this.writeAtLeastOnce;
    }

    public Optional<String> getTraceId() {
        return this.traceId.toJavaUtil();
    }

    public ImmutableMap<String, String> getBigQueryJobLabels() {
        return ImmutableMap.copyOf(this.bigQueryJobLabels);
    }

    public boolean getAllowMapTypeConversion() {
        return this.allowMapTypeConversion;
    }

    public long getBigQueryJobTimeoutInMinutes() {
        return this.bigQueryJobTimeoutInMinutes;
    }

    public ImmutableMap<String, String> getBigQueryTableLabels() {
        return ImmutableMap.copyOf(this.bigQueryTableLabels);
    }

    public Optional<String> getGpn() {
        return this.gpn.toJavaUtil();
    }

    public OptionalLong getSnapshotTimeMillis() {
        return this.snapshotTimeMillis == null ? OptionalLong.empty() : OptionalLong.of(this.snapshotTimeMillis);
    }

    public int getBigNumericDefaultPrecision() {
        return this.bigNumericDefaultPrecision;
    }

    public int getBigNumericDefaultScale() {
        return this.bigNumericDefaultScale;
    }

    public ReadSessionCreatorConfig toReadSessionCreatorConfig() {
        return new ReadSessionCreatorConfigBuilder().setViewsEnabled(this.viewsEnabled).setMaterializationProject(this.materializationProject.toJavaUtil()).setMaterializationDataset(this.materializationDataset.toJavaUtil()).setMaterializationExpirationTimeInMinutes(this.materializationExpirationTimeInMinutes).setReadDataFormat(this.readDataFormat).setMaxReadRowsRetries(this.maxReadRowsRetries).setViewEnabledParamName(VIEWS_ENABLED_OPTION).setDefaultParallelism(this.defaultParallelism).setMaxParallelism(this.getMaxParallelism()).setPreferredMinParallelism(this.getPreferredMinParallelism()).setRequestEncodedBase(this.encodedCreateReadSessionRequest.toJavaUtil()).setBigQueryStorageGrpcEndpoint(this.bigQueryStorageGrpcEndpoint.toJavaUtil()).setBigQueryHttpEndpoint(this.bigQueryHttpEndpoint.toJavaUtil()).setBackgroundParsingThreads(this.numBackgroundThreadsPerStream).setPushAllFilters(this.pushAllFilters).setPrebufferReadRowsResponses(this.numPrebufferReadRowsResponses).setStreamsPerPartition(this.numStreamsPerPartition).setArrowCompressionCodec(this.arrowCompressionCodec).setResponseCompressionCodec(this.responseCompressionCodec).setTraceId(this.traceId.toJavaUtil()).setEnableReadSessionCaching(this.enableReadSessionCaching).setReadSessionCacheDurationMins(this.readSessionCacheDurationMins).setSnapshotTimeMillis(this.getSnapshotTimeMillis()).build();
    }

    public BigQueryClient.ReadTableOptions toReadTableOptions() {
        return new BigQueryClient.ReadTableOptions(){

            public TableId tableId() {
                return SparkBigQueryConfig.this.getTableId();
            }

            public Optional<String> query() {
                return SparkBigQueryConfig.this.getQuery();
            }

            public boolean viewsEnabled() {
                return SparkBigQueryConfig.this.isViewsEnabled();
            }

            public String viewEnabledParamName() {
                return SparkBigQueryConfig.VIEWS_ENABLED_OPTION;
            }

            public QueryParameterHelper getQueryParameterHelper() {
                return SparkBigQueryConfig.this.getQueryParameterHelper();
            }

            public int expirationTimeInMinutes() {
                return SparkBigQueryConfig.this.getMaterializationExpirationTimeInMinutes();
            }
        };
    }

    public static enum IntermediateFormat {
        AVRO("avro", (FormatOptions)FormatOptions.avro()),
        AVRO_2_3("com.databricks.spark.avro", (FormatOptions)FormatOptions.avro()),
        ORC("orc", FormatOptions.orc()),
        PARQUET("parquet", FormatOptions.parquet()),
        PARQUET_LIST_INFERENCE_ENABLED("parquet", (FormatOptions)ParquetOptions.newBuilder().setEnableListInference(Boolean.valueOf(true)).build());

        private static Set<String> PERMITTED_DATA_SOURCES;
        private final String dataSource;
        private final FormatOptions formatOptions;

        private IntermediateFormat(String dataSource, FormatOptions formatOptions) {
            this.dataSource = dataSource;
            this.formatOptions = formatOptions;
        }

        public static IntermediateFormat from(String format, String sparkVersion, SQLConf sqlConf, boolean validateSparkAvro, boolean enableListInferenceForParquetMode) {
            Preconditions.checkArgument((boolean)PERMITTED_DATA_SOURCES.contains(format.toLowerCase()), (String)"Data write format '%s' is not supported. Supported formats are %s", (Object)format, PERMITTED_DATA_SOURCES);
            if (validateSparkAvro && format.equalsIgnoreCase("avro")) {
                IntermediateFormat intermediateFormat2 = IntermediateFormat.isSpark24OrAbove(sparkVersion) ? AVRO : AVRO_2_3;
                try {
                    DataSource.lookupDataSource((String)intermediateFormat2.getDataSource(), (SQLConf)sqlConf);
                }
                catch (Exception ae) {
                    throw IntermediateFormat.missingAvroException(sparkVersion, ae);
                }
                return intermediateFormat2;
            }
            if (enableListInferenceForParquetMode && format.equalsIgnoreCase("parquet")) {
                return PARQUET_LIST_INFERENCE_ENABLED;
            }
            return Stream.of(IntermediateFormat.values()).filter(intermediateFormat -> intermediateFormat.getDataSource().equalsIgnoreCase(format)).findFirst().get();
        }

        static boolean isSpark24OrAbove(String sparkVersion) {
            return sparkVersion.compareTo("2.4") > 0;
        }

        @VisibleForTesting
        static IllegalStateException missingAvroException(String sparkVersion, Exception cause) {
            String avroPackage;
            if (IntermediateFormat.isSpark24OrAbove(sparkVersion)) {
                String scalaVersion = Properties.versionNumberString();
                String scalaShortVersion = scalaVersion.substring(0, scalaVersion.lastIndexOf(46));
                avroPackage = String.format("org.apache.spark:spark-avro_%s:%s", scalaShortVersion, sparkVersion);
            } else {
                avroPackage = "com.databricks:spark-avro_2.11:4.0.0";
            }
            String message = String.format("Avro writing is not supported, as the spark-avro has not been found. Please re-run spark with the --packages %s parameter", avroPackage);
            return new IllegalStateException(message, cause);
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public FormatOptions getFormatOptions() {
            return this.formatOptions;
        }

        public String getFileSuffix() {
            return this.getFormatOptions().getType().toLowerCase();
        }

        static {
            PERMITTED_DATA_SOURCES = Stream.of(IntermediateFormat.values()).map(IntermediateFormat::getDataSource).filter(dataSource -> !dataSource.contains(".")).collect(Collectors.toSet());
        }
    }

    public static enum WriteMethod {
        DIRECT,
        INDIRECT;


        public static WriteMethod from(@Nullable String writeMethod) {
            try {
                return WriteMethod.valueOf(writeMethod.toUpperCase(Locale.ENGLISH));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("WriteMethod can be only " + Arrays.toString((Object[])WriteMethod.values()));
            }
        }
    }
}

