/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.spark.bigquery.DataFrameToRDDConverter;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.write.BigQueryWriteHelper;
import com.google.common.collect.Streams;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BigQueryStreamWriter {
    private static final Logger log = LoggerFactory.getLogger(BigQueryStreamWriter.class);

    private BigQueryStreamWriter() {
    }

    public static void writeBatch(Dataset<Row> data, SQLContext sqlContext, OutputMode outputMode, SparkBigQueryConfig opts, BigQueryClient bigQueryClient) {
        StructType schema = data.schema();
        String sparkVersion = sqlContext.sparkSession().version();
        RDD<Row> rowRdd = BigQueryStreamWriter.dataFrameToRDDConverterFactory(sparkVersion).convertToRDD(data);
        Dataset dataFrame = sqlContext.createDataFrame(rowRdd, schema);
        TableInfo table = bigQueryClient.getTable(opts.getTableId());
        SaveMode saveMode = BigQueryStreamWriter.getSaveMode(outputMode);
        BigQueryWriteHelper helper = new BigQueryWriteHelper(bigQueryClient, sqlContext, saveMode, opts, (Dataset<Row>)dataFrame, Optional.ofNullable(table));
        helper.writeDataFrameToBigQuery();
    }

    private static SaveMode getSaveMode(OutputMode outputMode) {
        if (outputMode.equals(OutputMode.Complete())) {
            return SaveMode.Overwrite;
        }
        if (outputMode.equals(OutputMode.Update())) {
            throw new UnsupportedOperationException("Updates are not yet supported");
        }
        return SaveMode.Append;
    }

    public static DataFrameToRDDConverter dataFrameToRDDConverterFactory(String sparkVersion) {
        ServiceLoader<DataFrameToRDDConverter> serviceLoader = ServiceLoader.load(DataFrameToRDDConverter.class);
        return Streams.stream(serviceLoader.iterator()).filter(converter -> converter.supports(sparkVersion)).findFirst().orElseThrow(() -> new IllegalStateException("Could not find an implementation of " + DataFrameToRDDConverter.class.getCanonicalName()));
    }
}

