/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2.context;

import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.spark.bigquery.ReadRowsResponseToInternalRowIteratorConverter;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.v2.context.BigQueryInputPartitionReaderContext;
import com.google.cloud.spark.bigquery.v2.context.InputPartitionContext;
import com.google.cloud.spark.bigquery.v2.context.InputPartitionReaderContext;
import java.util.Iterator;
import java.util.Optional;
import org.apache.spark.sql.catalyst.InternalRow;

public class BigQueryInputPartitionContext
implements InputPartitionContext<InternalRow> {
    private final BigQueryClientFactory bigQueryReadClientFactory;
    private final String streamName;
    private final ReadRowsHelper.Options options;
    private final ReadRowsResponseToInternalRowIteratorConverter converter;

    public BigQueryInputPartitionContext(BigQueryClientFactory bigQueryReadClientFactory, String streamName, ReadRowsHelper.Options options, ReadRowsResponseToInternalRowIteratorConverter converter) {
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
        this.streamName = streamName;
        this.options = options;
        this.converter = converter;
    }

    @Override
    public InputPartitionReaderContext<InternalRow> createPartitionReaderContext() {
        ReadRowsRequest.Builder readRowsRequest = ReadRowsRequest.newBuilder().setReadStream(this.streamName);
        ReadRowsHelper readRowsHelper = new ReadRowsHelper(this.bigQueryReadClientFactory, readRowsRequest, this.options, Optional.empty());
        Iterator<ReadRowsResponse> readRowsResponses = readRowsHelper.readRows();
        return new BigQueryInputPartitionReaderContext(readRowsResponses, this.converter, readRowsHelper);
    }

    @Override
    public boolean supportColumnarReads() {
        return false;
    }
}

