/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.spark.bigquery.repackaged.com.google.inject.Injector;
import com.google.cloud.spark.bigquery.v2.BigQueryBatchWrite;
import com.google.cloud.spark.bigquery.write.context.DataSourceWriterContext;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.SupportsOverwrite;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.sources.Filter;

public class BigQueryWriteBuilder
implements WriteBuilder,
SupportsOverwrite {
    protected final Injector injector;
    protected final LogicalWriteInfo info;
    protected final SaveMode mode;

    public BigQueryWriteBuilder(Injector injector, LogicalWriteInfo info, SaveMode mode) {
        this.injector = injector;
        this.info = info;
        this.mode = mode;
    }

    public BatchWrite buildForBatch() {
        Optional<DataSourceWriterContext> dataSourceWriterContext = DataSourceWriterContext.create(this.injector, this.info.queryId(), this.info.schema(), this.mode, (Map<String, String>)this.info.options());
        return new BigQueryBatchWrite(dataSourceWriterContext.get());
    }

    public WriteBuilder overwrite(Filter[] filters) {
        return null;
    }

    public WriteBuilder truncate() {
        return new BigQueryWriteBuilder(this.injector, this.info, SaveMode.Overwrite);
    }
}

