/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import org.apache.spark.sql.connector.catalog.Identifier;

public class BigQueryIdentifier
implements Identifier {
    private final TableId tableId;

    public BigQueryIdentifier(TableId tableId) {
        this.tableId = tableId;
    }

    public static BigQueryIdentifier of(TableId tableId) {
        return new BigQueryIdentifier(tableId);
    }

    public String[] namespace() {
        String[] stringArray;
        if (this.tableId.getProject() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.tableId.getDataset();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.tableId.getProject();
            stringArray = stringArray3;
            stringArray3[1] = this.tableId.getDataset();
        }
        return stringArray;
    }

    public String name() {
        return this.tableId.getTable();
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String toString() {
        return "BigQueryIdentifier{tableId=" + BigQueryUtil.friendlyTableName(this.tableId) + '}';
    }
}

