/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.impl;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.StructVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.impl.NullableCaseSensitiveStructWriter;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.impl.NullableStructWriter;

public class NullableStructWriterFactory {
    private final boolean caseSensitive;
    private static final NullableStructWriterFactory nullableStructWriterFactory = new NullableStructWriterFactory(false);
    private static final NullableStructWriterFactory nullableCaseSensitiveWriterFactory = new NullableStructWriterFactory(true);

    public NullableStructWriterFactory(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public NullableStructWriter build(StructVector container) {
        return this.caseSensitive ? new NullableCaseSensitiveStructWriter(container) : new NullableStructWriter(container);
    }

    public static NullableStructWriterFactory getNullableStructWriterFactoryInstance() {
        return nullableStructWriterFactory;
    }

    public static NullableStructWriterFactory getNullableCaseSensitiveStructWriterFactoryInstance() {
        return nullableCaseSensitiveWriterFactory;
    }
}

