/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.context.propagation;

import com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.context.Context;
import com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.context.propagation.MultiTextMapPropagator;
import com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.context.propagation.NoopTextMapPropagator;
import com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.context.propagation.TextMapGetter;
import com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface TextMapPropagator {
    public static TextMapPropagator composite(TextMapPropagator ... propagators) {
        return TextMapPropagator.composite(Arrays.asList(propagators));
    }

    public static TextMapPropagator composite(Iterable<TextMapPropagator> propagators) {
        ArrayList<TextMapPropagator> propagatorsList = new ArrayList<TextMapPropagator>();
        for (TextMapPropagator propagator : propagators) {
            propagatorsList.add(propagator);
        }
        if (propagatorsList.isEmpty()) {
            return NoopTextMapPropagator.getInstance();
        }
        if (propagatorsList.size() == 1) {
            return (TextMapPropagator)propagatorsList.get(0);
        }
        return new MultiTextMapPropagator(propagatorsList);
    }

    public static TextMapPropagator noop() {
        return NoopTextMapPropagator.getInstance();
    }

    public Collection<String> fields();

    public <C> void inject(Context var1, @Nullable C var2, TextMapSetter<C> var3);

    public <C> Context extract(Context var1, @Nullable C var2, TextMapGetter<C> var3);
}

