/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/bundle/bundle.proto

package com.google.firestore.bundle;

/**
 *
 *
 * <pre>
 * A Query associated with a name, created as part of the bundle file, and can be read
 * by client SDKs once the bundle containing them is loaded.
 * </pre>
 *
 * Protobuf type {@code google.firestore.bundle.NamedQuery}
 */
public final class NamedQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.bundle.NamedQuery)
    NamedQueryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NamedQuery.newBuilder() to construct.
  private NamedQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NamedQuery() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NamedQuery();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private NamedQuery(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.firestore.bundle.BundledQuery.Builder subBuilder = null;
              if (bundledQuery_ != null) {
                subBuilder = bundledQuery_.toBuilder();
              }
              bundledQuery_ =
                  input.readMessage(
                      com.google.firestore.bundle.BundledQuery.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(bundledQuery_);
                bundledQuery_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (readTime_ != null) {
                subBuilder = readTime_.toBuilder();
              }
              readTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(readTime_);
                readTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.bundle.BundleProto
        .internal_static_google_firestore_bundle_NamedQuery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.bundle.BundleProto
        .internal_static_google_firestore_bundle_NamedQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.bundle.NamedQuery.class,
            com.google.firestore.bundle.NamedQuery.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Name of the query, such that client can use the name to load this query
   * from bundle, and resume from when the query results are materialized
   * into this bundle.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the query, such that client can use the name to load this query
   * from bundle, and resume from when the query results are materialized
   * into this bundle.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUNDLED_QUERY_FIELD_NUMBER = 2;
  private com.google.firestore.bundle.BundledQuery bundledQuery_;
  /**
   *
   *
   * <pre>
   * The query saved in the bundle.
   * </pre>
   *
   * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
   *
   * @return Whether the bundledQuery field is set.
   */
  @java.lang.Override
  public boolean hasBundledQuery() {
    return bundledQuery_ != null;
  }
  /**
   *
   *
   * <pre>
   * The query saved in the bundle.
   * </pre>
   *
   * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
   *
   * @return The bundledQuery.
   */
  @java.lang.Override
  public com.google.firestore.bundle.BundledQuery getBundledQuery() {
    return bundledQuery_ == null
        ? com.google.firestore.bundle.BundledQuery.getDefaultInstance()
        : bundledQuery_;
  }
  /**
   *
   *
   * <pre>
   * The query saved in the bundle.
   * </pre>
   *
   * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.bundle.BundledQueryOrBuilder getBundledQueryOrBuilder() {
    return getBundledQuery();
  }

  public static final int READ_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * The read time of the query, when it is used to build the bundle. This is useful to
   * resume the query from the bundle, once it is loaded by client SDKs.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return readTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The read time of the query, when it is used to build the bundle. This is useful to
   * resume the query from the bundle, once it is loaded by client SDKs.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * The read time of the query, when it is used to build the bundle. This is useful to
   * resume the query from the bundle, once it is loaded by client SDKs.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return getReadTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (bundledQuery_ != null) {
      output.writeMessage(2, getBundledQuery());
    }
    if (readTime_ != null) {
      output.writeMessage(3, getReadTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (bundledQuery_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBundledQuery());
    }
    if (readTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getReadTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.bundle.NamedQuery)) {
      return super.equals(obj);
    }
    com.google.firestore.bundle.NamedQuery other = (com.google.firestore.bundle.NamedQuery) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasBundledQuery() != other.hasBundledQuery()) return false;
    if (hasBundledQuery()) {
      if (!getBundledQuery().equals(other.getBundledQuery())) return false;
    }
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasBundledQuery()) {
      hash = (37 * hash) + BUNDLED_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getBundledQuery().hashCode();
    }
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.bundle.NamedQuery parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.bundle.NamedQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.bundle.NamedQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.bundle.NamedQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Query associated with a name, created as part of the bundle file, and can be read
   * by client SDKs once the bundle containing them is loaded.
   * </pre>
   *
   * Protobuf type {@code google.firestore.bundle.NamedQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.bundle.NamedQuery)
      com.google.firestore.bundle.NamedQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.bundle.BundleProto
          .internal_static_google_firestore_bundle_NamedQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.bundle.BundleProto
          .internal_static_google_firestore_bundle_NamedQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.bundle.NamedQuery.class,
              com.google.firestore.bundle.NamedQuery.Builder.class);
    }

    // Construct using com.google.firestore.bundle.NamedQuery.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (bundledQueryBuilder_ == null) {
        bundledQuery_ = null;
      } else {
        bundledQuery_ = null;
        bundledQueryBuilder_ = null;
      }
      if (readTimeBuilder_ == null) {
        readTime_ = null;
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.bundle.BundleProto
          .internal_static_google_firestore_bundle_NamedQuery_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.bundle.NamedQuery getDefaultInstanceForType() {
      return com.google.firestore.bundle.NamedQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.bundle.NamedQuery build() {
      com.google.firestore.bundle.NamedQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.bundle.NamedQuery buildPartial() {
      com.google.firestore.bundle.NamedQuery result =
          new com.google.firestore.bundle.NamedQuery(this);
      result.name_ = name_;
      if (bundledQueryBuilder_ == null) {
        result.bundledQuery_ = bundledQuery_;
      } else {
        result.bundledQuery_ = bundledQueryBuilder_.build();
      }
      if (readTimeBuilder_ == null) {
        result.readTime_ = readTime_;
      } else {
        result.readTime_ = readTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.bundle.NamedQuery) {
        return mergeFrom((com.google.firestore.bundle.NamedQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.bundle.NamedQuery other) {
      if (other == com.google.firestore.bundle.NamedQuery.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasBundledQuery()) {
        mergeBundledQuery(other.getBundledQuery());
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.bundle.NamedQuery parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.bundle.NamedQuery) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the query, such that client can use the name to load this query
     * from bundle, and resume from when the query results are materialized
     * into this bundle.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the query, such that client can use the name to load this query
     * from bundle, and resume from when the query results are materialized
     * into this bundle.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the query, such that client can use the name to load this query
     * from bundle, and resume from when the query results are materialized
     * into this bundle.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the query, such that client can use the name to load this query
     * from bundle, and resume from when the query results are materialized
     * into this bundle.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the query, such that client can use the name to load this query
     * from bundle, and resume from when the query results are materialized
     * into this bundle.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.firestore.bundle.BundledQuery bundledQuery_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.bundle.BundledQuery,
            com.google.firestore.bundle.BundledQuery.Builder,
            com.google.firestore.bundle.BundledQueryOrBuilder>
        bundledQueryBuilder_;
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     *
     * @return Whether the bundledQuery field is set.
     */
    public boolean hasBundledQuery() {
      return bundledQueryBuilder_ != null || bundledQuery_ != null;
    }
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     *
     * @return The bundledQuery.
     */
    public com.google.firestore.bundle.BundledQuery getBundledQuery() {
      if (bundledQueryBuilder_ == null) {
        return bundledQuery_ == null
            ? com.google.firestore.bundle.BundledQuery.getDefaultInstance()
            : bundledQuery_;
      } else {
        return bundledQueryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     */
    public Builder setBundledQuery(com.google.firestore.bundle.BundledQuery value) {
      if (bundledQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bundledQuery_ = value;
        onChanged();
      } else {
        bundledQueryBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     */
    public Builder setBundledQuery(
        com.google.firestore.bundle.BundledQuery.Builder builderForValue) {
      if (bundledQueryBuilder_ == null) {
        bundledQuery_ = builderForValue.build();
        onChanged();
      } else {
        bundledQueryBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     */
    public Builder mergeBundledQuery(com.google.firestore.bundle.BundledQuery value) {
      if (bundledQueryBuilder_ == null) {
        if (bundledQuery_ != null) {
          bundledQuery_ =
              com.google.firestore.bundle.BundledQuery.newBuilder(bundledQuery_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          bundledQuery_ = value;
        }
        onChanged();
      } else {
        bundledQueryBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     */
    public Builder clearBundledQuery() {
      if (bundledQueryBuilder_ == null) {
        bundledQuery_ = null;
        onChanged();
      } else {
        bundledQuery_ = null;
        bundledQueryBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     */
    public com.google.firestore.bundle.BundledQuery.Builder getBundledQueryBuilder() {

      onChanged();
      return getBundledQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     */
    public com.google.firestore.bundle.BundledQueryOrBuilder getBundledQueryOrBuilder() {
      if (bundledQueryBuilder_ != null) {
        return bundledQueryBuilder_.getMessageOrBuilder();
      } else {
        return bundledQuery_ == null
            ? com.google.firestore.bundle.BundledQuery.getDefaultInstance()
            : bundledQuery_;
      }
    }
    /**
     *
     *
     * <pre>
     * The query saved in the bundle.
     * </pre>
     *
     * <code>.google.firestore.bundle.BundledQuery bundled_query = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.bundle.BundledQuery,
            com.google.firestore.bundle.BundledQuery.Builder,
            com.google.firestore.bundle.BundledQueryOrBuilder>
        getBundledQueryFieldBuilder() {
      if (bundledQueryBuilder_ == null) {
        bundledQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.bundle.BundledQuery,
                com.google.firestore.bundle.BundledQuery.Builder,
                com.google.firestore.bundle.BundledQueryOrBuilder>(
                getBundledQuery(), getParentForChildren(), isClean());
        bundledQuery_ = null;
      }
      return bundledQueryBuilder_;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return readTimeBuilder_ != null || readTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (readTime_ != null) {
          readTime_ =
              com.google.protobuf.Timestamp.newBuilder(readTime_).mergeFrom(value).buildPartial();
        } else {
          readTime_ = value;
        }
        onChanged();
      } else {
        readTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        readTime_ = null;
        onChanged();
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {

      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The read time of the query, when it is used to build the bundle. This is useful to
     * resume the query from the bundle, once it is loaded by client SDKs.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.bundle.NamedQuery)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.bundle.NamedQuery)
  private static final com.google.firestore.bundle.NamedQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.bundle.NamedQuery();
  }

  public static com.google.firestore.bundle.NamedQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NamedQuery> PARSER =
      new com.google.protobuf.AbstractParser<NamedQuery>() {
        @java.lang.Override
        public NamedQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new NamedQuery(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<NamedQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NamedQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.bundle.NamedQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
