/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.opentelemetry.trace.CloudTraceClient;
import com.google.cloud.opentelemetry.trace.CloudTraceClientImpl;
import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.opentelemetry.trace.TraceTranslator;
import com.google.cloud.opentelemetry.trace.TraceVersions;
import com.google.cloud.trace.v2.TraceServiceClient;
import com.google.cloud.trace.v2.TraceServiceSettings;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.ProjectName;
import com.google.devtools.cloudtrace.v2.Span;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.threeten.bp.Duration;

class InternalTraceExporter
implements SpanExporter {
    private final CloudTraceClient cloudTraceClient;
    private final ProjectName projectName;
    private final String projectId;
    private final TraceTranslator translator;
    private static final Map<String, String> HEADERS = Collections.singletonMap("User-Agent", "opentelemetry-operations-java/" + TraceVersions.EXPORTER_VERSION);
    private static final HeaderProvider HEADER_PROVIDER = () -> HEADERS;

    private static InternalTraceExporter createWithClient(String projectId, CloudTraceClient cloudTraceClient, ImmutableMap<String, String> attributeMappings, Map<String, AttributeValue> fixedAttributes) {
        return new InternalTraceExporter(projectId, cloudTraceClient, attributeMappings, fixedAttributes);
    }

    static SpanExporter createWithConfiguration(TraceConfiguration configuration) throws IOException {
        String projectId = configuration.getProjectId();
        TraceServiceStub stub = configuration.getTraceServiceStub();
        if (stub == null) {
            TraceServiceSettings.Builder builder = TraceServiceSettings.newBuilder();
            builder.batchWriteSpansSettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)configuration.getDeadline().toMillis()));
            if (configuration.getInsecureEndpoint()) {
                builder.setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
                builder.setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)ManagedChannelBuilder.forTarget((String)configuration.getTraceServiceEndpoint()).usePlaintext().build())));
            } else {
                GoogleCredentials credentials = configuration.getCredentials() == null ? GoogleCredentials.getApplicationDefault() : configuration.getCredentials();
                builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials, (Object)"credentials"))));
                builder.setEndpoint(configuration.getTraceServiceEndpoint());
                builder.setHeaderProvider(HEADER_PROVIDER);
            }
            return new InternalTraceExporter(projectId, new CloudTraceClientImpl(TraceServiceClient.create((TraceServiceSettings)builder.build())), configuration.getAttributeMapping(), configuration.getFixedAttributes());
        }
        return InternalTraceExporter.createWithClient(projectId, new CloudTraceClientImpl(TraceServiceClient.create((TraceServiceStub)stub)), configuration.getAttributeMapping(), configuration.getFixedAttributes());
    }

    InternalTraceExporter(String projectId, CloudTraceClient cloudTraceClient, ImmutableMap<String, String> attributeMappings, Map<String, AttributeValue> fixedAttributes) {
        this.projectId = projectId;
        this.cloudTraceClient = cloudTraceClient;
        this.projectName = ProjectName.of((String)projectId);
        this.translator = new TraceTranslator(attributeMappings, fixedAttributes);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode export(Collection<SpanData> spanDataList) {
        ArrayList<Span> spans = new ArrayList<Span>(spanDataList.size());
        for (SpanData spanData : spanDataList) {
            spans.add(this.translator.generateSpan(spanData, this.projectId));
        }
        this.cloudTraceClient.batchWriteSpans(this.projectName, spans);
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.cloudTraceClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }
}

