/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.opentelemetry.trace.CloudTraceClient;
import com.google.cloud.opentelemetry.trace.CloudTraceClientImpl;
import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.opentelemetry.trace.TraceTranslator;
import com.google.cloud.trace.v2.TraceServiceClient;
import com.google.cloud.trace.v2.TraceServiceSettings;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.ProjectName;
import com.google.devtools.cloudtrace.v2.Span;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.threeten.bp.Duration;

public class TraceExporter
implements SpanExporter {
    private final CloudTraceClient cloudTraceClient;
    private final ProjectName projectName;
    private final String projectId;
    private final Map<String, AttributeValue> fixedAttributes;

    public static TraceExporter createWithDefaultConfiguration() throws IOException {
        TraceConfiguration configuration = TraceConfiguration.builder().build();
        return TraceExporter.createWithConfiguration(configuration);
    }

    public static TraceExporter createWithConfiguration(TraceConfiguration configuration) throws IOException {
        String projectId = configuration.getProjectId();
        TraceServiceStub stub = configuration.getTraceServiceStub();
        if (stub == null) {
            GoogleCredentials credentials = configuration.getCredentials() == null ? GoogleCredentials.getApplicationDefault() : configuration.getCredentials();
            return TraceExporter.createWithCredentials(projectId, (Credentials)credentials, configuration.getFixedAttributes(), configuration.getDeadline());
        }
        return TraceExporter.createWithClient(projectId, new CloudTraceClientImpl(TraceServiceClient.create((TraceServiceStub)stub)), configuration.getFixedAttributes());
    }

    private static TraceExporter createWithClient(String projectId, CloudTraceClient cloudTraceClient, Map<String, AttributeValue> fixedAttributes) {
        return new TraceExporter(projectId, cloudTraceClient, fixedAttributes);
    }

    private static TraceExporter createWithCredentials(String projectId, Credentials credentials, Map<String, AttributeValue> fixedAttributes, java.time.Duration deadline) throws IOException {
        TraceServiceSettings.Builder builder = (TraceServiceSettings.Builder)TraceServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials, (Object)"credentials"))));
        builder.batchWriteSpansSettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)deadline.toMillis()));
        return new TraceExporter(projectId, new CloudTraceClientImpl(TraceServiceClient.create((TraceServiceSettings)builder.build())), fixedAttributes);
    }

    TraceExporter(String projectId, CloudTraceClient cloudTraceClient, Map<String, AttributeValue> fixedAttributes) {
        this.projectId = projectId;
        this.cloudTraceClient = cloudTraceClient;
        this.projectName = ProjectName.of((String)projectId);
        this.fixedAttributes = fixedAttributes;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofFailure();
    }

    public CompletableResultCode export(Collection<SpanData> spanDataList) {
        ArrayList<Span> spans = new ArrayList<Span>(spanDataList.size());
        for (SpanData spanData : spanDataList) {
            spans.add(TraceTranslator.generateSpan(spanData, this.projectId, this.fixedAttributes));
        }
        this.cloudTraceClient.batchWriteSpans(this.projectName, spans);
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.cloudTraceClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }
}

