/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.certprovider.CertProviderSslContextProvider;
import io.grpc.xds.internal.certprovider.CertificateProviderStore;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class CertProviderClientSslContextProvider
extends CertProviderSslContextProvider {
    private CertProviderClientSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, CertificateProviderStore certificateProviderStore) {
        super(node, certProviders, certInstance, Preconditions.checkNotNull(rootCertInstance, "Client SSL requires rootCertInstance"), staticCertValidationContext, upstreamTlsContext, certificateProviderStore);
    }

    @Override
    protected final SslContextBuilder getSslContextBuilder(CertificateValidationContext certificateValidationContextdationContext) throws CertStoreException {
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient().trustManager(new SdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContextdationContext));
        if (this.isMtls()) {
            sslContextBuilder.keyManager(this.savedKey, this.savedCertChain);
        }
        return sslContextBuilder;
    }

    @Internal
    public static final class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(CertificateProviderStore.getInstance());
        private final CertificateProviderStore certificateProviderStore;

        @VisibleForTesting
        public Factory(CertificateProviderStore certificateProviderStore) {
            this.certificateProviderStore = certificateProviderStore;
        }

        public static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        public CertProviderClientSslContextProvider getProvider(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders) {
            Preconditions.checkNotNull(upstreamTlsContext, "upstreamTlsContext");
            CommonTlsContext commonTlsContext = upstreamTlsContext.getCommonTlsContext();
            CertificateValidationContext staticCertValidationContext = CertProviderSslContextProvider.getStaticValidationContext(commonTlsContext);
            CommonTlsContext.CertificateProviderInstance rootCertInstance = CertProviderSslContextProvider.getRootCertProviderInstance(commonTlsContext);
            CommonTlsContext.CertificateProviderInstance certInstance = CertProviderSslContextProvider.getCertProviderInstance(commonTlsContext);
            return new CertProviderClientSslContextProvider(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, upstreamTlsContext, this.certificateProviderStore);
        }
    }
}

