/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.services.CallMetricRecorder;
import io.grpc.services.InternalCallMetricRecorder;
import io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import java.util.Map;

final class OrcaMetricReportingServerInterceptor
implements ServerInterceptor {
    private static final OrcaMetricReportingServerInterceptor INSTANCE = new OrcaMetricReportingServerInterceptor();
    @VisibleForTesting
    static final Metadata.Key<OrcaLoadReport> ORCA_ENDPOINT_LOAD_METRICS_KEY = Metadata.Key.of("x-endpoint-load-metrics-bin", ProtoUtils.metadataMarshaller(OrcaLoadReport.getDefaultInstance()));

    @VisibleForTesting
    OrcaMetricReportingServerInterceptor() {
    }

    public static OrcaMetricReportingServerInterceptor getInstance() {
        return INSTANCE;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context ctx = Context.current();
        CallMetricRecorder callMetricRecorder = InternalCallMetricRecorder.CONTEXT_KEY.get(ctx);
        if (callMetricRecorder == null) {
            callMetricRecorder = InternalCallMetricRecorder.newCallMetricRecorder();
            ctx = ctx.withValue(InternalCallMetricRecorder.CONTEXT_KEY, callMetricRecorder);
        }
        final CallMetricRecorder finalCallMetricRecorder = callMetricRecorder;
        ForwardingServerCall.SimpleForwardingServerCall trailerAttachingCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            @Override
            public void close(Status status, Metadata trailers) {
                Map<String, Double> metricValues = InternalCallMetricRecorder.finalizeAndDump(finalCallMetricRecorder);
                if (!metricValues.isEmpty()) {
                    OrcaLoadReport report = OrcaLoadReport.newBuilder().putAllRequestCost(metricValues).build();
                    trailers.put(ORCA_ENDPOINT_LOAD_METRICS_KEY, report);
                }
                super.close(status, trailers);
            }
        };
        return Contexts.interceptCall(ctx, trailerAttachingCall, headers, next);
    }
}

