/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.ChannelCredentials;
import io.grpc.Internal;
import io.grpc.xds.AutoValue_Bootstrapper_AuthorityInfo;
import io.grpc.xds.AutoValue_Bootstrapper_BootstrapInfo;
import io.grpc.xds.AutoValue_Bootstrapper_CertificateProviderInfo;
import io.grpc.xds.AutoValue_Bootstrapper_ServerInfo;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.XdsInitializationException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public abstract class Bootstrapper {
    static final String XDSTP_SCHEME = "xdstp:";

    public abstract BootstrapInfo bootstrap() throws XdsInitializationException;

    BootstrapInfo bootstrap(Map<String, ?> rawData) throws XdsInitializationException {
        throw new UnsupportedOperationException();
    }

    @AutoValue
    @Internal
    public static abstract class BootstrapInfo {
        abstract ImmutableList<ServerInfo> servers();

        public abstract EnvoyProtoData.Node node();

        @Nullable
        public abstract ImmutableMap<String, CertificateProviderInfo> certProviders();

        @Nullable
        public abstract String serverListenerResourceNameTemplate();

        abstract String clientDefaultListenerResourceNameTemplate();

        abstract ImmutableMap<String, AuthorityInfo> authorities();

        @VisibleForTesting
        static Builder builder() {
            return new AutoValue_Bootstrapper_BootstrapInfo.Builder().clientDefaultListenerResourceNameTemplate("%s").authorities(ImmutableMap.of());
        }

        @AutoValue.Builder
        @VisibleForTesting
        static abstract class Builder {
            Builder() {
            }

            abstract Builder servers(List<ServerInfo> var1);

            abstract Builder node(EnvoyProtoData.Node var1);

            abstract Builder certProviders(@Nullable Map<String, CertificateProviderInfo> var1);

            abstract Builder serverListenerResourceNameTemplate(@Nullable String var1);

            abstract Builder clientDefaultListenerResourceNameTemplate(String var1);

            abstract Builder authorities(Map<String, AuthorityInfo> var1);

            abstract BootstrapInfo build();
        }
    }

    @AutoValue
    static abstract class AuthorityInfo {
        AuthorityInfo() {
        }

        abstract String clientListenerResourceNameTemplate();

        abstract ImmutableList<ServerInfo> xdsServers();

        static AuthorityInfo create(String clientListenerResourceNameTemplate, List<ServerInfo> xdsServers) {
            Preconditions.checkArgument(!xdsServers.isEmpty(), "xdsServers must not be empty");
            return new AutoValue_Bootstrapper_AuthorityInfo(clientListenerResourceNameTemplate, ImmutableList.copyOf(xdsServers));
        }
    }

    @AutoValue
    @Internal
    public static abstract class CertificateProviderInfo {
        public abstract String pluginName();

        public abstract ImmutableMap<String, ?> config();

        @VisibleForTesting
        public static CertificateProviderInfo create(String pluginName, Map<String, ?> config) {
            return new AutoValue_Bootstrapper_CertificateProviderInfo(pluginName, ImmutableMap.copyOf(config));
        }
    }

    @AutoValue
    @Internal
    static abstract class ServerInfo {
        ServerInfo() {
        }

        abstract String target();

        abstract ChannelCredentials channelCredentials();

        abstract boolean useProtocolV3();

        @VisibleForTesting
        static ServerInfo create(String target, ChannelCredentials channelCredentials, boolean useProtocolV3) {
            return new AutoValue_Bootstrapper_ServerInfo(target, channelCredentials, useProtocolV3);
        }
    }
}

