/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.googleapis;

import io.grpc.Internal;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.googleapis.GoogleCloudToProdNameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.xds.InternalSharedXdsClientPoolProvider;
import java.net.URI;
import java.util.Map;

@Internal
public final class GoogleCloudToProdNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "google-c2p-experimental";

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return new GoogleCloudToProdNameResolver(targetUri, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, new SharedXdsClientPoolProviderBootstrapSetter());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 4;
    }

    private static final class SharedXdsClientPoolProviderBootstrapSetter
    implements GoogleCloudToProdNameResolver.BootstrapSetter {
        private SharedXdsClientPoolProviderBootstrapSetter() {
        }

        @Override
        public void setBootstrap(Map<String, ?> bootstrap) {
            InternalSharedXdsClientPoolProvider.setDefaultProviderBootstrapOverride(bootstrap);
        }
    }
}

