/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GroupName
implements ResourceName {
    private static final PathTemplate PROJECT_GROUP = PathTemplate.createWithoutUrlEncoding("projects/{project}/groups/{group}");
    private static final PathTemplate ORGANIZATION_GROUP = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/groups/{group}");
    private static final PathTemplate FOLDER_GROUP = PathTemplate.createWithoutUrlEncoding("folders/{folder}/groups/{group}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String group;
    private final String organization;
    private final String folder;

    @Deprecated
    protected GroupName() {
        this.project = null;
        this.group = null;
        this.organization = null;
        this.folder = null;
    }

    private GroupName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.group = Preconditions.checkNotNull(builder.getGroup());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_GROUP;
    }

    private GroupName(OrganizationGroupBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.group = Preconditions.checkNotNull(builder.getGroup());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_GROUP;
    }

    private GroupName(FolderGroupBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.group = Preconditions.checkNotNull(builder.getGroup());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_GROUP;
    }

    public String getProject() {
        return this.project;
    }

    public String getGroup() {
        return this.group;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectGroupBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationGroupBuilder newOrganizationGroupBuilder() {
        return new OrganizationGroupBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderGroupBuilder newFolderGroupBuilder() {
        return new FolderGroupBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GroupName of(String project, String group) {
        return GroupName.newBuilder().setProject(project).setGroup(group).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static GroupName ofProjectGroupName(String project, String group) {
        return GroupName.newBuilder().setProject(project).setGroup(group).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static GroupName ofOrganizationGroupName(String organization, String group) {
        return GroupName.newOrganizationGroupBuilder().setOrganization(organization).setGroup(group).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static GroupName ofFolderGroupName(String folder, String group) {
        return GroupName.newFolderGroupBuilder().setFolder(folder).setGroup(group).build();
    }

    public static String format(String project, String group) {
        return GroupName.newBuilder().setProject(project).setGroup(group).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectGroupName(String project, String group) {
        return GroupName.newBuilder().setProject(project).setGroup(group).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationGroupName(String organization, String group) {
        return GroupName.newOrganizationGroupBuilder().setOrganization(organization).setGroup(group).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderGroupName(String folder, String group) {
        return GroupName.newFolderGroupBuilder().setFolder(folder).setGroup(group).build().toString();
    }

    public static GroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_GROUP.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_GROUP.match(formattedString);
            return GroupName.ofProjectGroupName(matchMap.get("project"), matchMap.get("group"));
        }
        if (ORGANIZATION_GROUP.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_GROUP.match(formattedString);
            return GroupName.ofOrganizationGroupName(matchMap.get("organization"), matchMap.get("group"));
        }
        if (FOLDER_GROUP.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_GROUP.match(formattedString);
            return GroupName.ofFolderGroupName(matchMap.get("folder"), matchMap.get("group"));
        }
        throw new ValidationException("GroupName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<GroupName> parseList(List<String> formattedStrings) {
        ArrayList<GroupName> list = new ArrayList<GroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_GROUP.matches(formattedString) || ORGANIZATION_GROUP.matches(formattedString) || FOLDER_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GroupName groupName = this;
            synchronized (groupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.group != null) {
                        fieldMapBuilder.put("group", this.group);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GroupName that = (GroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.group, that.group) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.group);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderGroupBuilder {
        private String folder;
        private String group;

        protected FolderGroupBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getGroup() {
            return this.group;
        }

        public FolderGroupBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderGroupBuilder setGroup(String group) {
            this.group = group;
            return this;
        }

        public GroupName build() {
            return new GroupName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationGroupBuilder {
        private String organization;
        private String group;

        protected OrganizationGroupBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getGroup() {
            return this.group;
        }

        public OrganizationGroupBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationGroupBuilder setGroup(String group) {
            this.group = group;
            return this;
        }

        public GroupName build() {
            return new GroupName(this);
        }
    }

    public static class Builder {
        private String project;
        private String group;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getGroup() {
            return this.group;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        private Builder(GroupName groupName) {
            Preconditions.checkArgument(Objects.equals(groupName.pathTemplate, PROJECT_GROUP), "toBuilder is only supported when GroupName has the pattern of projects/{project}/groups/{group}");
            this.project = groupName.project;
            this.group = groupName.group;
        }

        public GroupName build() {
            return new GroupName(this);
        }
    }
}

