/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.cloudtrace.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpanName
implements ResourceName {
    private static final PathTemplate PROJECT_TRACE_SPAN = PathTemplate.createWithoutUrlEncoding("projects/{project}/traces/{trace}/spans/{span}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String trace;
    private final String span;

    @Deprecated
    protected SpanName() {
        this.project = null;
        this.trace = null;
        this.span = null;
    }

    private SpanName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.trace = Preconditions.checkNotNull(builder.getTrace());
        this.span = Preconditions.checkNotNull(builder.getSpan());
    }

    public String getProject() {
        return this.project;
    }

    public String getTrace() {
        return this.trace;
    }

    public String getSpan() {
        return this.span;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SpanName of(String project, String trace, String span) {
        return SpanName.newBuilder().setProject(project).setTrace(trace).setSpan(span).build();
    }

    public static String format(String project, String trace, String span) {
        return SpanName.newBuilder().setProject(project).setTrace(trace).setSpan(span).build().toString();
    }

    public static SpanName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_TRACE_SPAN.validatedMatch(formattedString, "SpanName.parse: formattedString not in valid format");
        return SpanName.of(matchMap.get("project"), matchMap.get("trace"), matchMap.get("span"));
    }

    public static List<SpanName> parseList(List<String> formattedStrings) {
        ArrayList<SpanName> list = new ArrayList<SpanName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SpanName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SpanName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SpanName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TRACE_SPAN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SpanName spanName = this;
            synchronized (spanName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.trace != null) {
                        fieldMapBuilder.put("trace", this.trace);
                    }
                    if (this.span != null) {
                        fieldMapBuilder.put("span", this.span);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_TRACE_SPAN.instantiate("project", this.project, "trace", this.trace, "span", this.span);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SpanName that = (SpanName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.trace, that.trace) && Objects.equals(this.span, that.span);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.trace);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.span);
    }

    public static class Builder {
        private String project;
        private String trace;
        private String span;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTrace() {
            return this.trace;
        }

        public String getSpan() {
            return this.span;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTrace(String trace) {
            this.trace = trace;
            return this;
        }

        public Builder setSpan(String span) {
            this.span = span;
            return this;
        }

        private Builder(SpanName spanName) {
            this.project = spanName.project;
            this.trace = spanName.trace;
            this.span = spanName.span;
        }

        public SpanName build() {
            return new SpanName(this);
        }
    }
}

