/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.trace.v2.stub.GrpcTraceServiceStub;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.cloudtrace.v2.BatchWriteSpansRequest;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TraceServiceStubSettings
extends StubSettings<TraceServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/trace.append")).build();
    private final UnaryCallSettings<BatchWriteSpansRequest, Empty> batchWriteSpansSettings;
    private final UnaryCallSettings<Span, Span> createSpanSettings;

    public UnaryCallSettings<BatchWriteSpansRequest, Empty> batchWriteSpansSettings() {
        return this.batchWriteSpansSettings;
    }

    public UnaryCallSettings<Span, Span> createSpanSettings() {
        return this.createSpanSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TraceServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTraceServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudtrace.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudtrace.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TraceServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TraceServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TraceServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.batchWriteSpansSettings = settingsBuilder.batchWriteSpansSettings().build();
        this.createSpanSettings = settingsBuilder.createSpanSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TraceServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<BatchWriteSpansRequest, Empty> batchWriteSpansSettings;
        private final UnaryCallSettings.Builder<Span, Span> createSpanSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.batchWriteSpansSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSpanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.batchWriteSpansSettings, this.createSpanSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TraceServiceStubSettings settings) {
            super(settings);
            this.batchWriteSpansSettings = settings.batchWriteSpansSettings.toBuilder();
            this.createSpanSettings = settings.createSpanSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.batchWriteSpansSettings, this.createSpanSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TraceServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(TraceServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(TraceServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TraceServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TraceServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.batchWriteSpansSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_0_params"));
            builder.createSpanSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<BatchWriteSpansRequest, Empty> batchWriteSpansSettings() {
            return this.batchWriteSpansSettings;
        }

        public UnaryCallSettings.Builder<Span, Span> createSpanSettings() {
            return this.createSpanSettings;
        }

        public TraceServiceStubSettings build() throws IOException {
            return new TraceServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("no_retry_0_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("retry_policy_1_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED)));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(120000L)).setTotalTimeout(Duration.ofMillis(120000L)).build();
            definitions.put("no_retry_0_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis(1000L)).setInitialRpcTimeout(Duration.ofMillis(120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(120000L)).setTotalTimeout(Duration.ofMillis(120000L)).build();
            definitions.put("retry_policy_1_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

