/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.cloud.opentelemetry.resource.GcpResource;
import com.google.cloud.opentelemetry.resource.ResourceTranslator;
import com.google.cloud.opentelemetry.trace.TraceVersions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.devtools.cloudtrace.v2.SpanName;
import com.google.devtools.cloudtrace.v2.TruncatableString;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Timestamp;
import com.google.rpc.Code;
import com.google.rpc.Status;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class TraceTranslator {
    private static final String AGENT_LABEL_KEY = "g.co/agent";
    private static final String AGENT_LABEL_VALUE_STRING = "opentelemetry-java " + TraceVersions.SDK_VERSION + "; google-cloud-trace-exporter " + TraceVersions.EXPORTER_VERSION;
    private static final AttributeValue AGENT_LABEL_VALUE = AttributeValue.newBuilder().setStringValue(TraceTranslator.toTruncatableStringProto(AGENT_LABEL_VALUE_STRING)).build();
    private static final String SERVER_PREFIX = "Recv.";
    private static final String CLIENT_PREFIX = "Sent.";
    private static final String INSTRUMENTATION_LIBRARY_NAME_KEY = "otel.scope.name";
    private static final String INSTRUMENTATION_LIBRARY_VERSION_KEY = "otel.scope.version";
    private final ImmutableMap<String, String> attributeMapping;
    private final Map<String, AttributeValue> fixedAttributes;

    TraceTranslator(ImmutableMap<String, String> attributeMapping, Map<String, AttributeValue> fixedAttributes) {
        this.attributeMapping = attributeMapping;
        this.fixedAttributes = fixedAttributes;
    }

    @VisibleForTesting
    TraceTranslator() {
        this(ImmutableMap.of(), Collections.emptyMap());
    }

    @VisibleForTesting
    Span generateSpan(SpanData spanData, String projectId) {
        boolean hasRemoteParent;
        long end;
        Status statusProto;
        String traceId = spanData.getTraceId();
        String spanId = spanData.getSpanId();
        HashMap<String, AttributeValue> extraAttributes = new HashMap<String, AttributeValue>(this.fixedAttributes);
        if (spanData.getInstrumentationLibraryInfo().getName() != null) {
            extraAttributes.put(INSTRUMENTATION_LIBRARY_NAME_KEY, TraceTranslator.toAttributeValueString(spanData.getInstrumentationLibraryInfo().getName()));
        }
        if (spanData.getInstrumentationLibraryInfo().getVersion() != null) {
            extraAttributes.put(INSTRUMENTATION_LIBRARY_VERSION_KEY, TraceTranslator.toAttributeValueString(spanData.getInstrumentationLibraryInfo().getVersion()));
        }
        TraceTranslator.insertResourceAttributes(spanData.getResource(), extraAttributes);
        extraAttributes.put(AGENT_LABEL_KEY, AGENT_LABEL_VALUE);
        SpanName spanName = SpanName.newBuilder().setProject(projectId).setTrace(traceId).setSpan(spanId).build();
        Span.Builder spanBuilder = Span.newBuilder().setName(spanName.toString()).setSpanId(spanId).setDisplayName(TraceTranslator.toTruncatableStringProto(TraceTranslator.toDisplayName(spanData.getName(), spanData.getKind()))).setStartTime(TraceTranslator.toTimestampProto(spanData.getStartEpochNanos())).setAttributes(this.toAttributesProto(spanData.getAttributes(), extraAttributes)).setTimeEvents(this.toTimeEventsProto(spanData.getEvents()));
        StatusData status = spanData.getStatus();
        if (status != null && (statusProto = TraceTranslator.toStatusProto(status)) != null) {
            spanBuilder.setStatus(statusProto);
        }
        if ((end = spanData.getEndEpochNanos()) != 0L) {
            spanBuilder.setEndTime(TraceTranslator.toTimestampProto(end));
        }
        spanBuilder.setLinks(this.toLinksProto(spanData.getLinks(), spanData.getTotalRecordedLinks()));
        if (spanData.getParentSpanId() != null) {
            spanBuilder.setParentSpanId(spanData.getParentSpanId());
        }
        spanBuilder.setSameProcessAsParentSpan(BoolValue.of(!(hasRemoteParent = spanData.getParentSpanContext().isRemote())));
        return spanBuilder.build();
    }

    @VisibleForTesting
    static void insertResourceAttributes(Resource resource, Map<String, AttributeValue> accumulator) {
        GcpResource gcpResource = ResourceTranslator.mapResource(resource);
        gcpResource.getResourceLabels().getLabels().forEach((k, v) -> accumulator.put("g.co/r/" + gcpResource.getResourceType() + "/" + k, TraceTranslator.toAttributeValueString(v)));
        resource.getAttributes().forEach((key, value) -> {
            if (!accumulator.containsKey(key.getKey())) {
                accumulator.put(key.getKey(), TraceTranslator.toAttributeValueProto(key, value));
            }
        });
    }

    @VisibleForTesting
    static String toDisplayName(String spanName, @Nullable SpanKind spanKind) {
        if (spanKind == SpanKind.SERVER && !spanName.startsWith(SERVER_PREFIX)) {
            return SERVER_PREFIX + spanName;
        }
        if (spanKind == SpanKind.CLIENT && !spanName.startsWith(CLIENT_PREFIX)) {
            return CLIENT_PREFIX + spanName;
        }
        return spanName;
    }

    @VisibleForTesting
    static TruncatableString toTruncatableStringProto(String string) {
        return TruncatableString.newBuilder().setValue(string).setTruncatedByteCount(0).build();
    }

    @VisibleForTesting
    static Timestamp toTimestampProto(long epochNanos) {
        long seconds = TimeUnit.NANOSECONDS.toSeconds(epochNanos);
        int nanos = (int)(epochNanos - TimeUnit.SECONDS.toNanos(seconds));
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }

    @VisibleForTesting
    Span.Attributes toAttributesProto(Attributes attributes, Map<String, AttributeValue> extraAttributes) {
        Span.Attributes.Builder attributesBuilder = this.toAttributesBuilderProto(attributes);
        extraAttributes.forEach((key, value) -> {
            if (!attributesBuilder.getAttributeMapMap().containsKey(key)) {
                attributesBuilder.putAttributeMap((String)key, (AttributeValue)value);
            }
        });
        return attributesBuilder.build();
    }

    private Span.Attributes.Builder toAttributesBuilderProto(Attributes attributes) {
        Span.Attributes.Builder attributesBuilder = Span.Attributes.newBuilder().setDroppedAttributesCount(0);
        attributes.forEach((key, value) -> attributesBuilder.putAttributeMap(this.mapKey((AttributeKey)key), TraceTranslator.toAttributeValueProto(key, value)));
        return attributesBuilder;
    }

    private static <T> AttributeValue toAttributeValueProto(AttributeKey<?> key, Object value) {
        AttributeValue.Builder builder = AttributeValue.newBuilder();
        switch (key.getType()) {
            case STRING: {
                builder.setStringValue(TraceTranslator.toTruncatableStringProto((String)value));
                break;
            }
            case BOOLEAN: {
                builder.setBoolValue((Boolean)value);
                break;
            }
            case LONG: {
                builder.setIntValue((Long)value);
                break;
            }
            case DOUBLE: {
                builder.setStringValue(TraceTranslator.toTruncatableStringProto(String.valueOf(value)));
                break;
            }
            case STRING_ARRAY: 
            case BOOLEAN_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: {
                builder.setStringValue(TraceTranslator.toTruncatableStringProto(TraceTranslator.jsonString((List)value)));
            }
        }
        return builder.build();
    }

    private static AttributeValue toAttributeValueString(String value) {
        return AttributeValue.newBuilder().setStringValue(TraceTranslator.toTruncatableStringProto(value)).build();
    }

    private static String jsonString(List<?> values) {
        StringBuilder result = new StringBuilder("[");
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                result.append(',');
            }
            result.append(value.toString());
            first = false;
        }
        result.append("]");
        return result.toString();
    }

    private <T> String mapKey(AttributeKey<T> key) {
        if (this.attributeMapping.containsKey(key.getKey())) {
            return this.attributeMapping.get(key.getKey());
        }
        return key.getKey();
    }

    @VisibleForTesting
    Span.TimeEvents toTimeEventsProto(List<EventData> events) {
        Span.TimeEvents.Builder timeEventsBuilder = Span.TimeEvents.newBuilder();
        for (EventData event : events) {
            timeEventsBuilder.addTimeEvent(Span.TimeEvent.newBuilder().setTime(TraceTranslator.toTimestampProto(event.getEpochNanos())).setAnnotation(Span.TimeEvent.Annotation.newBuilder().setDescription(TraceTranslator.toTruncatableStringProto(event.getName())).setAttributes(this.toAttributesProto(event.getAttributes(), Collections.emptyMap()))));
        }
        return timeEventsBuilder.build();
    }

    @VisibleForTesting
    static Status toStatusProto(StatusData status) {
        Status.Builder statusBuilder = Status.newBuilder();
        StatusCode statusCode = status.getStatusCode();
        switch (statusCode) {
            case OK: {
                statusBuilder.setCode(Code.OK.getNumber());
                break;
            }
            case UNSET: {
                return null;
            }
            case ERROR: {
                statusBuilder.setCode(2);
                if (status.getDescription() == null) break;
                statusBuilder.setMessage(status.getDescription());
                break;
            }
            default: {
                statusBuilder.setCode(Code.UNKNOWN.getNumber());
            }
        }
        return statusBuilder.build();
    }

    @VisibleForTesting
    Span.Links toLinksProto(List<LinkData> links, int totalRecordedLinks) {
        Span.Links.Builder linksBuilder = Span.Links.newBuilder().setDroppedLinksCount(Math.max(0, totalRecordedLinks - links.size()));
        for (LinkData link : links) {
            linksBuilder.addLink(this.toLinkProto(link));
        }
        return linksBuilder.build();
    }

    private Span.Link toLinkProto(LinkData link) {
        Preconditions.checkNotNull(link);
        return Span.Link.newBuilder().setTraceId(link.getSpanContext().getTraceId()).setSpanId(link.getSpanContext().getSpanId()).setType(Span.Link.Type.TYPE_UNSPECIFIED).setAttributes(this.toAttributesBuilderProto(link.getAttributes())).build();
    }

    @VisibleForTesting
    static Map<String, AttributeValue> getResourceLabels(Map<String, String> resource) {
        if (resource == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, AttributeValue> resourceLabels = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, String> entry : resource.entrySet()) {
            TraceTranslator.putToResourceAttributeMap(resourceLabels, entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(resourceLabels);
    }

    private static void putToResourceAttributeMap(Map<String, AttributeValue> map, String attributeName, String attributeValue) {
        map.put(TraceTranslator.createResourceLabelKey(attributeName), TraceTranslator.toStringAttributeValueProto(attributeValue));
    }

    @VisibleForTesting
    static String createResourceLabelKey(String resourceAttribute) {
        return "g.co/r/" + resourceAttribute;
    }

    @VisibleForTesting
    static AttributeValue toStringAttributeValueProto(String value) {
        return AttributeValue.newBuilder().setStringValue(TraceTranslator.toTruncatableStringProto(value)).build();
    }
}

